/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem.network.client;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import tamaized.melongolem.network.NetworkMessages;

public class ClientPacketHandlerParticle
implements NetworkMessages.IMessage<ClientPacketHandlerParticle> {
    private ResourceLocation id;
    private Vec3d vec;
    private Vec3d vel;

    public ClientPacketHandlerParticle(ResourceLocation particle, Vec3d pos, Vec3d vel) {
        this.id = particle;
        this.vec = pos;
        this.vel = vel;
    }

    public static void spawnParticle(World world, IParticleData particle, Vec3d pos, Vec3d vel) {
        world.func_195594_a(particle, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, vel.field_72450_a, vel.field_72448_b, vel.field_72449_c);
    }

    private static IParticleData getRegisteredParticleTypes(ResourceLocation p_197589_0_) {
        ParticleType t = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(p_197589_0_);
        if (!(t instanceof IParticleData)) {
            throw new IllegalStateException("Invalid or unknown particle type: " + p_197589_0_);
        }
        return (IParticleData)t;
    }

    @Override
    public void handle(PlayerEntity player) {
        ClientPacketHandlerParticle.spawnParticle(player.field_70170_p, ClientPacketHandlerParticle.getRegisteredParticleTypes(this.id), this.vec, this.vel);
    }

    @Override
    public void toBytes(PacketBuffer packet) {
        packet.func_192572_a(this.id);
        packet.writeDouble(this.vec.field_72450_a);
        packet.writeDouble(this.vec.field_72448_b);
        packet.writeDouble(this.vec.field_72449_c);
        packet.writeDouble(this.vel.field_72450_a);
        packet.writeDouble(this.vel.field_72448_b);
        packet.writeDouble(this.vel.field_72449_c);
    }

    @Override
    public ClientPacketHandlerParticle fromBytes(PacketBuffer packet) {
        this.id = packet.func_192575_l();
        this.vec = new Vec3d(packet.readDouble(), packet.readDouble(), packet.readDouble());
        this.vel = new Vec3d(packet.readDouble(), packet.readDouble(), packet.readDouble());
        return this;
    }
}

