/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem.network.client;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import tamaized.melongolem.network.NetworkMessages;

public class ClientPacketHandlerSpawnNonLivingEntity
implements NetworkMessages.IMessage<ClientPacketHandlerSpawnNonLivingEntity> {
    private int entityId;
    private UUID uniqueId;
    private double x;
    private double y;
    private double z;
    private int speedX;
    private int speedY;
    private int speedZ;
    private int pitch;
    private int yaw;
    private EntityType<?> type;

    public ClientPacketHandlerSpawnNonLivingEntity(Entity entity) {
        this.entityId = entity.func_145782_y();
        this.uniqueId = entity.func_110124_au();
        this.x = entity.field_70165_t;
        this.y = entity.field_70163_u;
        this.z = entity.field_70161_v;
        this.pitch = MathHelper.func_76141_d((float)(entity.field_70125_A * 256.0f / 360.0f));
        this.yaw = MathHelper.func_76141_d((float)(entity.field_70177_z * 256.0f / 360.0f));
        this.type = entity.func_200600_R();
        Vec3d motion = entity.func_213322_ci();
        this.speedX = (int)(MathHelper.func_151237_a((double)motion.field_72450_a, (double)-3.9, (double)3.9) * 8000.0);
        this.speedY = (int)(MathHelper.func_151237_a((double)motion.field_72448_b, (double)-3.9, (double)3.9) * 8000.0);
        this.speedZ = (int)(MathHelper.func_151237_a((double)motion.field_72449_c, (double)-3.9, (double)3.9) * 8000.0);
    }

    @Override
    public void handle(PlayerEntity player) {
        World world = player.field_70170_p;
        Entity entity = this.type.func_200721_a(world);
        Objects.requireNonNull(entity).func_213312_b(this.x, this.y, this.z);
        entity.func_213293_j((double)this.speedX, (double)this.speedY, (double)this.speedZ);
        entity.field_70125_A = (float)(this.pitch * 360) / 256.0f;
        entity.field_70177_z = (float)(this.yaw * 360) / 256.0f;
        entity.func_145769_d(this.entityId);
        entity.func_184221_a(this.uniqueId);
        ((ClientWorld)world).func_217411_a(this.entityId, entity);
    }

    @Override
    public void toBytes(PacketBuffer packet) {
        packet.func_150787_b(this.entityId);
        packet.func_179252_a(this.uniqueId);
        packet.func_150787_b(Registry.field_212629_r.func_148757_b(this.type));
        packet.writeDouble(this.x);
        packet.writeDouble(this.y);
        packet.writeDouble(this.z);
        packet.writeByte(this.pitch);
        packet.writeByte(this.yaw);
        packet.writeShort(this.speedX);
        packet.writeShort(this.speedY);
        packet.writeShort(this.speedZ);
    }

    @Override
    public ClientPacketHandlerSpawnNonLivingEntity fromBytes(PacketBuffer packet) {
        this.entityId = packet.func_150792_a();
        this.uniqueId = packet.func_179253_g();
        this.type = (EntityType)Registry.field_212629_r.func_148745_a(packet.func_150792_a());
        this.x = packet.readDouble();
        this.y = packet.readDouble();
        this.z = packet.readDouble();
        this.pitch = packet.readByte();
        this.yaw = packet.readByte();
        this.speedX = packet.readShort();
        this.speedY = packet.readShort();
        this.speedZ = packet.readShort();
        return this;
    }
}

