/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tamaized.melongolem.ClientProxy;
import tamaized.melongolem.IModProxy;
import tamaized.melongolem.MelonConfig;
import tamaized.melongolem.ServerProxy;
import tamaized.melongolem.client.MelonConfigScreen;
import tamaized.melongolem.common.EntityGlisteringMelonGolem;
import tamaized.melongolem.common.EntityMelonGolem;
import tamaized.melongolem.common.EntityMelonSlice;
import tamaized.melongolem.common.EntityTinyMelonGolem;
import tamaized.melongolem.common.ItemMelonStick;
import tamaized.melongolem.common.capability.ITinyGolemCapability;
import tamaized.melongolem.common.capability.TinyGolemCapabilityHandler;
import tamaized.melongolem.common.capability.TinyGolemCapabilityStorage;
import tamaized.melongolem.network.DonatorHandler;
import tamaized.melongolem.network.NetworkMessages;
import tamaized.melongolem.network.client.ClientPacketHandlerSpawnNonLivingEntity;

@Mod(value="melongolem")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MelonMod {
    public static final String MODID = "melongolem";
    public static final IModProxy proxy = (IModProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static MelonConfig config;
    public static final SimpleChannel network;
    public static final Logger logger;
    @ObjectHolder(value="melongolem:melonstick")
    public static final Item melonStick;
    @ObjectHolder(value="melongolem:glisteringmelonblock")
    public static final Block glisteringMelonBlock;
    public static final EntityType<? extends GolemEntity> entityTypeMelonGolem;
    public static final EntityType<? extends GolemEntity> entityTypeGlisteringMelonGolem;
    @ObjectHolder(value="melongolem:entitymelonslice")
    public static final EntityType<? extends EntityMelonSlice> entityTypeMelonSlice;
    @ObjectHolder(value="melongolem:entitytinymelongolem")
    public static final EntityType<? extends TameableEntity> entityTypeTinyMelonGolem;
    public static final ImmutableSet<Item> SIGNS;

    public MelonMod() {
        Pair specPair = new ForgeConfigSpec.Builder().configure(MelonConfig::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (ForgeConfigSpec)specPair.getRight());
        config = (MelonConfig)specPair.getLeft();
        DonatorHandler.start();
        ModList.get().getMods().replaceAll(modInfo -> !modInfo.getModId().equalsIgnoreCase(MODID) ? modInfo : new ModInfo(modInfo.getOwningFile(), modInfo.getModConfig()){

            public boolean hasConfigUI() {
                return true;
            }
        });
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> MelonConfigScreen::new);
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{entityTypeMelonGolem, MelonMod.assign(EntityMelonSlice.class, 0.25f, 0.25f, 128, 1, true, EntityClassification.MISC), MelonMod.assign(EntityTinyMelonGolem.class, 0.175f, 0.475f, 128, 1, true, EntityClassification.CREATURE), entityTypeGlisteringMelonGolem});
    }

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent e) {
        ClientProxy.registerRenders();
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{MelonMod.assign(new Block(Block.Properties.func_200949_a((Material)Material.field_151572_C, (MaterialColor)MaterialColor.field_151672_u).func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a).func_200951_a(4)), "glisteringmelonblock")});
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{MelonMod.assign(new ItemMelonStick(new Item.Properties().func_200916_a(ItemGroup.field_78026_f)), "melonstick"), MelonMod.assign(glisteringMelonBlock), MelonMod.assign((Item)new SpawnEggItem(entityTypeMelonGolem, 65280, 0, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)), "melongolemspawnegg"), MelonMod.assign((Item)new SpawnEggItem(entityTypeGlisteringMelonGolem, 0xAAFF00, 0xFFCC00, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)), "glisteringmelongolemspawnegg")});
    }

    private static Block assign(Block block, String name) {
        return (Block)block.setRegistryName(MODID, name);
    }

    private static BlockItem assign(Block block) {
        return (BlockItem)new BlockItem(block, new Item.Properties().setNoRepair().func_200916_a(ItemGroup.field_78026_f)).setRegistryName(Objects.requireNonNull(block.getRegistryName()));
    }

    private static Item assign(Item item, String name) {
        return (Item)item.setRegistryName(MODID, name);
    }

    private static <T extends Entity> EntityType<T> assign(Class<T> entity, float w, float h, int range, int freq, boolean updates, EntityClassification classification) {
        String name = entity.getSimpleName().toLowerCase();
        EntityType type = EntityType.Builder.func_220322_a((et, world) -> {
            try {
                return (Entity)entity.getConstructor(World.class).newInstance(world);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }, (EntityClassification)classification).setTrackingRange(range).setUpdateInterval(freq).setShouldReceiveVelocityUpdates(updates).func_220321_a(w, h).func_206830_a(name);
        type.setRegistryName(MODID, name);
        return type;
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(ITinyGolemCapability.class, (Capability.IStorage)new TinyGolemCapabilityStorage(), TinyGolemCapabilityHandler::new);
        NetworkMessages.register(network);
        proxy.init();
    }

    @SubscribeEvent
    public static void init(FMLLoadCompleteEvent event) {
        MelonConfig.setupStabby();
        MelonConfig.setupColor();
        proxy.finish();
    }

    private static <T> T getNull() {
        return null;
    }

    public static void spawnNonLivingEntity(World world, Entity entity) {
        world.func_217376_c(entity);
        network.send(PacketDistributor.TRACKING_CHUNK.with(() -> world.func_212866_a_(entity.field_70176_ah, entity.field_70164_aj)), (Object)new ClientPacketHandlerSpawnNonLivingEntity(entity));
    }

    static {
        network = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(MODID, MODID)).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> "1").simpleChannel();
        logger = LogManager.getLogger((String)MODID);
        melonStick = Items.field_190931_a;
        glisteringMelonBlock = Blocks.field_150350_a;
        entityTypeMelonGolem = MelonMod.assign(EntityMelonGolem.class, 0.7f, 1.9f, 128, 1, true, EntityClassification.CREATURE);
        entityTypeGlisteringMelonGolem = MelonMod.assign(EntityGlisteringMelonGolem.class, 0.7f, 1.9f, 128, 1, true, EntityClassification.CREATURE);
        entityTypeMelonSlice = (EntityType)MelonMod.getNull();
        entityTypeTinyMelonGolem = (EntityType)MelonMod.getNull();
        SIGNS = ImmutableSet.of((Object)Items.field_222075_kv, (Object)Items.field_222073_kt, (Object)Items.field_222076_kw, (Object)Items.field_222074_ku, (Object)Items.field_222074_ku, (Object)Items.field_222071_kr, (Object[])new Item[]{Items.field_222072_ks});
    }
}

