/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem.client;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tamaized.melongolem.MelonMod;

@Mod.EventBusSubscriber(modid="melongolem", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModelBakeListener {
    @SubscribeEvent
    public static void modelBake(ModelBakeEvent event) {
        for (int i = 0; i <= 1; ++i) {
            ModelResourceLocation mrl = new ModelResourceLocation(Objects.requireNonNull(MelonMod.glisteringMelonBlock.getRegistryName()), i == 0 ? "" : "inventory");
            final IBakedModel model = (IBakedModel)event.getModelRegistry().get(mrl);
            event.getModelRegistry().put(mrl, new IBakedModel(){
                private Map<Direction, List<BakedQuad>> cachedQuads = Maps.newHashMap();

                @Nonnull
                public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand) {
                    return this.cachedQuads.computeIfAbsent(side, face -> {
                        List quads = model.func_200117_a(state, side, rand);
                        for (BakedQuad quad : quads) {
                            if (quads.indexOf(quad) != 1) continue;
                            LightUtil.setLightData((BakedQuad)quad, (int)0xF000F0);
                        }
                        return quads;
                    });
                }

                public boolean func_177555_b() {
                    return model.func_177555_b();
                }

                public boolean func_177556_c() {
                    return model.func_177556_c();
                }

                public boolean func_230044_c_() {
                    return model.func_230044_c_();
                }

                public boolean func_188618_c() {
                    return model.func_188618_c();
                }

                @Nonnull
                public TextureAtlasSprite func_177554_e() {
                    return model.func_177554_e();
                }

                @Nonnull
                public ItemOverrideList func_188617_f() {
                    return model.func_188617_f();
                }

                @Nonnull
                public ItemCameraTransforms func_177552_f() {
                    return model.func_177552_f();
                }
            });
        }
    }
}

