/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.SnowManModel;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import tamaized.melongolem.client.LayerMelonHead;
import tamaized.melongolem.common.EntityTinyMelonGolem;

@OnlyIn(value=Dist.CLIENT)
public class RenderMelonGolem<T extends MobEntity>
extends MobRenderer<T, SnowManModel<T>> {
    private static final ResourceLocation TEXTURES = new ResourceLocation("melongolem", "textures/entity/golem.png");
    private static final ResourceLocation TEXTURES_GREY = new ResourceLocation("melongolem", "textures/entity/greygolem.png");
    private static final ResourceLocation TEXTURES_GLISTER = new ResourceLocation("melongolem", "textures/entity/glistening_melon_golem.png");
    private static final ResourceLocation TEXTURES_GLISTER_OVERLAY = new ResourceLocation("melongolem", "textures/entity/glistening_melon_golem_overlay.png");
    private static final ColorHack COLOR_STATE = new ColorHack();
    private final Type type;

    public RenderMelonGolem(EntityRendererManager renderManagerIn, Type type) {
        super(renderManagerIn, (EntityModel)new SnowManModel(){

            public void func_225598_a_(@Nonnull MatrixStack stack, @Nonnull IVertexBuilder buffer, int p_225598_3_, int p_225598_4_, float red, float green, float blue, float alpha) {
                super.func_225598_a_(stack, buffer, p_225598_3_, p_225598_4_, COLOR_STATE.red, COLOR_STATE.green, COLOR_STATE.blue, alpha);
            }
        }, type == Type.TINY ? 0.125f : 0.5f);
        this.func_177094_a(new LayerMelonHead(this));
        if (type == Type.GLISTER) {
            this.func_177094_a(new LayerMelonGlister(this));
        }
        this.type = type;
    }

    public void func_225623_a_(T entity, float rotation, float partialTicks, @Nonnull MatrixStack stack, @Nonnull IRenderTypeBuffer buffer, int light) {
        EntityTinyMelonGolem golem;
        stack.func_227860_a_();
        if (this.type == Type.TINY && (golem = (EntityTinyMelonGolem)entity).isEnabled()) {
            int color = golem.getColor();
            COLOR_STATE.red = (float)(color >> 16 & 0xFF) / 255.0f;
            COLOR_STATE.green = (float)(color >> 8 & 0xFF) / 255.0f;
            COLOR_STATE.blue = (float)(color & 0xFF) / 255.0f;
        }
        super.func_225623_a_(entity, rotation, partialTicks, stack, buffer, light);
        stack.func_227865_b_();
    }

    @Nonnull
    public ResourceLocation getEntityTexture(@Nonnull T entity) {
        return entity instanceof EntityTinyMelonGolem && ((EntityTinyMelonGolem)entity).isEnabled() ? TEXTURES_GREY : (this.type == Type.GLISTER ? TEXTURES_GLISTER : TEXTURES);
    }

    protected void preRenderCallback(T p_225620_1_, MatrixStack p_225620_2_, float p_225620_3_) {
        if (this.type == Type.TINY) {
            p_225620_2_.func_227862_a_(0.25f, 0.25f, 0.25f);
        }
    }

    class LayerMelonGlister<E extends T>
    extends LayerRenderer<E, SnowManModel<E>> {
        public LayerMelonGlister(IEntityRenderer<E, SnowManModel<E>> p_i50926_1_) {
            super(p_i50926_1_);
        }

        public void render(@Nonnull MatrixStack stack, @Nonnull IRenderTypeBuffer buffer, int light, @Nonnull E entity, float limbSwing, float limbSwingAmount, float partialTicks, float rotation, float yawHead, float pitch) {
            IVertexBuilder builder = buffer.getBuffer(RenderType.func_228636_a_((ResourceLocation)TEXTURES_GLISTER_OVERLAY, (float)0.0f, (float)0.0f));
            stack.func_227860_a_();
            float s = 1.01f;
            stack.func_227862_a_(1.01f, 1.01f, 1.01f);
            ((SnowManModel)this.func_215332_c()).func_225598_a_(stack, builder, 0xF000F0, LivingRenderer.func_229117_c_(entity, (float)RenderMelonGolem.this.func_225625_b_(entity, partialTicks)), 1.0f, 1.0f, 1.0f, !RenderMelonGolem.this.func_225622_a_(entity) && !entity.func_98034_c((PlayerEntity)Objects.requireNonNull(Minecraft.func_71410_x().field_71439_g)) ? 0.15f : 1.0f);
            stack.func_227865_b_();
        }
    }

    public static class Factory {
        public static RenderMelonGolem normal(EntityRendererManager renderManager) {
            return new RenderMelonGolem(renderManager, Type.NORMAL);
        }

        public static RenderMelonGolem tiny(EntityRendererManager renderManager) {
            return new RenderMelonGolem(renderManager, Type.TINY);
        }

        public static RenderMelonGolem glister(EntityRendererManager renderManager) {
            return new RenderMelonGolem(renderManager, Type.GLISTER);
        }
    }

    private static class ColorHack {
        private float red = 1.0f;
        private float green = 1.0f;
        private float blue = 1.0f;
        private float alpha = 1.0f;

        private ColorHack() {
        }
    }

    public static enum Type {
        NORMAL,
        TINY,
        GLISTER;

    }
}

