/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem.common;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShearsItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import tamaized.melongolem.IModProxy;
import tamaized.melongolem.MelonMod;
import tamaized.melongolem.MelonSounds;
import tamaized.melongolem.common.EntityGlisteringMelonGolem;
import tamaized.melongolem.common.EntityMelonSlice;
import tamaized.melongolem.common.capability.CapabilityList;
import tamaized.melongolem.network.client.ClientPacketHandlerMelonTTS;

public class EntityMelonGolem
extends GolemEntity
implements IRangedAttackMob,
IShearable,
IEntityAdditionalSpawnData,
IModProxy.ISignHolder {
    public static BlockState SIGN_TILE_BLOCKSTATE = Blocks.field_222392_ch.func_176223_P();
    public static final SignTileEntity te = new SignTileEntity(){

        @Nonnull
        public BlockState func_195044_w() {
            return SIGN_TILE_BLOCKSTATE;
        }
    };
    private static final DataParameter<ItemStack> HEAD = EntityDataManager.func_187226_a(EntityMelonGolem.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final List<DataParameter<ITextComponent>> SIGN_TEXT = Lists.newArrayList((Object[])new DataParameter[]{EntityDataManager.func_187226_a(EntityMelonGolem.class, (IDataSerializer)DataSerializers.field_187195_e), EntityDataManager.func_187226_a(EntityMelonGolem.class, (IDataSerializer)DataSerializers.field_187195_e), EntityDataManager.func_187226_a(EntityMelonGolem.class, (IDataSerializer)DataSerializers.field_187195_e), EntityDataManager.func_187226_a(EntityMelonGolem.class, (IDataSerializer)DataSerializers.field_187195_e)});
    private final float pitch;

    public EntityMelonGolem(World worldIn) {
        this(Objects.requireNonNull(MelonMod.entityTypeMelonGolem), worldIn);
    }

    protected EntityMelonGolem(EntityType<? extends GolemEntity> p_i48569_1_, World p_i48569_2_) {
        super(p_i48569_1_, p_i48569_2_);
        this.pitch = this.field_70146_Z.nextFloat() * 3.0f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HEAD, (Object)ItemStack.field_190927_a);
        for (DataParameter<ITextComponent> sign : SIGN_TEXT) {
            this.field_70180_af.func_187214_a(sign, (Object)new StringTextComponent(""));
        }
    }

    @Override
    public void setSignText(int index, ITextComponent text) {
        this.field_70180_af.func_187227_b(SIGN_TEXT.get(index), (Object)text);
    }

    @Override
    public int networkID() {
        return this.func_145782_y();
    }

    @Override
    public ITextComponent getSignText(int index) {
        return (ITextComponent)this.field_70180_af.func_187225_a(SIGN_TEXT.get(index));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.25, 20, 10.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new EntityAISearchAndEatMelons((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 1.0000001E-5f));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 10, true, false, e -> e instanceof IMob));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(((Double)MelonMod.config.health.get()).doubleValue());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
    }

    public void func_82196_d(@Nonnull LivingEntity target, float distanceFactor) {
        EntityMelonSlice slice = new EntityMelonSlice(this.field_70170_p, (LivingEntity)this);
        double d0 = target.func_226278_cu_() + (double)target.func_70047_e() - (double)1.1f;
        double d1 = target.func_226277_ct_() - this.func_226277_ct_();
        double d2 = d0 - slice.func_226278_cu_();
        double d3 = target.func_226281_cx_() - this.func_226281_cx_();
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
        slice.func_70186_c(d1, d2 + (double)f, d3, 1.6f, 12.0f);
        this.func_184185_a(SoundEvents.field_187805_fE, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        slice.func_70634_a(slice.func_226277_ct_(), slice.func_226278_cu_(), slice.func_226281_cx_());
        MelonMod.spawnNonLivingEntity(this.field_70170_p, (Entity)slice);
    }

    public boolean isShearable(@Nonnull ItemStack item, IWorldReader world, BlockPos pos) {
        return !this.getHead().func_190926_b();
    }

    protected float func_70647_i() {
        return (Boolean)MelonMod.config.tehnutMode.get() != false ? this.pitch + this.field_70146_Z.nextFloat() * 0.25f - 0.5f : super.func_70647_i();
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (Boolean)MelonMod.config.tehnutMode.get() != false ? MelonSounds.daddy : SoundEvents.field_187900_fz;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187880_fp;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187874_fm;
    }

    public int func_70627_aG() {
        return MelonMod.SIGNS.contains((Object)this.getHead().func_77973_b()) ? 200 : super.func_70627_aG();
    }

    public void func_70642_aH() {
        if (((Boolean)MelonMod.config.tts.get()).booleanValue() && MelonMod.SIGNS.contains((Object)this.getHead().func_77973_b())) {
            if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
                MelonMod.network.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ClientPacketHandlerMelonTTS(this));
            }
        } else {
            super.func_70642_aH();
        }
    }

    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        if (!((Boolean)MelonMod.config.hats.get()).booleanValue() || player.func_184614_ca().func_77973_b() instanceof ShearsItem || player.func_184592_cb().func_77973_b() instanceof ShearsItem) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && this.getHead().func_190926_b()) {
            if (Block.func_149634_a((Item)stack.func_77973_b()) != Blocks.field_150350_a || MelonMod.SIGNS.contains((Object)stack.func_77973_b())) {
                this.setHead(stack);
                if (!player.func_184812_l_()) {
                    player.func_184586_b(hand).func_190918_g(1);
                }
                return true;
            }
        } else if (!this.getHead().func_190926_b() && MelonMod.SIGNS.contains((Object)this.getHead().func_77973_b())) {
            MelonMod.proxy.openSignHolderGui(this);
            return true;
        }
        return false;
    }

    protected float func_213348_b(Pose p_213348_1_, EntitySize p_213348_2_) {
        return 1.7f;
    }

    @Override
    public ItemStack getHead() {
        return (ItemStack)this.field_70180_af.func_187225_a(HEAD);
    }

    public void setHead(ItemStack stack) {
        for (int i = 0; i < 4; ++i) {
            this.setSignText(i, (ITextComponent)new StringTextComponent(""));
        }
        ItemStack newstack = stack.func_77946_l();
        newstack.func_190920_e(1);
        this.field_70180_af.func_187227_b(HEAD, (Object)newstack);
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nonnull ItemStack item, IWorld world, BlockPos pos, int fortune) {
        ArrayList list = Lists.newArrayList((Object[])new ItemStack[]{(Boolean)MelonMod.config.shear.get() != false ? this.getHead() : ItemStack.field_190927_a});
        this.setHead(ItemStack.field_190927_a);
        return list;
    }

    public void func_70645_a(@Nonnull DamageSource cause) {
        super.func_70645_a(cause);
        ItemStack stack = this.getHead();
        if (!this.field_70170_p.field_72995_K && !stack.func_190926_b()) {
            ItemEntity e = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack);
            e.func_213317_d(e.func_213322_ci().func_72441_c((double)(this.field_70146_Z.nextFloat() * 0.05f), (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f), (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f)));
            this.field_70170_p.func_217376_c((Entity)e);
        }
    }

    @Nonnull
    public CompoundNBT func_189511_e(CompoundNBT compound) {
        compound.func_218657_a("head", (INBT)this.getHead().serializeNBT());
        for (int i = 0; i < 4; ++i) {
            String s = ITextComponent.Serializer.func_150696_a((ITextComponent)this.getSignText(i));
            compound.func_74778_a("Text" + (i + 1), s);
        }
        return super.func_189511_e(compound);
    }

    public void func_70020_e(CompoundNBT compound) {
        this.setHead(ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("head")));
        for (int i = 0; i < 4; ++i) {
            String s = compound.func_74779_i("Text" + (i + 1));
            ITextComponent itextcomponent = ITextComponent.Serializer.func_150699_a((String)s);
            try {
                this.setSignText(i, (ITextComponent)(itextcomponent == null ? new StringTextComponent("") : TextComponentUtils.func_197680_a((CommandSource)this.func_195051_bN(), (ITextComponent)itextcomponent, null, (int)0)));
                continue;
            }
            catch (CommandSyntaxException | CommandException var7) {
                this.setSignText(i, itextcomponent);
            }
        }
        super.func_70020_e(compound);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_150788_a(this.getHead());
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.setHead(additionalData.func_150791_c());
    }

    static class EntityAISearchAndEatMelons
    extends Goal {
        private final MobEntity parent;
        private final Item melon;
        private final Block melonblock;
        private int cooldown;
        private BlockPos.Mutable pos = new BlockPos.Mutable();
        private boolean foundMelon = false;

        EntityAISearchAndEatMelons(MobEntity entity) {
            this.parent = entity;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.melon = entity instanceof EntityGlisteringMelonGolem ? Items.field_151060_bw : Items.field_151127_ba;
            this.melonblock = entity instanceof EntityGlisteringMelonGolem ? MelonMod.glisteringMelonBlock : Blocks.field_150440_ba;
        }

        public boolean func_75250_a() {
            return (Boolean)MelonMod.config.eats.get() != false && this.parent.func_110143_aJ() < this.parent.func_110138_aP();
        }

        public void func_75251_c() {
            this.cooldown = 0;
        }

        private boolean isMelon(ItemEntity item) {
            return this.isMelon(item.func_92059_d());
        }

        private boolean isMelon(ItemStack item) {
            return this.isMelon(item.func_77973_b());
        }

        private boolean isMelon(Item item) {
            return item == this.melon || item == this.melonblock.func_199767_j();
        }

        public void func_75246_d() {
            if (this.parent == null) {
                return;
            }
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            int radius = 25;
            AxisAlignedBB area = new AxisAlignedBB(this.parent.func_226277_ct_() - 25.0, this.parent.func_226278_cu_() - 25.0, this.parent.func_226281_cx_() - 25.0, this.parent.func_226277_ct_() + 25.0, this.parent.func_226278_cu_() + 25.0, this.parent.func_226281_cx_() + 25.0);
            List items = this.parent.field_70170_p.func_217357_a(ItemEntity.class, area);
            for (ItemEntity item : items) {
                if (this.parent.func_70661_as().func_75500_f() && this.isMelon(item)) {
                    this.parent.func_70661_as().func_75497_a((Entity)item, 1.25);
                    this.parent.func_70671_ap().func_75651_a((Entity)item, 30.0f, 30.0f);
                }
                if (this.cooldown > 0 || !item.func_70089_S() || !this.isMelon(item) || !item.func_174813_aQ().func_72326_a(this.parent.func_174813_aQ().func_186662_g(1.0))) continue;
                boolean flag = item.func_92059_d().func_77973_b() == this.melonblock.func_199767_j();
                item.func_92059_d().func_190918_g(1);
                this.parent.func_184185_a(SoundEvents.field_187739_dZ, 1.0f, 1.0f);
                this.parent.func_70691_i(((Double)MelonMod.config.heal.get()).floatValue() * (float)(flag ? 9 : 1));
                this.cooldown = 30 + this.parent.func_70681_au().nextInt(40);
            }
            if (this.parent.func_70661_as().func_75500_f()) {
                this.foundMelon = false;
                block1: for (int x = -25; x < 25; ++x) {
                    for (int y = -25; y < 25; ++y) {
                        for (int z = -25; z < 25; ++z) {
                            IItemHandler cap;
                            TileEntity te;
                            this.pos.func_189533_g((Vec3i)this.parent.func_180425_c().func_177982_a(x, y, z));
                            if (!this.parent.field_70170_p.func_175667_e((BlockPos)this.pos) || (te = this.parent.field_70170_p.func_175625_s((BlockPos)this.pos)) == null || (cap = (IItemHandler)CapabilityList.getCap((ICapabilityProvider)te, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP)) == null) continue;
                            for (int i = 0; i < cap.getSlots(); ++i) {
                                if (!this.isMelon(cap.getStackInSlot(i))) continue;
                                boolean bl = this.foundMelon = this.parent.func_70092_e((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p()) < 4.0 || this.parent.func_70661_as().func_75492_a((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p(), 1.25);
                                if (this.foundMelon) break block1;
                            }
                        }
                    }
                }
            }
            if (this.foundMelon) {
                int i;
                if (!this.parent.field_70170_p.func_175667_e((BlockPos)this.pos)) {
                    this.parent.func_70661_as().func_75499_g();
                    this.foundMelon = false;
                    return;
                }
                TileEntity te = this.parent.field_70170_p.func_175625_s((BlockPos)this.pos);
                if (te == null || !te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).isPresent()) {
                    this.parent.func_70661_as().func_75499_g();
                    this.foundMelon = false;
                    return;
                }
                IItemHandler cap = (IItemHandler)CapabilityList.getCap((ICapabilityProvider)te, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP);
                if (cap == null) {
                    this.parent.func_70661_as().func_75499_g();
                    this.foundMelon = false;
                    return;
                }
                boolean valid = false;
                for (i = 0; i < cap.getSlots(); ++i) {
                    if (!this.isMelon(cap.getStackInSlot(i))) continue;
                    valid = true;
                    break;
                }
                if (!valid) {
                    this.parent.func_70661_as().func_75499_g();
                    this.foundMelon = false;
                    return;
                }
                if (this.cooldown <= 0 && this.parent.func_70092_e((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p()) < 4.0) {
                    boolean flag = cap.getStackInSlot(i).func_77973_b() == this.melonblock.func_199767_j();
                    cap.getStackInSlot(i).func_190918_g(1);
                    this.parent.func_184185_a(SoundEvents.field_187739_dZ, 1.0f, 1.0f);
                    this.parent.func_70691_i(((Double)MelonMod.config.heal.get()).floatValue() * (float)(flag ? 9 : 1));
                    this.cooldown = 10 + this.parent.func_70681_au().nextInt(40);
                }
            }
        }
    }
}

