/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.fml.unsafe.UnsafeHacks;
import tamaized.melongolem.network.client.ClientPacketHandlerMelonTTS;
import tamaized.melongolem.network.client.ClientPacketHandlerParticle;
import tamaized.melongolem.network.client.ClientPacketHandlerSpawnNonLivingEntity;
import tamaized.melongolem.network.server.ServerPacketHandlerDonatorSettings;
import tamaized.melongolem.network.server.ServerPacketHandlerMelonSign;

public class NetworkMessages {
    private static int index = 0;

    public static void register(SimpleChannel network) {
        NetworkMessages.registerMessage(network, ServerPacketHandlerMelonSign.class, IMessage.Side.SERVER);
        NetworkMessages.registerMessage(network, ServerPacketHandlerDonatorSettings.class, IMessage.Side.SERVER);
        NetworkMessages.registerMessage(network, ClientPacketHandlerMelonTTS.class, IMessage.Side.CLIENT);
        NetworkMessages.registerMessage(network, ClientPacketHandlerParticle.class, IMessage.Side.CLIENT);
        NetworkMessages.registerMessage(network, ClientPacketHandlerSpawnNonLivingEntity.class, IMessage.Side.CLIENT);
    }

    private static <M extends IMessage<M>> void registerMessage(SimpleChannel network, Class<M> type, IMessage.Side side) {
        network.registerMessage(index++, type, IMessage::encode, p -> IMessage.decode(p, type), (m, s) -> IMessage.onMessage(m, s, side));
    }

    public static interface IMessage<SELF extends IMessage<SELF>> {
        public static <M extends IMessage<M>> void encode(M message, PacketBuffer packet) {
            message.toBytes(packet);
        }

        public static <M extends IMessage<M>> M decode(PacketBuffer packet, Class<M> type) {
            return (M)((IMessage)UnsafeHacks.newInstance(type)).fromBytes(packet);
        }

        public static void onMessage(IMessage message, Supplier<NetworkEvent.Context> context, Side side) {
            context.get().enqueueWork(() -> message.handle((PlayerEntity)(side == Side.SERVER ? ((NetworkEvent.Context)context.get()).getSender() : IMessage.getClientSidePlayer().get())));
            context.get().setPacketHandled(true);
        }

        public static Supplier<PlayerEntity> getClientSidePlayer() {
            return new Supplier<PlayerEntity>(){

                @Override
                public PlayerEntity get() {
                    return Minecraft.func_71410_x().field_71439_g;
                }
            };
        }

        public void handle(PlayerEntity var1);

        public void toBytes(PacketBuffer var1);

        public SELF fromBytes(PacketBuffer var1);

        public static enum Side {
            CLIENT,
            SERVER;

        }
    }
}

