/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.miningdimension.block;

import de.maxhenkel.miningdimension.IItemBlock;
import de.maxhenkel.miningdimension.Main;
import de.maxhenkel.miningdimension.block.ModBlocks;
import de.maxhenkel.miningdimension.tileentity.TileentityTeleporter;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;

public class BlockTeleporter
extends Block
implements ITileEntityProvider,
IItemBlock {
    public BlockTeleporter() {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a));
        this.setRegistryName(new ResourceLocation("mining_dimension", "teleporter"));
    }

    @Override
    public Item toItem() {
        return (Item)new BlockItem((Block)this, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName(this.getRegistryName());
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        if (player instanceof ServerPlayerEntity) {
            this.transferPlayer((ServerPlayerEntity)player, pos);
        }
        return true;
    }

    public boolean transferPlayer(ServerPlayerEntity playerMP, BlockPos pos) {
        if (playerMP.func_184187_bx() != null || playerMP.func_184207_aI()) {
            return false;
        }
        if (playerMP.field_71093_bK.equals(Main.getMiningDimension())) {
            ServerWorld teleportWorld = playerMP.field_71133_b.func_71218_a(Main.getOverworldDimension());
            Chunk chunk = (Chunk)teleportWorld.func_217349_x(pos);
            BlockPos teleporterPos = this.findPortalInChunk(chunk);
            if (teleporterPos == null) {
                teleporterPos = this.placeTeleporterOverworld(teleportWorld, chunk);
            }
            if (teleporterPos == null) {
                return true;
            }
            playerMP.func_200619_a(playerMP.field_71133_b.func_71218_a(DimensionType.field_223227_a_), (double)teleporterPos.func_177958_n() + 0.5, (double)teleporterPos.func_177956_o() + 1.0, (double)teleporterPos.func_177952_p() + 0.5, playerMP.field_70177_z, playerMP.field_70125_A);
        } else if (playerMP.field_71093_bK.equals(Main.getOverworldDimension())) {
            ServerWorld teleportWorld = playerMP.field_71133_b.func_71218_a(Main.getMiningDimension());
            Chunk chunk = (Chunk)teleportWorld.func_217349_x(pos);
            BlockPos teleporterPos = this.findPortalInChunk(chunk);
            if (teleporterPos == null) {
                teleporterPos = this.placeTeleporterMining(teleportWorld, chunk);
            }
            if (teleporterPos == null) {
                return true;
            }
            playerMP.func_200619_a(teleportWorld, (double)teleporterPos.func_177958_n() + 0.5, (double)teleporterPos.func_177956_o() + 1.0, (double)teleporterPos.func_177952_p() + 0.5, playerMP.field_70177_z, playerMP.field_70125_A);
        }
        return true;
    }

    private BlockPos findPortalInChunk(Chunk chunk) {
        for (TileEntity tile : chunk.func_177434_r().values()) {
            BlockPos pos;
            if (!(tile instanceof TileentityTeleporter) || !chunk.func_180495_p((pos = tile.func_174877_v()).func_177984_a()).func_196958_f()) continue;
            return pos;
        }
        return null;
    }

    private BlockPos placeTeleporterMining(ServerWorld world, Chunk chunk) {
        int z;
        int x;
        int y;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (y = 0; y < 255; ++y) {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    pos.func_181079_c(x, y, z);
                    if (!chunk.func_180495_p((BlockPos)pos).func_196958_f() || !chunk.func_180495_p(pos.func_177981_b(1)).func_196958_f() || !chunk.func_180495_p(pos.func_177981_b(2)).func_196958_f()) continue;
                    BlockPos absolutePos = chunk.func_76632_l().func_180331_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    world.func_175656_a(absolutePos, ModBlocks.TELEPORTER.func_176223_P());
                    return absolutePos;
                }
            }
        }
        for (y = 0; y < 255; ++y) {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    BlockPos absolutePos;
                    pos.func_181079_c(x, y, z);
                    if (!this.isAirOrStone(chunk, (BlockPos)pos) || !this.isAirOrStone(chunk, pos.func_177981_b(1)) || !this.isAirOrStone(chunk, pos.func_177981_b(2)) || !this.isReplaceable((World)world, (absolutePos = chunk.func_76632_l().func_180331_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())).func_177981_b(3)) || !this.isReplaceable((World)world, absolutePos.func_177981_b(1).func_177972_a(Direction.NORTH)) || !this.isReplaceable((World)world, absolutePos.func_177981_b(1).func_177972_a(Direction.NORTH)) || !this.isReplaceable((World)world, absolutePos.func_177981_b(1).func_177972_a(Direction.SOUTH)) || !this.isReplaceable((World)world, absolutePos.func_177981_b(1).func_177972_a(Direction.EAST)) || !this.isReplaceable((World)world, absolutePos.func_177981_b(1).func_177972_a(Direction.WEST)) || !this.isReplaceable((World)world, absolutePos.func_177981_b(2).func_177972_a(Direction.NORTH)) || !this.isReplaceable((World)world, absolutePos.func_177981_b(2).func_177972_a(Direction.SOUTH)) || !this.isReplaceable((World)world, absolutePos.func_177981_b(2).func_177972_a(Direction.EAST)) || !this.isReplaceable((World)world, absolutePos.func_177981_b(2).func_177972_a(Direction.WEST))) continue;
                    world.func_175656_a(absolutePos, ModBlocks.TELEPORTER.func_176223_P());
                    world.func_175656_a(absolutePos.func_177981_b(1), Blocks.field_150350_a.func_176223_P());
                    world.func_175656_a(absolutePos.func_177981_b(2), Blocks.field_150350_a.func_176223_P());
                    world.func_175656_a(absolutePos.func_177981_b(3), Blocks.field_150348_b.func_176223_P());
                    world.func_175656_a(absolutePos.func_177981_b(1).func_177972_a(Direction.NORTH), Blocks.field_150348_b.func_176223_P());
                    world.func_175656_a(absolutePos.func_177981_b(1).func_177972_a(Direction.SOUTH), Blocks.field_150348_b.func_176223_P());
                    world.func_175656_a(absolutePos.func_177981_b(1).func_177972_a(Direction.EAST), Blocks.field_150348_b.func_176223_P());
                    world.func_175656_a(absolutePos.func_177981_b(1).func_177972_a(Direction.WEST), Blocks.field_150348_b.func_176223_P());
                    world.func_175656_a(absolutePos.func_177981_b(2).func_177972_a(Direction.NORTH), Blocks.field_150348_b.func_176223_P());
                    world.func_175656_a(absolutePos.func_177981_b(2).func_177972_a(Direction.SOUTH), Blocks.field_150348_b.func_176223_P());
                    world.func_175656_a(absolutePos.func_177981_b(2).func_177972_a(Direction.EAST), Blocks.field_150348_b.func_176223_P());
                    world.func_175656_a(absolutePos.func_177981_b(2).func_177972_a(Direction.WEST), Blocks.field_150348_b.func_176223_P());
                    return absolutePos;
                }
            }
        }
        return null;
    }

    private boolean isAirOrStone(Chunk chunk, BlockPos pos) {
        BlockState state = chunk.func_180495_p(pos);
        return state.func_177230_c().equals(Blocks.field_150348_b) || state.func_196958_f();
    }

    private boolean isReplaceable(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_177230_c().equals(Blocks.field_150348_b) || state.func_177230_c().equals(Blocks.field_196650_c) || state.func_177230_c().equals(Blocks.field_196656_g) || state.func_177230_c().equals(Blocks.field_196654_e) || state.func_177230_c().equals(Blocks.field_150346_d) || state.func_177230_c().equals(Blocks.field_150351_n) || state.func_177230_c().equals(Blocks.field_150353_l) || state.func_196958_f();
    }

    private BlockPos placeTeleporterOverworld(ServerWorld world, Chunk chunk) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 63; y < 255; ++y) {
                    pos.func_181079_c(x, y, z);
                    if (!chunk.func_180495_p((BlockPos)pos).func_196958_f() || !chunk.func_180495_p(pos.func_177981_b(1)).func_196958_f()) continue;
                    BlockPos absolutePos = chunk.func_76632_l().func_180331_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    world.func_175656_a(absolutePos, ModBlocks.TELEPORTER.func_176223_P());
                    return absolutePos;
                }
            }
        }
        return null;
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileentityTeleporter();
    }
}

