/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.miningdimension.config;

import com.electronwill.nightconfig.core.conversion.Path;
import com.electronwill.nightconfig.core.conversion.SpecIntInRange;
import de.maxhenkel.mining_dimension.corelib.block.BlockUtils;
import de.maxhenkel.miningdimension.Main;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class Ore {
    protected transient BlockState oreBlock;
    @Path(value="enabled")
    protected boolean enabled;
    @Path(value="max_height")
    @SpecIntInRange(min=1, max=256)
    protected int maxHeight;
    @Path(value="count")
    @SpecIntInRange(min=1, max=1024)
    protected int count;
    @Path(value="size")
    @SpecIntInRange(min=1, max=128)
    protected int size;

    public Ore(String oreBlock, boolean enabled, int maxHeight, int count, int size) {
        this(oreBlock);
        this.enabled = enabled;
        this.maxHeight = maxHeight;
        this.count = count;
        this.size = size;
    }

    public Ore(String oreBlock) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(oreBlock));
        if (block == null || BlockUtils.isAir(block)) {
            Main.LOGGER.error("Could not find block with the id '" + oreBlock + "'. This block will not get added to the mining world.");
        } else {
            this.oreBlock = block.func_176223_P();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getCount() {
        return this.count;
    }

    public int getSize() {
        return this.size;
    }

    @Nullable
    public BlockState getOreBlock() {
        return this.oreBlock;
    }
}

