/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.miningdimension.config;

import de.maxhenkel.mining_dimension.corelib.config.ConfigBase;
import de.maxhenkel.miningdimension.Main;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ServerConfig
extends ConfigBase {
    private final ForgeConfigSpec.ConfigValue<String> overworldDimensionSpec;
    public final ForgeConfigSpec.DoubleValue cavePercentage;
    public final ForgeConfigSpec.DoubleValue canyonPercentage;
    public final ForgeConfigSpec.BooleanValue generateLavaLakes;
    public final ForgeConfigSpec.IntValue lavaLakeChance;
    public final ForgeConfigSpec.BooleanValue generateSpawners;
    public final ForgeConfigSpec.IntValue spawnerChance;
    public final ForgeConfigSpec.BooleanValue generateLava;
    public final ForgeConfigSpec.BooleanValue bedrockFloor;
    public final ForgeConfigSpec.BooleanValue bedrockCeiling;
    public RegistryKey<World> overworldDimension;

    public ServerConfig(ForgeConfigSpec.Builder builder) {
        super(builder);
        this.overworldDimensionSpec = builder.comment("The dimension from where you can teleport to the mining dimension and back").define("overworld_dimension", (Object)"minecraft:overworld");
        this.cavePercentage = builder.worldRestart().defineInRange("world_generation.cave_percentage", 0.3, 0.0, 1.0);
        this.canyonPercentage = builder.worldRestart().defineInRange("world_generation.canyon_percentage", 0.02, 0.0, 1.0);
        this.generateLavaLakes = builder.worldRestart().define("world_generation.lava_lakes.enabled", true);
        this.lavaLakeChance = builder.worldRestart().defineInRange("world_generation.lava_lakes.chance", 80, 0, 1024);
        this.generateSpawners = builder.worldRestart().define("world_generation.spawners.enabled", true);
        this.spawnerChance = builder.worldRestart().defineInRange("world_generation.spawners.chance", 8, 0, 1024);
        this.generateLava = builder.comment("If lava should be generated in caves below level 11").worldRestart().define("world_generation.lava", true);
        this.bedrockFloor = builder.comment("If a bedrock layer should be generated at Y=0").comment("Note that setting this to false can cause players to fall into the void").worldRestart().define("world_generation.bedrock_floor", true);
        this.bedrockCeiling = builder.comment("If a bedrock layer should be generated at Y=255").comment("Note that setting this to false causes the game to spawn mobs on top of the world").worldRestart().define("world_generation.bedrock_ceiling", true);
    }

    @Override
    public void onReload(ModConfig.ModConfigEvent event) {
        super.onReload(event);
        this.overworldDimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation((String)this.overworldDimensionSpec.get()));
        Main.MINING_BIOME.initializeFeatures();
    }
}

