/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.miningdimension.dimension;

import com.google.common.collect.ImmutableList;
import de.maxhenkel.miningdimension.Main;
import de.maxhenkel.miningdimension.config.Ore;
import de.maxhenkel.miningdimension.dimension.CanyonWorldCarver;
import de.maxhenkel.miningdimension.dimension.CaveWorldCarver;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.DungeonsFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.LakesFeature;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;

public class MiningBiome
extends Biome {
    public MiningBiome() {
        super(new Biome.Builder().func_222351_a(SurfaceBuilder.field_215396_G, (ISurfaceBuilderConfig)SurfaceBuilder.field_215425_v).func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.125f).func_205420_b(0.05f).func_205414_c(0.8f).func_205417_d(0.4f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_205418_a(null).func_235098_a_((List)ImmutableList.of((Object)new Biome.Attributes(0.0f, 0.0f, 0.0f, 0.0f, 1.0f))));
        this.func_201866_a(EntityClassification.MONSTER, new Biome.SpawnListEntry(EntityType.field_200748_an, 100, 4, 4));
        this.func_201866_a(EntityClassification.MONSTER, new Biome.SpawnListEntry(EntityType.field_200725_aD, 95, 4, 4));
        this.func_201866_a(EntityClassification.MONSTER, new Biome.SpawnListEntry(EntityType.field_200727_aF, 5, 1, 1));
        this.func_201866_a(EntityClassification.MONSTER, new Biome.SpawnListEntry(EntityType.field_200741_ag, 100, 4, 4));
        this.func_201866_a(EntityClassification.MONSTER, new Biome.SpawnListEntry(EntityType.field_200797_k, 100, 4, 4));
        this.func_201866_a(EntityClassification.MONSTER, new Biome.SpawnListEntry(EntityType.field_200803_q, 10, 1, 4));
        this.func_201866_a(EntityClassification.MONSTER, new Biome.SpawnListEntry(EntityType.field_200759_ay, 5, 1, 1));
    }

    public void initializeOreFeatures() {
        Main.LOGGER.info("Reloading mining biome ore features");
        this.field_201872_ah.values().forEach(features -> features.removeIf(this::isOreFeature));
        Main.ORE_CONFIG.getOres().stream().filter(ore -> ore.getOreBlock() != null).filter(Ore::isEnabled).forEach(ore -> this.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ore.getOreBlock(), ore.getSize())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(ore.getCount(), 0, 0, ore.getMaxHeight())))));
    }

    public void initializeFeatures() {
        Main.LOGGER.info("Reloading mining biome features");
        this.field_201871_ag.values().forEach(carvers -> carvers.removeIf(configuredCarver -> {
            if (configuredCarver.field_222732_a instanceof CaveWorldCarver) {
                return true;
            }
            return configuredCarver.field_222732_a instanceof CanyonWorldCarver;
        }));
        this.field_201872_ah.values().forEach(features -> features.removeIf(feature -> feature.field_222737_a instanceof LakesFeature || feature.field_222737_a instanceof DungeonsFeature));
        this.func_203609_a(GenerationStage.Carving.AIR, Biome.func_203606_a((WorldCarver)Main.CAVE_CARVER, (ICarverConfig)new ProbabilityConfig(((Double)Main.SERVER_CONFIG.cavePercentage.get()).floatValue())));
        this.func_203609_a(GenerationStage.Carving.AIR, Biome.func_203606_a((WorldCarver)Main.CANYON_CARVER, (ICarverConfig)new ProbabilityConfig(((Double)Main.SERVER_CONFIG.canyonPercentage.get()).floatValue())));
        if (((Boolean)Main.SERVER_CONFIG.generateLavaLakes.get()).booleanValue()) {
            this.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, Feature.field_202289_ai.func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(Blocks.field_150353_l.func_176223_P())).func_227228_a_(Placement.field_215005_D.func_227446_a_((IPlacementConfig)new ChanceConfig(((Integer)Main.SERVER_CONFIG.lavaLakeChance.get()).intValue()))));
        }
        if (((Boolean)Main.SERVER_CONFIG.generateSpawners.get()).booleanValue()) {
            this.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, Feature.field_202282_ab.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215007_F.func_227446_a_((IPlacementConfig)new ChanceConfig(((Integer)Main.SERVER_CONFIG.spawnerChance.get()).intValue()))));
        }
    }

    private boolean isOreFeature(ConfiguredFeature<?, ?> feature) {
        if (feature.field_222738_b instanceof DecoratedFeatureConfig) {
            DecoratedFeatureConfig config = (DecoratedFeatureConfig)feature.field_222738_b;
            if (config.field_214689_a.field_222738_b instanceof OreFeatureConfig) {
                return true;
            }
        }
        return false;
    }
}

