/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.api;

import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.api.BoatModule;
import org.jglrxavpok.moarboats.api.BoatModuleInventory;
import org.jglrxavpok.moarboats.common.entities.BasicBoatEntity;
import org.jglrxavpok.moarboats.common.modules.BlockReason;
import org.jglrxavpok.moarboats.common.state.BoatProperty;
import org.jglrxavpok.moarboats.extensions.MathExtensionsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u001c\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0012\u00103\u001a\u0002042\b\b\u0002\u00105\u001a\u00020\u0013H&J\u0010\u00106\u001a\u0002042\u0006\u0010\u0002\u001a\u00020\u0003H&J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u000fH\u0016J\u001d\u0010:\u001a\u00020;\"\u0004\b\u0000\u0010<2\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H<0>H\u00a6\u0002J\u0012\u0010?\u001a\u0002042\b\b\u0002\u00105\u001a\u00020\u0013H&J0\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020A2\n\b\u0002\u0010E\u001a\u0004\u0018\u00010F2\n\b\u0002\u0010G\u001a\u0004\u0018\u00010HH&J\u0010\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\u001cH&J\n\u0010L\u001a\u0004\u0018\u00010MH&J\n\u0010N\u001a\u0004\u0018\u00010OH&J\u001a\u0010P\u001a\u00020Q2\u0006\u0010K\u001a\u00020\u001c2\b\b\u0002\u0010R\u001a\u00020;H&J\u0010\u0010S\u001a\u0002042\u0006\u0010T\u001a\u00020\u0013H&J\b\u0010U\u001a\u00020;H&J\b\u0010V\u001a\u00020;H&J\b\u0010W\u001a\u00020;H&J\u0010\u0010X\u001a\u0002082\u0006\u0010Y\u001a\u000208H\u0016J\u0010\u0010Z\u001a\u00020H2\u0006\u0010G\u001a\u00020HH&J\u001a\u0010[\u001a\u0002042\u0006\u0010K\u001a\u00020\u001c2\b\b\u0002\u0010R\u001a\u00020;H&J\u000e\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u001c0]H\u0016J\u0012\u0010^\u001a\u0002042\b\b\u0002\u00105\u001a\u00020\u0013H&J\u0012\u0010_\u001a\u0002042\b\b\u0002\u00105\u001a\u00020\u0013H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0012\u0010\u001f\u001a\u00020 X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0012\u0010#\u001a\u00020 X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"R\u0012\u0010%\u001a\u00020 X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\"R\u0012\u0010'\u001a\u00020 X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\"R\u0012\u0010)\u001a\u00020 X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\"R\u0012\u0010+\u001a\u00020 X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\"R\u0012\u0010-\u001a\u00020.X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0012\u00101\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0015\u00a8\u0006`"}, d2={"Lorg/jglrxavpok/moarboats/api/IControllable;", "Lnet/minecraft/dispenser/IBlockSource;", "blockedReason", "Lorg/jglrxavpok/moarboats/common/modules/BlockReason;", "getBlockedReason", "()Lorg/jglrxavpok/moarboats/common/modules/BlockReason;", "chunkTicket", "Lnet/minecraftforge/common/ForgeChunkManager$Ticket;", "getChunkTicket", "()Lnet/minecraftforge/common/ForgeChunkManager$Ticket;", "correspondingEntity", "Lnet/minecraft/entity/Entity;", "getCorrespondingEntity", "()Lnet/minecraft/entity/Entity;", "entityID", "", "getEntityID", "()I", "imposedSpeed", "", "getImposedSpeed", "()F", "moduleRNG", "Ljava/util/Random;", "getModuleRNG", "()Ljava/util/Random;", "modules", "", "Lorg/jglrxavpok/moarboats/api/BoatModule;", "getModules", "()Ljava/util/List;", "positionX", "", "getPositionX", "()D", "positionY", "getPositionY", "positionZ", "getPositionZ", "velocityX", "getVelocityX", "velocityY", "getVelocityY", "velocityZ", "getVelocityZ", "worldRef", "Lnet/minecraft/world/World;", "getWorldRef", "()Lnet/minecraft/world/World;", "yaw", "getYaw", "accelerate", "", "multiplier", "blockMovement", "calculateAnchorPosition", "Lnet/minecraft/util/math/Vec3d;", "linkType", "contains", "", "T", "property", "Lorg/jglrxavpok/moarboats/common/state/BoatProperty;", "decelerate", "dispense", "Lnet/minecraft/item/ItemStack;", "behavior", "Lnet/minecraft/dispenser/IBehaviorDispenseItem;", "stack", "overridePosition", "Lnet/minecraft/util/math/BlockPos;", "overrideFacing", "Lnet/minecraft/util/EnumFacing;", "getInventory", "Lorg/jglrxavpok/moarboats/api/BoatModuleInventory;", "module", "getOwnerIdOrNull", "Ljava/util/UUID;", "getOwnerNameOrNull", "", "getState", "Lnet/minecraft/nbt/NBTTagCompound;", "isLocal", "imposeSpeed", "speed", "inLiquid", "isEntityInLava", "isSpeedImposed", "localToWorld", "localVec", "reorientate", "saveState", "sortModulesByInterestingness", "", "turnLeft", "turnRight", "moarboats"})
public interface IControllable
extends IBlockSource {
    public int getEntityID();

    @NotNull
    public List<BoatModule> getModules();

    @NotNull
    public World getWorldRef();

    public double getPositionX();

    public double getPositionY();

    public double getPositionZ();

    public double getVelocityX();

    public double getVelocityY();

    public double getVelocityZ();

    public float getYaw();

    @NotNull
    public Entity getCorrespondingEntity();

    @NotNull
    public Random getModuleRNG();

    @NotNull
    public BlockReason getBlockedReason();

    public float getImposedSpeed();

    @Nullable
    public ForgeChunkManager.Ticket getChunkTicket();

    public boolean inLiquid();

    public boolean isEntityInLava();

    public void turnRight(float var1);

    public void turnLeft(float var1);

    public void accelerate(float var1);

    public void decelerate(float var1);

    public void blockMovement(@NotNull BlockReason var1);

    public void saveState(@NotNull BoatModule var1, boolean var2);

    @NotNull
    public NBTTagCompound getState(@NotNull BoatModule var1, boolean var2);

    @NotNull
    public BoatModuleInventory getInventory(@NotNull BoatModule var1);

    @NotNull
    public ItemStack dispense(@NotNull IBehaviorDispenseItem var1, @NotNull ItemStack var2, @Nullable BlockPos var3, @Nullable EnumFacing var4);

    @NotNull
    public EnumFacing reorientate(@NotNull EnumFacing var1);

    @Nullable
    public UUID getOwnerIdOrNull();

    @Nullable
    public String getOwnerNameOrNull();

    public boolean isSpeedImposed();

    public void imposeSpeed(float var1);

    @NotNull
    public Vec3d calculateAnchorPosition(int var1);

    @NotNull
    public Vec3d localToWorld(@NotNull Vec3d var1);

    @NotNull
    public Iterable<BoatModule> sortModulesByInterestingness();

    public <T> boolean contains(@NotNull BoatProperty<T> var1);

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=3)
    public static final class DefaultImpls {
        public static /* bridge */ /* synthetic */ void turnRight$default(IControllable iControllable, float f, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: turnRight");
            }
            if ((n & 1) != 0) {
                f = 1.0f;
            }
            iControllable.turnRight(f);
        }

        public static /* bridge */ /* synthetic */ void turnLeft$default(IControllable iControllable, float f, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: turnLeft");
            }
            if ((n & 1) != 0) {
                f = 1.0f;
            }
            iControllable.turnLeft(f);
        }

        public static /* bridge */ /* synthetic */ void accelerate$default(IControllable iControllable, float f, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: accelerate");
            }
            if ((n & 1) != 0) {
                f = 1.0f;
            }
            iControllable.accelerate(f);
        }

        public static /* bridge */ /* synthetic */ void decelerate$default(IControllable iControllable, float f, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decelerate");
            }
            if ((n & 1) != 0) {
                f = 1.0f;
            }
            iControllable.decelerate(f);
        }

        public static /* bridge */ /* synthetic */ void saveState$default(IControllable iControllable, BoatModule boatModule, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: saveState");
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            iControllable.saveState(boatModule, bl);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ NBTTagCompound getState$default(IControllable iControllable, BoatModule boatModule, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getState");
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            return iControllable.getState(boatModule, bl);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ItemStack dispense$default(IControllable iControllable, IBehaviorDispenseItem iBehaviorDispenseItem, ItemStack itemStack, BlockPos blockPos, EnumFacing enumFacing, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: dispense");
            }
            if ((n & 4) != 0) {
                blockPos = null;
            }
            if ((n & 8) != 0) {
                enumFacing = null;
            }
            return iControllable.dispense(iBehaviorDispenseItem, itemStack, blockPos, enumFacing);
        }

        @NotNull
        public static Vec3d calculateAnchorPosition(IControllable $this, int linkType) {
            float distanceFromCenter = 1.0625f * (linkType == BasicBoatEntity.Companion.getFrontLink() ? 1.0f : -1.0f);
            double anchorX = $this.getPositionX() + (double)(MathHelper.func_76134_b((float)MathExtensionsKt.toRadians($this.getYaw() + 90.0f)) * distanceFromCenter);
            double anchorY = $this.getPositionY() + (double)1.0f;
            double anchorZ = $this.getPositionZ() + (double)(MathHelper.func_76126_a((float)MathExtensionsKt.toRadians($this.getYaw() + 90.0f)) * distanceFromCenter);
            return new Vec3d(anchorX, anchorY, anchorZ);
        }

        @NotNull
        public static Vec3d localToWorld(IControllable $this, @NotNull Vec3d localVec) {
            Intrinsics.checkParameterIsNotNull((Object)localVec, (String)"localVec");
            Vec3d vec3d = localVec.func_178785_b(MathExtensionsKt.toRadians(180.0f - $this.getYaw())).func_72441_c($this.getPositionX(), $this.getPositionY(), $this.getPositionZ());
            Intrinsics.checkExpressionValueIsNotNull((Object)vec3d, (String)"localVec.rotateYaw((180f\u2026nX, positionY, positionZ)");
            return vec3d;
        }

        @NotNull
        public static Iterable<BoatModule> sortModulesByInterestingness(IControllable $this) {
            Iterable $receiver$iv = $this.getModules();
            return CollectionsKt.sortedWith((Iterable)$receiver$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    BoatModule it = (BoatModule)a;
                    int n = it.isMenuInteresting() ? it.getModuleSpot().ordinal() : 100;
                    it = (BoatModule)b;
                    Comparable comparable = Integer.valueOf(n);
                    Integer n2 = it.isMenuInteresting() ? it.getModuleSpot().ordinal() : 100;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n2);
                }
            });
        }
    }
}

