/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.IGuiHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.MoarBoats;
import org.jglrxavpok.moarboats.api.BoatModule;
import org.jglrxavpok.moarboats.api.BoatModuleInventory;
import org.jglrxavpok.moarboats.client.gui.GuiEnergy;
import org.jglrxavpok.moarboats.client.gui.GuiFluid;
import org.jglrxavpok.moarboats.client.gui.GuiMappingTable;
import org.jglrxavpok.moarboats.client.gui.GuiPathEditor;
import org.jglrxavpok.moarboats.client.gui.GuiWaypointEditor;
import org.jglrxavpok.moarboats.common.containers.ContainerBase;
import org.jglrxavpok.moarboats.common.containers.ContainerMappingTable;
import org.jglrxavpok.moarboats.common.containers.EnergyContainer;
import org.jglrxavpok.moarboats.common.containers.FluidContainer;
import org.jglrxavpok.moarboats.common.data.BoatPathHolder;
import org.jglrxavpok.moarboats.common.data.GoldenTicketPathHolder;
import org.jglrxavpok.moarboats.common.data.MapWithPathHolder;
import org.jglrxavpok.moarboats.common.entities.ModularBoatEntity;
import org.jglrxavpok.moarboats.common.items.ItemGoldenTicket;
import org.jglrxavpok.moarboats.common.items.ItemMapWithPath;
import org.jglrxavpok.moarboats.common.items.ItemPath;
import org.jglrxavpok.moarboats.common.modules.HelmModule;
import org.jglrxavpok.moarboats.common.state.EmptyMapData;
import org.jglrxavpok.moarboats.common.tileentity.TileEntityEnergy;
import org.jglrxavpok.moarboats.common.tileentity.TileEntityListenable;
import org.jglrxavpok.moarboats.common.tileentity.TileEntityMappingTable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0016J:\u0010\u001b\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lorg/jglrxavpok/moarboats/common/MoarBoatsGuiHandler;", "Lnet/minecraftforge/fml/common/network/IGuiHandler;", "()V", "EnergyGui", "", "getEnergyGui", "()I", "FluidGui", "getFluidGui", "MappingTableGui", "getMappingTableGui", "ModulesGui", "getModulesGui", "PathEditor", "getPathEditor", "WaypointEditor", "getWaypointEditor", "getClientGuiElement", "", "ID", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "world", "Lnet/minecraft/world/World;", "x", "y", "z", "getServerGuiElement", "moarboats"})
public final class MoarBoatsGuiHandler
implements IGuiHandler {
    private static final int ModulesGui = 0;
    private static final int PathEditor = 1;
    private static final int EnergyGui = 2;
    private static final int FluidGui = 3;
    private static final int MappingTableGui = 4;
    private static final int WaypointEditor = 5;
    public static final MoarBoatsGuiHandler INSTANCE;

    @Nullable
    public Object getClientGuiElement(int ID, @NotNull EntityPlayer player, @NotNull World world, int x, int y, int z) {
        GuiScreen guiScreen;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        int n = ID;
        if (n == ModulesGui) {
            int boatID = x;
            Entity entity = world.func_73045_a(boatID);
            if (!(entity instanceof ModularBoatEntity)) {
                entity = null;
            }
            ModularBoatEntity modularBoatEntity = (ModularBoatEntity)entity;
            if (modularBoatEntity == null) {
                return null;
            }
            ModularBoatEntity boat = modularBoatEntity;
            BoatModule module = y < 0 ? boat.findFirstModuleToShowOnGui() : boat.getModules().get(y);
            guiScreen = module.createGui(player, boat);
        } else if (n == PathEditor) {
            GuiPathEditor guiPathEditor;
            int boatID = x;
            Entity entity = world.func_73045_a(boatID);
            if (!(entity instanceof ModularBoatEntity)) {
                entity = null;
            }
            ModularBoatEntity modularBoatEntity = (ModularBoatEntity)entity;
            if (modularBoatEntity == null) {
                return null;
            }
            ModularBoatEntity boat = modularBoatEntity;
            if (boat.getModules().contains(HelmModule.INSTANCE)) {
                ItemStack stack;
                BoatModuleInventory inventory = boat.getInventory(HelmModule.INSTANCE);
                ItemStack itemStack = stack = (ItemStack)inventory.getList().get(0);
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
                Item item = itemStack.func_77973_b();
                if (item instanceof ItemMap) {
                    MapData mapData = (MapData)HelmModule.INSTANCE.getMapDataCopyProperty().get(boat);
                    guiPathEditor = Intrinsics.areEqual((Object)mapData, (Object)((Object)EmptyMapData.INSTANCE)) ^ true ? new GuiPathEditor(player, new BoatPathHolder(boat), mapData) : null;
                } else if (item instanceof ItemMapWithPath) {
                    MapData mapData;
                    NBTTagCompound nBTTagCompound = stack.func_77978_p();
                    if (nBTTagCompound == null) {
                        Intrinsics.throwNpe();
                    }
                    String id = nBTTagCompound.func_74779_i("moarboats.mapID");
                    WorldSavedData worldSavedData = MoarBoats.INSTANCE.getLocalMapStorage().func_75742_a(MapData.class, id);
                    if (!(worldSavedData instanceof MapData)) {
                        worldSavedData = null;
                    }
                    guiPathEditor = (mapData = (MapData)worldSavedData) != null && Intrinsics.areEqual((Object)mapData, (Object)((Object)EmptyMapData.INSTANCE)) ^ true ? new GuiPathEditor(player, new MapWithPathHolder(stack, null, boat), mapData) : null;
                } else if (item instanceof ItemGoldenTicket) {
                    MapData mapData;
                    String id = ItemGoldenTicket.INSTANCE.getData(stack).getMapID();
                    WorldSavedData worldSavedData = MoarBoats.INSTANCE.getLocalMapStorage().func_75742_a(MapData.class, id);
                    if (!(worldSavedData instanceof MapData)) {
                        worldSavedData = null;
                    }
                    guiPathEditor = (mapData = (MapData)worldSavedData) != null && Intrinsics.areEqual((Object)mapData, (Object)((Object)EmptyMapData.INSTANCE)) ^ true ? new GuiPathEditor(player, new GoldenTicketPathHolder(stack, null, boat), mapData) : null;
                } else {
                    guiPathEditor = null;
                }
            } else {
                guiPathEditor = null;
            }
            guiScreen = guiPathEditor;
        } else if (n == EnergyGui) {
            BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185339_c((int)x, (int)y, (int)z);
            TileEntity te = world.func_175625_s((BlockPos)pos);
            pos.func_185344_t();
            guiScreen = (GuiScreen)(te instanceof TileEntityEnergy ? new GuiEnergy((TileEntityEnergy)te, player) : null);
        } else if (n == FluidGui) {
            GuiFluid guiFluid;
            BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185339_c((int)x, (int)y, (int)z);
            TileEntity te = world.func_175625_s((BlockPos)pos);
            pos.func_185344_t();
            if (te == null) {
                guiFluid = null;
            } else if (te instanceof TileEntityListenable && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
                TileEntityListenable tileEntityListenable = (TileEntityListenable)te;
                Object object = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"te.getCapability(Capabil\u2026NDLER_CAPABILITY, null)!!");
                guiFluid = new GuiFluid(tileEntityListenable, (IFluidHandler)object, player);
            } else {
                guiFluid = null;
            }
            guiScreen = (GuiScreen)guiFluid;
        } else if (n == MappingTableGui) {
            GuiMappingTable guiMappingTable;
            BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185339_c((int)x, (int)y, (int)z);
            TileEntity te = world.func_175625_s((BlockPos)pos);
            pos.func_185344_t();
            TileEntity tileEntity = te;
            if (tileEntity == null) {
                guiMappingTable = null;
            } else if (tileEntity instanceof TileEntityMappingTable) {
                TileEntityMappingTable tileEntityMappingTable = (TileEntityMappingTable)te;
                InventoryPlayer inventoryPlayer = player.field_71071_by;
                Intrinsics.checkExpressionValueIsNotNull((Object)inventoryPlayer, (String)"player.inventory");
                guiMappingTable = new GuiMappingTable(tileEntityMappingTable, inventoryPlayer);
            } else {
                guiMappingTable = null;
            }
            guiScreen = (GuiScreen)guiMappingTable;
        } else if (n == WaypointEditor) {
            GuiWaypointEditor guiWaypointEditor;
            BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185339_c((int)x, (int)y, (int)z);
            TileEntity te = world.func_175625_s((BlockPos)pos);
            pos.func_185344_t();
            TileEntity tileEntity = te;
            if (tileEntity == null) {
                guiWaypointEditor = null;
            } else if (tileEntity instanceof TileEntityMappingTable) {
                ItemStack stack = ((TileEntityMappingTable)te).getInventory().func_70301_a(0);
                GuiScreen guiScreen2 = Minecraft.func_71410_x().field_71462_r;
                if (!(guiScreen2 instanceof GuiMappingTable)) {
                    guiScreen2 = null;
                }
                GuiMappingTable guiMappingTable = (GuiMappingTable)guiScreen2;
                int index = guiMappingTable != null ? guiMappingTable.getSelectedIndex() : 0;
                ItemStack itemStack = stack;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
                Item item = itemStack.func_77973_b();
                if (item == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jglrxavpok.moarboats.common.items.ItemPath");
                }
                NBTTagList pathNBT = ((ItemPath)item).getWaypointData(stack, MoarBoats.INSTANCE.getLocalMapStorage());
                int n2 = index;
                guiWaypointEditor = 0 > n2 || pathNBT.func_74745_c() <= n2 ? null : new GuiWaypointEditor(player, (TileEntityMappingTable)te, index);
            } else {
                guiWaypointEditor = null;
            }
            guiScreen = guiWaypointEditor;
        } else {
            guiScreen = null;
        }
        return guiScreen;
    }

    @Nullable
    public Object getServerGuiElement(int ID, @NotNull EntityPlayer player, @NotNull World world, int x, int y, int z) {
        ContainerBase containerBase;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        int n = ID;
        if (n == ModulesGui) {
            int boatID = x;
            Entity entity = world.func_73045_a(boatID);
            if (!(entity instanceof ModularBoatEntity)) {
                entity = null;
            }
            ModularBoatEntity modularBoatEntity = (ModularBoatEntity)entity;
            if (modularBoatEntity == null) {
                return null;
            }
            ModularBoatEntity boat = modularBoatEntity;
            BoatModule module = y < 0 ? boat.findFirstModuleToShowOnGui() : boat.getModules().get(y);
            containerBase = module.createContainer(player, boat);
        } else if (n == PathEditor) {
            containerBase = null;
        } else if (n == EnergyGui) {
            BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185339_c((int)x, (int)y, (int)z);
            TileEntity te = world.func_175625_s((BlockPos)pos);
            pos.func_185344_t();
            containerBase = te instanceof TileEntityEnergy ? new EnergyContainer((TileEntityEnergy)te, player) : null;
        } else if (n == FluidGui) {
            FluidContainer fluidContainer;
            BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185339_c((int)x, (int)y, (int)z);
            TileEntity te = world.func_175625_s((BlockPos)pos);
            pos.func_185344_t();
            if (te == null) {
                fluidContainer = null;
            } else if (te instanceof TileEntityListenable && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
                TileEntityListenable tileEntityListenable = (TileEntityListenable)te;
                Object object = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"te.getCapability(Capabil\u2026NDLER_CAPABILITY, null)!!");
                fluidContainer = new FluidContainer(tileEntityListenable, (IFluidHandler)object, player);
            } else {
                fluidContainer = null;
            }
            containerBase = fluidContainer;
        } else if (n == MappingTableGui) {
            ContainerMappingTable containerMappingTable;
            BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185339_c((int)x, (int)y, (int)z);
            TileEntity te = world.func_175625_s((BlockPos)pos);
            pos.func_185344_t();
            TileEntity tileEntity = te;
            if (tileEntity == null) {
                containerMappingTable = null;
            } else if (tileEntity instanceof TileEntityMappingTable) {
                TileEntityMappingTable tileEntityMappingTable = (TileEntityMappingTable)te;
                InventoryPlayer inventoryPlayer = player.field_71071_by;
                Intrinsics.checkExpressionValueIsNotNull((Object)inventoryPlayer, (String)"player.inventory");
                containerMappingTable = new ContainerMappingTable(tileEntityMappingTable, inventoryPlayer);
            } else {
                containerMappingTable = null;
            }
            containerBase = containerMappingTable;
        } else {
            containerBase = n == WaypointEditor ? null : null;
        }
        return containerBase;
    }

    public final int getModulesGui() {
        return ModulesGui;
    }

    public final int getPathEditor() {
        return PathEditor;
    }

    public final int getEnergyGui() {
        return EnergyGui;
    }

    public final int getFluidGui() {
        return FluidGui;
    }

    public final int getMappingTableGui() {
        return MappingTableGui;
    }

    public final int getWaypointEditor() {
        return WaypointEditor;
    }

    private MoarBoatsGuiHandler() {
    }

    static {
        MoarBoatsGuiHandler moarBoatsGuiHandler;
        INSTANCE = moarBoatsGuiHandler = new MoarBoatsGuiHandler();
        PathEditor = 1;
        EnergyGui = 2;
        FluidGui = 3;
        MappingTableGui = 4;
        WaypointEditor = 5;
    }
}

