/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.data;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.MoarBoats;
import org.jglrxavpok.moarboats.api.IControllable;
import org.jglrxavpok.moarboats.common.data.LoopingOptions;
import org.jglrxavpok.moarboats.common.data.PathHolder;
import org.jglrxavpok.moarboats.common.network.CChangeLoopingStateItemPathBoat;
import org.jglrxavpok.moarboats.common.network.CChangeLoopingStateItemPathMappingTable;
import org.jglrxavpok.moarboats.common.network.CMapImageRequest;
import org.jglrxavpok.moarboats.common.tileentity.TileEntityMappingTable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H&J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0010H\u0016J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0014H\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lorg/jglrxavpok/moarboats/common/data/ItemPathHolder;", "Lorg/jglrxavpok/moarboats/common/data/PathHolder;", "stack", "Lnet/minecraft/item/ItemStack;", "mappingTable", "Lorg/jglrxavpok/moarboats/common/tileentity/TileEntityMappingTable;", "boat", "Lorg/jglrxavpok/moarboats/api/IControllable;", "(Lnet/minecraft/item/ItemStack;Lorg/jglrxavpok/moarboats/common/tileentity/TileEntityMappingTable;Lorg/jglrxavpok/moarboats/api/IControllable;)V", "getBoat", "()Lorg/jglrxavpok/moarboats/api/IControllable;", "getMappingTable", "()Lorg/jglrxavpok/moarboats/common/tileentity/TileEntityMappingTable;", "getStack", "()Lnet/minecraft/item/ItemStack;", "getBaseMapID", "", "getHolderLocation", "", "getLoopingOption", "Lorg/jglrxavpok/moarboats/common/data/LoopingOptions;", "getWaypointNBTList", "Lnet/minecraft/nbt/NBTTagList;", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "sendWorldImageRequest", "", "mapID", "setLoopingState", "loopingOptions", "moarboats"})
public abstract class ItemPathHolder
implements PathHolder {
    @NotNull
    private final ItemStack stack;
    @Nullable
    private final TileEntityMappingTable mappingTable;
    @Nullable
    private final IControllable boat;

    @NotNull
    public abstract NBTTagCompound nbt();

    @Override
    @NotNull
    public String getBaseMapID() {
        String string = this.nbt().func_74779_i("moarboats.mapID");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"nbt().getString(\"${MoarBoats.ModID}.mapID\")");
        return string;
    }

    @Override
    @NotNull
    public LoopingOptions getLoopingOption() {
        LoopingOptions loopingOption = LoopingOptions.NoLoop;
        if (this.nbt().func_74767_n("moarboats.loops")) {
            loopingOption = LoopingOptions.Loops;
        }
        if (this.nbt().func_74764_b("moarboats.loopingOption")) {
            loopingOption = LoopingOptions.values()[RangesKt.coerceIn((int)this.nbt().func_74762_e("moarboats.loopingOption"), (ClosedRange)((ClosedRange)ArraysKt.getIndices((Object[])((Object[])LoopingOptions.values()))))];
        }
        return loopingOption;
    }

    @Override
    public void setLoopingState(@NotNull LoopingOptions loopingOptions) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)loopingOptions), (String)"loopingOptions");
        if (this.boat != null) {
            MoarBoats.INSTANCE.getNetwork().sendToServer((IMessage)new CChangeLoopingStateItemPathBoat(loopingOptions, this.boat.getEntityID()));
        } else {
            SimpleNetworkWrapper simpleNetworkWrapper = MoarBoats.INSTANCE.getNetwork();
            TileEntityMappingTable tileEntityMappingTable = this.mappingTable;
            if (tileEntityMappingTable == null) {
                Intrinsics.throwNpe();
            }
            simpleNetworkWrapper.sendToServer((IMessage)new CChangeLoopingStateItemPathMappingTable(loopingOptions, tileEntityMappingTable));
        }
    }

    @Override
    @NotNull
    public NBTTagList getWaypointNBTList() {
        NBTTagList nBTTagList = this.nbt().func_150295_c("moarboats.path", 10);
        Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagList, (String)"nbt().getTagList(\"${Moar\u2026nstants.NBT.TAG_COMPOUND)");
        return nBTTagList;
    }

    @Nullable
    public Void getHolderLocation() {
        return null;
    }

    @Override
    public void sendWorldImageRequest(@NotNull String mapID) {
        Intrinsics.checkParameterIsNotNull((Object)mapID, (String)"mapID");
        MoarBoats.INSTANCE.getNetwork().sendToServer((IMessage)new CMapImageRequest(mapID));
    }

    @NotNull
    public final ItemStack getStack() {
        return this.stack;
    }

    @Nullable
    public final TileEntityMappingTable getMappingTable() {
        return this.mappingTable;
    }

    @Nullable
    public final IControllable getBoat() {
        return this.boat;
    }

    public ItemPathHolder(@NotNull ItemStack stack, @Nullable TileEntityMappingTable mappingTable, @Nullable IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        this.stack = stack;
        this.mappingTable = mappingTable;
        this.boat = boat;
    }
}

