/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.items;

import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.MoarBoats;
import org.jglrxavpok.moarboats.common.data.LoopingOptions;
import org.jglrxavpok.moarboats.common.items.ItemMapWithPath;
import org.jglrxavpok.moarboats.common.items.ItemPath;
import org.jglrxavpok.moarboats.common.network.SSetGoldenItinerary;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001(B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\rJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0018J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010 \u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010!\u001a\u00020\u0016H\u0016J.\u0010\"\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010\"\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jglrxavpok/moarboats/common/items/ItemGoldenTicket;", "Lorg/jglrxavpok/moarboats/common/items/ItemPath;", "()V", "EmptyName", "Lnet/minecraft/util/text/TextComponentTranslation;", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "worldIn", "Lnet/minecraft/world/World;", "tooltip", "", "", "flagIn", "Lnet/minecraft/client/util/ITooltipFlag;", "createStack", "uuid", "getData", "Lorg/jglrxavpok/moarboats/common/items/ItemGoldenTicket$WaypointData;", "getItemStackDisplayName", "getLoopingOptions", "Lorg/jglrxavpok/moarboats/common/data/LoopingOptions;", "getUUID", "Ljava/util/UUID;", "getWaypointData", "Lnet/minecraft/nbt/NBTTagList;", "mapStorage", "Lnet/minecraft/world/storage/MapStorage;", "initStack", "isEmpty", "", "setLoopingOptions", "option", "updateItinerary", "list", "mapID", "map", "Lorg/jglrxavpok/moarboats/common/items/ItemMapWithPath;", "mapStack", "WaypointData", "moarboats"})
public final class ItemGoldenTicket
extends ItemPath {
    private static final TextComponentTranslation EmptyName;
    public static final ItemGoldenTicket INSTANCE;

    @Override
    public void setLoopingOptions(@NotNull ItemStack stack, @NotNull LoopingOptions option) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)((Object)option), (String)"option");
        this.getData(stack).setLoopingOption(option);
    }

    @Override
    @NotNull
    public LoopingOptions getLoopingOptions(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return this.getData(stack).getLoopingOption();
    }

    @Override
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<String> tooltip, @NotNull ITooltipFlag flagIn) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull(tooltip, (String)"tooltip");
        Intrinsics.checkParameterIsNotNull((Object)flagIn, (String)"flagIn");
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        UUID uuid = this.getUUID(stack);
        if (uuid != null) {
            tooltip.add("UUID: " + uuid);
        }
    }

    @Override
    @NotNull
    public NBTTagList getWaypointData(@NotNull ItemStack stack, @NotNull MapStorage mapStorage) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)mapStorage, (String)"mapStorage");
        WaypointData data = this.getData(stack);
        return data.getBackingList();
    }

    public final void initStack(@NotNull ItemStack stack, @NotNull UUID uuid) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
        stack.func_190925_c("moarboats.path").func_186854_a("path_uuid", uuid);
    }

    @Nullable
    public final UUID getUUID(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        NBTTagCompound nBTTagCompound = stack.func_179543_a("moarboats.path");
        return nBTTagCompound != null ? nBTTagCompound.func_186857_a("path_uuid") : null;
    }

    @NotNull
    public String func_77653_i(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (!this.isEmpty(stack)) {
            String string = super.func_77653_i(stack);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"super.getItemStackDisplayName(stack)");
            return string;
        }
        String string = EmptyName.func_150260_c();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"EmptyName.unformattedText");
        return string;
    }

    @NotNull
    public final ItemStack createStack(@NotNull String uuid) {
        Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
        ItemStack result = new ItemStack((Item)this);
        result.func_190925_c("moarboats.path").func_186854_a("path_uuid", UUID.fromString(uuid));
        return result;
    }

    public final boolean isEmpty(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return !stack.func_77942_o() || stack.func_179543_a("moarboats.path") == null;
    }

    public final void updateItinerary(@NotNull ItemStack stack, @NotNull ItemMapWithPath map, @NotNull ItemStack mapStack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)((Object)map), (String)"map");
        Intrinsics.checkParameterIsNotNull((Object)mapStack, (String)"mapStack");
        MapStorage mapStorage = MoarBoats.INSTANCE.getLocalMapStorage();
        NBTTagCompound nBTTagCompound = mapStack.func_77978_p();
        if (nBTTagCompound == null) {
            Intrinsics.throwNpe();
        }
        String mapID = nBTTagCompound.func_74779_i("moarboats.mapID");
        LoopingOptions loopingOption = LoopingOptions.NoLoop;
        NBTTagCompound nBTTagCompound2 = mapStack.func_77978_p();
        if (nBTTagCompound2 == null) {
            Intrinsics.throwNpe();
        }
        if (nBTTagCompound2.func_74767_n("moarboats.loops")) {
            loopingOption = LoopingOptions.Loops;
        }
        NBTTagCompound nBTTagCompound3 = mapStack.func_77978_p();
        if (nBTTagCompound3 == null) {
            Intrinsics.throwNpe();
        }
        if (nBTTagCompound3.func_74764_b("moarboats.loopingOption")) {
            LoopingOptions[] loopingOptionsArray = LoopingOptions.values();
            NBTTagCompound nBTTagCompound4 = mapStack.func_77978_p();
            if (nBTTagCompound4 == null) {
                Intrinsics.throwNpe();
            }
            loopingOption = loopingOptionsArray[RangesKt.coerceIn((int)nBTTagCompound4.func_74762_e("moarboats.loopingOption"), (ClosedRange)((ClosedRange)ArraysKt.getIndices((Object[])((Object[])LoopingOptions.values()))))];
        }
        NBTTagList nBTTagList = map.getWaypointData(mapStack, mapStorage);
        String string = mapID;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mapID");
        this.updateItinerary(stack, nBTTagList, string, loopingOption, mapStorage);
    }

    public final void updateItinerary(@NotNull ItemStack stack, @NotNull NBTTagList list, @NotNull String mapID, @NotNull LoopingOptions option, @NotNull MapStorage mapStorage) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)list, (String)"list");
        Intrinsics.checkParameterIsNotNull((Object)mapID, (String)"mapID");
        Intrinsics.checkParameterIsNotNull((Object)((Object)option), (String)"option");
        Intrinsics.checkParameterIsNotNull((Object)mapStorage, (String)"mapStorage");
        String uuid = String.valueOf(this.getUUID(stack));
        WaypointData data = new WaypointData(uuid);
        data.setBackingList(list);
        data.setLoopingOption(option);
        data.setMapID(mapID);
        mapStorage.func_75745_a(uuid, (WorldSavedData)data);
        FMLCommonHandler fMLCommonHandler = FMLCommonHandler.instance();
        Intrinsics.checkExpressionValueIsNotNull((Object)fMLCommonHandler, (String)"FMLCommonHandler.instance()");
        if (Intrinsics.areEqual((Object)fMLCommonHandler.getEffectiveSide(), (Object)Side.SERVER)) {
            MoarBoats.INSTANCE.getNetwork().sendToAll((IMessage)new SSetGoldenItinerary(data));
        }
    }

    @NotNull
    public final WaypointData getData(@NotNull ItemStack stack) {
        WaypointData data;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        MapStorage mapStorage = MoarBoats.INSTANCE.getLocalMapStorage();
        UUID uuid = this.getUUID(stack);
        String uuidString = String.valueOf(uuid);
        WorldSavedData worldSavedData = mapStorage.func_75742_a(WaypointData.class, uuidString);
        if (!(worldSavedData instanceof WaypointData)) {
            worldSavedData = null;
        }
        if ((data = (WaypointData)worldSavedData) == null) {
            data = new WaypointData(uuidString);
            mapStorage.func_75745_a(uuidString, (WorldSavedData)data);
        }
        return data;
    }

    private ItemGoldenTicket() {
    }

    static {
        ItemGoldenTicket itemGoldenTicket;
        INSTANCE = itemGoldenTicket = new ItemGoldenTicket();
        EmptyName = new TextComponentTranslation("moarboats.item.golden_ticket.name.empty", new Object[0]);
        itemGoldenTicket.setRegistryName(new ResourceLocation("moarboats", "golden_ticket"));
        itemGoldenTicket.func_77655_b("golden_ticket");
        itemGoldenTicket.func_77637_a(MoarBoats.INSTANCE.getCreativeTab());
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\b\u0010\u001f\u001a\u00020\u001aH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001J\u0010\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020#H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0013\"\u0004\b\u0016\u0010\u0004\u00a8\u0006'"}, d2={"Lorg/jglrxavpok/moarboats/common/items/ItemGoldenTicket$WaypointData;", "Lnet/minecraft/world/storage/WorldSavedData;", "uuid", "", "(Ljava/lang/String;)V", "backingList", "Lnet/minecraft/nbt/NBTTagList;", "getBackingList", "()Lnet/minecraft/nbt/NBTTagList;", "setBackingList", "(Lnet/minecraft/nbt/NBTTagList;)V", "loopingOption", "Lorg/jglrxavpok/moarboats/common/data/LoopingOptions;", "getLoopingOption", "()Lorg/jglrxavpok/moarboats/common/data/LoopingOptions;", "setLoopingOption", "(Lorg/jglrxavpok/moarboats/common/data/LoopingOptions;)V", "mapID", "getMapID", "()Ljava/lang/String;", "setMapID", "getUuid", "setUuid", "component1", "copy", "equals", "", "other", "", "hashCode", "", "isDirty", "readFromNBT", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "toString", "writeToNBT", "compound", "moarboats"})
    public static final class WaypointData
    extends WorldSavedData {
        @NotNull
        private NBTTagList backingList;
        @NotNull
        private LoopingOptions loopingOption;
        @NotNull
        private String mapID;
        @NotNull
        private String uuid;

        @NotNull
        public final NBTTagList getBackingList() {
            return this.backingList;
        }

        public final void setBackingList(@NotNull NBTTagList nBTTagList) {
            Intrinsics.checkParameterIsNotNull((Object)nBTTagList, (String)"<set-?>");
            this.backingList = nBTTagList;
        }

        @NotNull
        public final LoopingOptions getLoopingOption() {
            return this.loopingOption;
        }

        public final void setLoopingOption(@NotNull LoopingOptions loopingOptions) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)loopingOptions), (String)"<set-?>");
            this.loopingOption = loopingOptions;
        }

        @NotNull
        public final String getMapID() {
            return this.mapID;
        }

        public final void setMapID(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.mapID = string;
        }

        public boolean func_76188_b() {
            return true;
        }

        @NotNull
        public NBTTagCompound func_189551_b(@NotNull NBTTagCompound compound) {
            Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
            compound.func_74782_a("moarboats.path", (NBTBase)this.backingList);
            compound.func_74768_a("moarboats.loopingOption", this.loopingOption.ordinal());
            compound.func_74778_a("moarboats.mapID", this.mapID);
            return compound;
        }

        public void func_76184_a(@NotNull NBTTagCompound nbt) {
            Intrinsics.checkParameterIsNotNull((Object)nbt, (String)"nbt");
            NBTTagList nBTTagList = nbt.func_150295_c("moarboats.path", 10);
            Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagList, (String)"nbt.getTagList(\"${MoarBo\u2026nstants.NBT.TAG_COMPOUND)");
            this.backingList = nBTTagList;
            if (nbt.func_74767_n("moarboats.loops")) {
                this.loopingOption = LoopingOptions.Loops;
            }
            if (nbt.func_74764_b("moarboats.loopingOption")) {
                this.loopingOption = LoopingOptions.values()[RangesKt.coerceIn((int)nbt.func_74762_e("moarboats.loopingOption"), (ClosedRange)((ClosedRange)ArraysKt.getIndices((Object[])((Object[])LoopingOptions.values()))))];
            }
            String string = nbt.func_74779_i("moarboats.mapID");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"nbt.getString(\"${MoarBoats.ModID}.mapID\")");
            this.mapID = string;
        }

        @NotNull
        public final String getUuid() {
            return this.uuid;
        }

        public final void setUuid(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.uuid = string;
        }

        public WaypointData(@NotNull String uuid) {
            Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
            super(uuid);
            this.uuid = uuid;
            this.backingList = new NBTTagList();
            this.loopingOption = LoopingOptions.NoLoop;
            this.mapID = "";
        }

        @NotNull
        public final String component1() {
            return this.uuid;
        }

        @NotNull
        public final WaypointData copy(@NotNull String uuid) {
            Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
            return new WaypointData(uuid);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ WaypointData copy$default(WaypointData waypointData, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = waypointData.uuid;
            }
            return waypointData.copy(string);
        }

        public String toString() {
            return "WaypointData(uuid=" + this.uuid + ")";
        }

        public int hashCode() {
            String string = this.uuid;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof WaypointData)) break block3;
                    WaypointData waypointData = (WaypointData)((Object)object);
                    if (!Intrinsics.areEqual((Object)this.uuid, (Object)waypointData.uuid)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

