/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.items;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLeashKnot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.MoarBoats;
import org.jglrxavpok.moarboats.common.entities.BasicBoatEntity;
import org.jglrxavpok.moarboats.common.items.RopeItem$WhenMappings;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bJ&\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u001d2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0016JH\u0010!\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020(H\u0016J.\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010-\u001a\u00020\u0011J\u0010\u0010.\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\bH\u0002J \u0010/\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jglrxavpok/moarboats/common/items/RopeItem;", "Lnet/minecraft/item/Item;", "()V", "ropeInfo", "Lnet/minecraft/util/text/TextComponentTranslation;", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "worldIn", "Lnet/minecraft/world/World;", "tooltip", "", "", "flagIn", "Lnet/minecraft/client/util/ITooltipFlag;", "getLinked", "Lorg/jglrxavpok/moarboats/common/entities/BasicBoatEntity;", "getState", "Lorg/jglrxavpok/moarboats/common/items/RopeItem$State;", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "onEntityInteract", "Lnet/minecraft/util/EnumActionResult;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "entity", "Lnet/minecraft/entity/Entity;", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "playerIn", "handIn", "Lnet/minecraft/util/EnumHand;", "onItemUse", "pos", "Lnet/minecraft/util/math/BlockPos;", "hand", "facing", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "onLinkUsed", "itemstack", "boatEntity", "resetLinked", "setLinked", "State", "moarboats"})
public final class RopeItem
extends Item {
    private static final TextComponentTranslation ropeInfo;
    public static final RopeItem INSTANCE;

    private final void setLinked(World worldIn, ItemStack stack, BasicBoatEntity entity) {
        this.nbt(stack).func_74768_a("linked", entity.func_145782_y());
    }

    private final BasicBoatEntity getLinked(World worldIn, ItemStack stack) {
        int id = this.nbt(stack).func_74762_e("linked");
        return (BasicBoatEntity)worldIn.func_73045_a(id);
    }

    private final NBTTagCompound nbt(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nBTTagCompound = stack.func_77978_p();
        if (nBTTagCompound == null) {
            Intrinsics.throwNpe();
        }
        return nBTTagCompound;
    }

    private final void resetLinked(ItemStack itemstack) {
        this.nbt(itemstack).func_82580_o("linked");
    }

    @NotNull
    public final State getState(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (this.nbt(stack).func_74764_b("linked")) {
            return State.WAITING_NEXT;
        }
        return State.READY;
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World worldIn, @NotNull EntityPlayer playerIn, @NotNull EnumHand handIn) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)playerIn, (String)"playerIn");
        Intrinsics.checkParameterIsNotNull((Object)handIn, (String)"handIn");
        ItemStack itemStack = playerIn.func_184586_b(handIn);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"playerIn.getHeldItem(handIn)");
        this.resetLinked(itemStack);
        ActionResult actionResult = super.func_77659_a(worldIn, playerIn, handIn);
        Intrinsics.checkExpressionValueIsNotNull((Object)actionResult, (String)"super.onItemRightClick(worldIn, playerIn, handIn)");
        return actionResult;
    }

    public final void onLinkUsed(@NotNull ItemStack itemstack, @NotNull EntityPlayer playerIn, @NotNull EnumHand handIn, @NotNull World worldIn, @NotNull BasicBoatEntity boatEntity) {
        Intrinsics.checkParameterIsNotNull((Object)itemstack, (String)"itemstack");
        Intrinsics.checkParameterIsNotNull((Object)playerIn, (String)"playerIn");
        Intrinsics.checkParameterIsNotNull((Object)handIn, (String)"handIn");
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)boatEntity, (String)"boatEntity");
        switch (RopeItem$WhenMappings.$EnumSwitchMapping$0[this.getState(itemstack).ordinal()]) {
            case 1: {
                BasicBoatEntity basicBoatEntity = this.getLinked(worldIn, itemstack);
                if (basicBoatEntity == null) {
                    return;
                }
                BasicBoatEntity other = basicBoatEntity;
                BasicBoatEntity hit = boatEntity;
                if (Intrinsics.areEqual((Object)other, (Object)hit)) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("item.rope.notToSelf", new Object[0]), true);
                } else if (hit.hasLink(BasicBoatEntity.Companion.getBackLink())) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("item.rope.backOccupied", new Object[0]), true);
                } else {
                    hit.linkTo(other, BasicBoatEntity.Companion.getBackLink());
                    other.linkTo(hit, BasicBoatEntity.Companion.getFrontLink());
                }
                this.resetLinked(itemstack);
                if (playerIn.field_71075_bZ.field_75098_d) break;
                itemstack.func_190918_g(1);
                break;
            }
            default: {
                if (boatEntity.hasLink(BasicBoatEntity.Companion.getFrontLink())) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("item.rope.frontOccupied", new Object[0]), true);
                    this.resetLinked(itemstack);
                    break;
                }
                this.setLinked(worldIn, itemstack, boatEntity);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public EnumActionResult func_180614_a(@NotNull EntityPlayer player, @NotNull World worldIn, @NotNull BlockPos pos, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumActionResult enumActionResult;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        Intrinsics.checkParameterIsNotNull((Object)facing, (String)"facing");
        IBlockState iBlockState = worldIn.func_180495_p(pos);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"worldIn.getBlockState(pos)");
        Block block = iBlockState.func_177230_c();
        ItemStack stack = player.func_184586_b(hand);
        if (block instanceof BlockFence) {
            ItemStack itemStack = stack;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
            if (Intrinsics.areEqual((Object)((Object)this.getState(itemStack)), (Object)((Object)State.WAITING_NEXT))) {
                if (!worldIn.field_72995_K) {
                    EntityLeashKnot entityLeashKnot = EntityLeashKnot.func_174863_b((World)worldIn, (BlockPos)pos);
                    if (entityLeashKnot == null) {
                        entityLeashKnot = EntityLeashKnot.func_174862_a((World)worldIn, (BlockPos)pos);
                    }
                    EntityLeashKnot knot = entityLeashKnot;
                    BasicBoatEntity basicBoatEntity = this.getLinked(worldIn, stack);
                    if (basicBoatEntity == null) return EnumActionResult.PASS;
                    BasicBoatEntity target = basicBoatEntity;
                    target.linkTo((Entity)knot, BasicBoatEntity.Companion.getFrontLink());
                }
                this.resetLinked(stack);
                enumActionResult = EnumActionResult.SUCCESS;
                return enumActionResult;
            }
        }
        enumActionResult = EnumActionResult.PASS;
        return enumActionResult;
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<String> tooltip, @NotNull ITooltipFlag flagIn) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull(tooltip, (String)"tooltip");
        Intrinsics.checkParameterIsNotNull((Object)flagIn, (String)"flagIn");
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        String string = ropeInfo.func_150260_c();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ropeInfo.unformattedText");
        tooltip.add(string);
    }

    @NotNull
    public final EnumActionResult onEntityInteract(@NotNull EntityPlayer player, @NotNull ItemStack stack, @NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        if (Intrinsics.areEqual((Object)((Object)this.getState(stack)), (Object)((Object)State.WAITING_NEXT)) && entity instanceof EntityLeashKnot) {
            World world = player.field_70170_p;
            if (!world.field_72995_K) {
                World world2 = world;
                Intrinsics.checkExpressionValueIsNotNull((Object)world2, (String)"world");
                BasicBoatEntity basicBoatEntity = this.getLinked(world2, stack);
                if (basicBoatEntity == null) {
                    return EnumActionResult.PASS;
                }
                BasicBoatEntity target = basicBoatEntity;
                target.linkTo(entity, BasicBoatEntity.Companion.getFrontLink());
            }
            this.resetLinked(stack);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private RopeItem() {
    }

    static {
        RopeItem ropeItem;
        INSTANCE = ropeItem = new RopeItem();
        ropeItem.func_77637_a(MoarBoats.INSTANCE.getCreativeTab());
        ropeItem.func_77655_b("rope");
        ropeItem.setRegistryName(new ResourceLocation("moarboats", "rope"));
        ropeItem.func_185043_a(new ResourceLocation("firstKnot"), 1.INSTANCE);
        ropeInfo = new TextComponentTranslation("item.rope.description", new Object[0]);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jglrxavpok/moarboats/common/items/RopeItem$State;", "", "(Ljava/lang/String;I)V", "WAITING_NEXT", "READY", "moarboats"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State WAITING_NEXT;
        public static final /* enum */ State READY;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[2];
            State[] stateArray2 = stateArray;
            stateArray[0] = WAITING_NEXT = new State();
            stateArray[1] = READY = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }
}

