/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.modules;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.moarboats.api.BoatModule;
import org.jglrxavpok.moarboats.api.BoatModuleInventory;
import org.jglrxavpok.moarboats.api.IControllable;
import org.jglrxavpok.moarboats.client.gui.GuiEngineModule;
import org.jglrxavpok.moarboats.common.containers.ContainerBase;
import org.jglrxavpok.moarboats.common.modules.BlockedByRedstone;
import org.jglrxavpok.moarboats.common.modules.NoBlockReason;
import org.jglrxavpok.moarboats.common.state.BoatPropertyKt;
import org.jglrxavpok.moarboats.common.state.BooleanBoatProperty;
import org.jglrxavpok.moarboats.common.state.FloatBoatProperty;
import org.jglrxavpok.moarboats.extensions.MathExtensionsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 62\u00020\u0001:\u00016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H&J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$H&J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u001c\u001a\u00020\u0018H&J\u000e\u0010'\u001a\u00020&2\u0006\u0010#\u001a\u00020$J\u000e\u0010(\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010)\u001a\u00020&2\u0006\u0010\u001c\u001a\u00020\u0018J\u0010\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u0018H\u0016J\u0010\u0010,\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0018H&J\u0010\u0010-\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0018H&J\u0016\u0010.\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010/\u001a\u00020&J\u0010\u00100\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J \u00101\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H$R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\n\u00a8\u00067"}, d2={"Lorg/jglrxavpok/moarboats/common/modules/BaseEngineModule;", "Lorg/jglrxavpok/moarboats/api/BoatModule;", "()V", "hopperPriority", "", "getHopperPriority", "()I", "lockedByRedstoneProperty", "Lorg/jglrxavpok/moarboats/common/state/BooleanBoatProperty;", "getLockedByRedstoneProperty", "()Lorg/jglrxavpok/moarboats/common/state/BooleanBoatProperty;", "moduleSpot", "Lorg/jglrxavpok/moarboats/api/BoatModule$Spot;", "getModuleSpot", "()Lorg/jglrxavpok/moarboats/api/BoatModule$Spot;", "speedProperty", "Lorg/jglrxavpok/moarboats/common/state/FloatBoatProperty;", "getSpeedProperty", "()Lorg/jglrxavpok/moarboats/common/state/FloatBoatProperty;", "stationaryProperty", "getStationaryProperty", "changeSpeed", "", "boat", "Lorg/jglrxavpok/moarboats/api/IControllable;", "speed", "", "controlBoat", "from", "createGui", "Lnet/minecraft/client/gui/GuiScreen;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "estimatedTotalTicks", "getFuelTime", "fuelItem", "Lnet/minecraft/item/ItemStack;", "hasFuel", "", "isItemFuel", "isLockedByRedstone", "isStationary", "onAddition", "to", "remainingTimeInPercent", "remainingTimeInTicks", "setStationary", "newState", "update", "updateFuelState", "state", "Lnet/minecraft/nbt/NBTTagCompound;", "inv", "Lnet/minecraft/inventory/IInventory;", "Companion", "moarboats"})
public abstract class BaseEngineModule
extends BoatModule {
    @NotNull
    private final BooleanBoatProperty stationaryProperty = BoatPropertyKt.BooleanBoatProperty(this, "stationary");
    @NotNull
    private final BooleanBoatProperty lockedByRedstoneProperty = BoatPropertyKt.BooleanBoatProperty(this, "redstoneLocked");
    @NotNull
    private final FloatBoatProperty speedProperty = BoatPropertyKt.FloatBoatProperty(this, "speedSetting");
    @NotNull
    private final BoatModule.Spot moduleSpot = BoatModule.Spot.Engine;
    private final int hopperPriority = 0;
    private static final int SECONDS_TO_TICKS = 20;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final BooleanBoatProperty getStationaryProperty() {
        return this.stationaryProperty;
    }

    @NotNull
    public final BooleanBoatProperty getLockedByRedstoneProperty() {
        return this.lockedByRedstoneProperty;
    }

    @NotNull
    public final FloatBoatProperty getSpeedProperty() {
        return this.speedProperty;
    }

    @Override
    @NotNull
    public BoatModule.Spot getModuleSpot() {
        return this.moduleSpot;
    }

    @Override
    public int getHopperPriority() {
        return this.hopperPriority;
    }

    public abstract boolean hasFuel(@NotNull IControllable var1);

    public abstract int getFuelTime(@NotNull ItemStack var1);

    protected abstract void updateFuelState(@NotNull IControllable var1, @NotNull NBTTagCompound var2, @NotNull IInventory var3);

    public abstract float remainingTimeInTicks(@NotNull IControllable var1);

    public abstract float remainingTimeInPercent(@NotNull IControllable var1);

    public abstract float estimatedTotalTicks(@NotNull IControllable var1);

    public final boolean isStationary(@NotNull IControllable from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        return (Boolean)this.stationaryProperty.get(from) != false || Intrinsics.areEqual((Object)from.getBlockedReason(), (Object)NoBlockReason.INSTANCE) ^ true;
    }

    @Override
    public void controlBoat(@NotNull IControllable from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        if (this.hasFuel(from) && !this.isStationary(from) && from.inLiquid()) {
            float speed = from.isSpeedImposed() ? from.getImposedSpeed() : ((Number)this.speedProperty.get(from)).floatValue();
            from.accelerate(speed + 1.0f);
        }
        if (((Boolean)this.lockedByRedstoneProperty.get(from)).booleanValue()) {
            if (!from.getWorldRef().field_72995_K) {
                Object v0;
                block8: {
                    Iterable $receiver$iv = from.getModules();
                    for (Object element$iv : $receiver$iv) {
                        BoatModule it = (BoatModule)element$iv;
                        if (!Intrinsics.areEqual((Object)((Object)it.getModuleSpot()), (Object)((Object)BoatModule.Spot.Storage))) continue;
                        v0 = element$iv;
                        break block8;
                    }
                    v0 = null;
                }
                BoatModule storage = v0;
                if (storage != null && storage.getUsesInventory()) {
                    IBlockState blockState;
                    BlockPos hopperPos = from.getCorrespondingEntity().func_180425_c().func_177984_a();
                    IBlockState iBlockState = blockState = from.getWorldRef().func_180495_p(hopperPos);
                    Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"blockState");
                    if (iBlockState.func_177230_c() instanceof BlockHopper) {
                        TileEntity tileEntity = from.getWorldRef().func_175625_s(hopperPos);
                        if (tileEntity == null) {
                            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.tileentity.TileEntityHopper");
                        }
                        TileEntityHopper te = (TileEntityHopper)tileEntity;
                        BoatModuleInventory storageInventory = from.getInventory(storage);
                        if (!storageInventory.canAddAnyFrom((IInventory)te)) {
                            return;
                        }
                    }
                }
            }
            from.blockMovement(BlockedByRedstone.INSTANCE);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    public GuiScreen createGui(@NotNull EntityPlayer player, @NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        InventoryPlayer inventoryPlayer = player.field_71071_by;
        Intrinsics.checkExpressionValueIsNotNull((Object)inventoryPlayer, (String)"player.inventory");
        BoatModule boatModule = this;
        ContainerBase containerBase = this.createContainer(player, boat);
        if (containerBase == null) {
            Intrinsics.throwNpe();
        }
        return (GuiScreen)new GuiEngineModule(inventoryPlayer, boatModule, boat, containerBase);
    }

    @Override
    public void onAddition(@NotNull IControllable to) {
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        this.stationaryProperty.set(to, true);
        this.lockedByRedstoneProperty.set(to, false);
        this.speedProperty.set(to, Float.valueOf(0.0f));
    }

    @Override
    public void update(@NotNull IControllable from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        NBTTagCompound state = this.getState(from);
        if (this.getUsesInventory()) {
            BoatModuleInventory inv = this.getInventory(from);
            this.updateFuelState(from, state, (IInventory)inv);
        }
        World world = from.getWorldRef();
        this.lockedByRedstoneProperty.set(from, world.func_175640_z(from.getCorrespondingEntity().func_180425_c()));
        this.saveState(from);
        if (this.hasFuel(from) && !this.isStationary(from)) {
            int count = (int)(Math.random() * (double)5 + (double)3);
            double posX = from.getPositionX();
            double posY = from.getPositionY();
            double posZ = from.getPositionZ();
            float rotationYaw = from.getYaw();
            float angle = MathExtensionsKt.toRadians(rotationYaw + 90.0f);
            float distAlongLength = -1.0625f;
            BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185345_c((double)posX, (double)(posY - 0.5), (double)posZ);
            IBlockState blockState = from.getWorldRef().func_180495_p((BlockPos)pos);
            int n = 0;
            int n2 = count - 1;
            if (n <= n2) {
                do {
                    int it = ++n;
                    double distAlongWidth = (double)0.5f * (Math.random() * 2.0 - 1.0);
                    double anchorX = posX + (double)(MathHelper.func_76134_b((float)angle) * distAlongLength) + (double)MathHelper.func_76126_a((float)angle) * distAlongWidth;
                    double anchorY = posY + (double)0.25f;
                    double anchorZ = posZ + (double)(MathHelper.func_76126_a((float)angle) * distAlongLength) - (double)MathHelper.func_76134_b((float)angle) * distAlongWidth;
                    IBlockState iBlockState = blockState;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"blockState");
                    EnumParticleTypes particleType = Intrinsics.areEqual((Object)iBlockState.func_185904_a(), (Object)Material.field_151586_h) ? EnumParticleTypes.WATER_SPLASH : EnumParticleTypes.BLOCK_CRACK;
                    from.getWorldRef().func_175688_a(particleType, anchorX, anchorY, anchorZ, -from.getVelocityX(), 1.0, -from.getVelocityZ(), new int[]{Block.func_176210_f((IBlockState)blockState)});
                } while (n != n2);
            }
            pos.func_185344_t();
        }
    }

    public final void setStationary(@NotNull IControllable boat, boolean newState) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        boolean isStationary = (Boolean)this.stationaryProperty.get(boat);
        this.stationaryProperty.set(boat, newState);
    }

    public final void changeSpeed(@NotNull IControllable boat, float speed) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        this.speedProperty.set(boat, Float.valueOf(speed));
    }

    public final boolean isItemFuel(@NotNull ItemStack fuelItem) {
        Intrinsics.checkParameterIsNotNull((Object)fuelItem, (String)"fuelItem");
        return this.getFuelTime(fuelItem) > 0;
    }

    public final boolean isLockedByRedstone(@NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        return (Boolean)this.lockedByRedstoneProperty.get(boat);
    }

    static {
        SECONDS_TO_TICKS = 20;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jglrxavpok/moarboats/common/modules/BaseEngineModule$Companion;", "", "()V", "SECONDS_TO_TICKS", "", "getSECONDS_TO_TICKS", "()I", "moarboats"})
    public static final class Companion {
        public final int getSECONDS_TO_TICKS() {
            return SECONDS_TO_TICKS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

