/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.modules;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.api.BoatModule;
import org.jglrxavpok.moarboats.api.IControllable;
import org.jglrxavpok.moarboats.client.gui.GuiTankModule;
import org.jglrxavpok.moarboats.common.MoarBoatsConfig;
import org.jglrxavpok.moarboats.common.blocks.BlockBoatTank;
import org.jglrxavpok.moarboats.common.containers.ContainerBase;
import org.jglrxavpok.moarboats.common.containers.EmptyContainer;
import org.jglrxavpok.moarboats.common.modules.IFluidBoatModule;
import org.jglrxavpok.moarboats.common.state.BoatPropertyKt;
import org.jglrxavpok.moarboats.common.state.IntBoatProperty;
import org.jglrxavpok.moarboats.common.state.StringBoatProperty;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001aH\u0016J\u001a\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010'\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u0015H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020\u001aH\u0016J(\u0010-\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0015H\u0016J\u0010\u00101\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001aH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00062"}, d2={"Lorg/jglrxavpok/moarboats/common/modules/FluidTankModule;", "Lorg/jglrxavpok/moarboats/api/BoatModule;", "Lorg/jglrxavpok/moarboats/common/modules/IFluidBoatModule;", "()V", "fluidAmountProperty", "Lorg/jglrxavpok/moarboats/common/state/IntBoatProperty;", "getFluidAmountProperty", "()Lorg/jglrxavpok/moarboats/common/state/IntBoatProperty;", "fluidNameProperty", "Lorg/jglrxavpok/moarboats/common/state/StringBoatProperty;", "getFluidNameProperty", "()Lorg/jglrxavpok/moarboats/common/state/StringBoatProperty;", "id", "Lnet/minecraft/util/ResourceLocation;", "getId", "()Lnet/minecraft/util/ResourceLocation;", "moduleSpot", "Lorg/jglrxavpok/moarboats/api/BoatModule$Spot;", "getModuleSpot", "()Lorg/jglrxavpok/moarboats/api/BoatModule$Spot;", "usesInventory", "", "getUsesInventory", "()Z", "canBeDrained", "boat", "Lorg/jglrxavpok/moarboats/api/IControllable;", "fluidStack", "Lnet/minecraftforge/fluids/FluidStack;", "canBeFilled", "controlBoat", "", "from", "createContainer", "Lorg/jglrxavpok/moarboats/common/containers/ContainerBase;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "createGui", "Lnet/minecraft/client/gui/GuiScreen;", "dropItemsOnDeath", "killedByPlayerInCreative", "getCapacity", "", "onAddition", "to", "onInteract", "hand", "Lnet/minecraft/util/EnumHand;", "sneaking", "update", "moarboats"})
public final class FluidTankModule
extends BoatModule
implements IFluidBoatModule {
    @NotNull
    private static final ResourceLocation id;
    private static final boolean usesInventory = false;
    @NotNull
    private static final BoatModule.Spot moduleSpot;
    @NotNull
    private static final StringBoatProperty fluidNameProperty;
    @NotNull
    private static final IntBoatProperty fluidAmountProperty;
    public static final FluidTankModule INSTANCE;

    @Override
    @NotNull
    public ResourceLocation getId() {
        return id;
    }

    @Override
    public boolean getUsesInventory() {
        return usesInventory;
    }

    @Override
    @NotNull
    public BoatModule.Spot getModuleSpot() {
        return moduleSpot;
    }

    @Override
    @NotNull
    public StringBoatProperty getFluidNameProperty() {
        return fluidNameProperty;
    }

    @Override
    @NotNull
    public IntBoatProperty getFluidAmountProperty() {
        return fluidAmountProperty;
    }

    @Override
    public boolean onInteract(@NotNull IControllable from, @NotNull EntityPlayer player, @NotNull EnumHand hand, boolean sneaking) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            IFluidHandlerItem capability;
            IFluidHandlerItem iFluidHandlerItem = capability = (IFluidHandlerItem)heldItem.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (iFluidHandlerItem != null) {
                IFluidHandlerItem iFluidHandlerItem2;
                IFluidHandlerItem it = iFluidHandlerItem2 = iFluidHandlerItem;
                FluidStack potentialDrain = capability.drain(1000, false);
                if (potentialDrain != null) {
                    int accepted = INSTANCE.fill(from, potentialDrain, true);
                    if (accepted > 0) {
                        FluidStack fluidStack = capability.drain(1000, true);
                        if (fluidStack == null) {
                            Intrinsics.throwNpe();
                        }
                        FluidStack drained = fluidStack;
                        player.func_184611_a(hand, capability.getContainer());
                        FluidStack fluidStack2 = drained;
                        Intrinsics.checkExpressionValueIsNotNull((Object)fluidStack2, (String)"drained");
                        INSTANCE.fill(from, fluidStack2, false);
                    }
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public void controlBoat(@NotNull IControllable from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
    }

    @Override
    public void update(@NotNull IControllable from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
    }

    @Override
    public void onAddition(@NotNull IControllable to) {
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        this.getFluidNameProperty().set(to, "");
        this.getFluidAmountProperty().set(to, 0);
    }

    @Override
    @Nullable
    public ContainerBase createContainer(@NotNull EntityPlayer player, @NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        InventoryPlayer inventoryPlayer = player.field_71071_by;
        Intrinsics.checkExpressionValueIsNotNull((Object)inventoryPlayer, (String)"player.inventory");
        return new EmptyContainer(inventoryPlayer, false, 0, 6, null);
    }

    @Override
    @NotNull
    public GuiScreen createGui(@NotNull EntityPlayer player, @NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        InventoryPlayer inventoryPlayer = player.field_71071_by;
        Intrinsics.checkExpressionValueIsNotNull((Object)inventoryPlayer, (String)"player.inventory");
        return (GuiScreen)new GuiTankModule(inventoryPlayer, this, boat);
    }

    @Override
    public int getCapacity(@NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        return MoarBoatsConfig.fluidTank.tankCapacity;
    }

    @Override
    public boolean canBeFilled(@NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        return true;
    }

    @Override
    public boolean canBeDrained(@NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        return true;
    }

    @Override
    public boolean canBeFilled(@NotNull IControllable boat, @NotNull FluidStack fluidStack) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        Intrinsics.checkParameterIsNotNull((Object)fluidStack, (String)"fluidStack");
        return true;
    }

    @Override
    public boolean canBeDrained(@NotNull IControllable boat, @NotNull FluidStack fluidStack) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        Intrinsics.checkParameterIsNotNull((Object)fluidStack, (String)"fluidStack");
        return true;
    }

    @Override
    public void dropItemsOnDeath(@NotNull IControllable boat, boolean killedByPlayerInCreative) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        if (!killedByPlayerInCreative) {
            boat.getCorrespondingEntity().func_145779_a(ItemBlock.func_150898_a((Block)BlockBoatTank.INSTANCE), 1);
        }
    }

    private FluidTankModule() {
    }

    static {
        FluidTankModule fluidTankModule;
        INSTANCE = fluidTankModule = new FluidTankModule();
        id = new ResourceLocation("moarboats", "fluid_tank");
        moduleSpot = BoatModule.Spot.Storage;
        fluidNameProperty = BoatPropertyKt.StringBoatProperty(fluidTankModule, "fluid_name");
        fluidAmountProperty = BoatPropertyKt.IntBoatProperty(fluidTankModule, "fluid_amount");
    }

    @Override
    @Nullable
    public FluidStack getContents(@NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        return IFluidBoatModule.DefaultImpls.getContents(this, boat);
    }

    @Override
    @Nullable
    public Fluid getFluidInside(@NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        return IFluidBoatModule.DefaultImpls.getFluidInside(this, boat);
    }

    @Override
    public int getFluidAmount(@NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        return IFluidBoatModule.DefaultImpls.getFluidAmount(this, boat);
    }

    @Override
    public int fill(@NotNull IControllable boat, @NotNull FluidStack resource, boolean simulate) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        return IFluidBoatModule.DefaultImpls.fill(this, boat, resource, simulate);
    }

    @Override
    @Nullable
    public FluidStack drain(@NotNull IControllable boat, @NotNull FluidStack resource, boolean simulate) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        return IFluidBoatModule.DefaultImpls.drain((IFluidBoatModule)this, boat, resource, simulate);
    }

    @Override
    @Nullable
    public FluidStack drain(@NotNull IControllable boat, int amount, boolean simulate) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        return IFluidBoatModule.DefaultImpls.drain((IFluidBoatModule)this, boat, amount, simulate);
    }
}

