/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.moarboats.api.BoatModule;
import org.jglrxavpok.moarboats.api.IControllable;
import org.jglrxavpok.moarboats.client.gui.GuiNoConfigModule;
import org.jglrxavpok.moarboats.common.containers.EmptyContainer;
import org.jglrxavpok.moarboats.common.entities.BasicBoatEntity;
import org.jglrxavpok.moarboats.common.items.IceBreakerItem;
import org.jglrxavpok.moarboats.extensions.MathExtensionsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010!\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\bH\u0016J\u0018\u0010#\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010$\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u0013H\u0016J(\u0010(\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\bH\u0016J \u0010,\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010-\u001a\u00020%H\u0002J\u0010\u0010.\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0013H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\t\u00a8\u0006/"}, d2={"Lorg/jglrxavpok/moarboats/common/modules/IceBreakerModule;", "Lorg/jglrxavpok/moarboats/api/BoatModule;", "()V", "id", "Lnet/minecraft/util/ResourceLocation;", "getId", "()Lnet/minecraft/util/ResourceLocation;", "isMenuInteresting", "", "()Z", "moduleSpot", "Lorg/jglrxavpok/moarboats/api/BoatModule$Spot;", "getModuleSpot", "()Lorg/jglrxavpok/moarboats/api/BoatModule$Spot;", "usesInventory", "getUsesInventory", "clearBreakProgress", "", "boat", "Lorg/jglrxavpok/moarboats/api/IControllable;", "pos", "Lnet/minecraft/util/math/BlockPos;", "clearNotUpdatedFor", "ticks", "", "controlBoat", "from", "createContainer", "Lorg/jglrxavpok/moarboats/common/containers/EmptyContainer;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "createGui", "Lnet/minecraft/client/gui/GuiScreen;", "dropItemsOnDeath", "killedByPlayerInCreative", "getBlockIndex", "getBreakProgress", "", "onAddition", "to", "onInteract", "hand", "Lnet/minecraft/util/EnumHand;", "sneaking", "setBreakProgress", "progress", "update", "moarboats"})
public final class IceBreakerModule
extends BoatModule {
    @NotNull
    private static final ResourceLocation id;
    private static final boolean usesInventory = false;
    @NotNull
    private static final BoatModule.Spot moduleSpot;
    private static final boolean isMenuInteresting = false;
    public static final IceBreakerModule INSTANCE;

    @Override
    @NotNull
    public ResourceLocation getId() {
        return id;
    }

    @Override
    public boolean getUsesInventory() {
        return usesInventory;
    }

    @Override
    @NotNull
    public BoatModule.Spot getModuleSpot() {
        return moduleSpot;
    }

    @Override
    public boolean isMenuInteresting() {
        return isMenuInteresting;
    }

    @Override
    public boolean onInteract(@NotNull IControllable from, @NotNull EntityPlayer player, @NotNull EnumHand hand, boolean sneaking) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        return false;
    }

    @Override
    public void controlBoat(@NotNull IControllable from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
    }

    @Override
    public void onAddition(@NotNull IControllable to) {
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
    }

    @Override
    public void update(@NotNull IControllable from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        World world = from.getWorldRef();
        AxisAlignedBB bb = from.getCorrespondingEntity().func_174813_aQ().func_191194_a(from.calculateAnchorPosition(BasicBoatEntity.Companion.getFrontLink())).func_72317_d(-from.getPositionX(), -from.getPositionY() - (double)0.75f, -from.getPositionZ()).func_72321_a(1.0, 1.0, 1.0);
        List collidedBB = world.func_184144_a(from.getCorrespondingEntity(), bb);
        BlockPos.PooledMutableBlockPos blockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        Iterator iterator = collidedBB.iterator();
        while (iterator.hasNext()) {
            IBlockState blockAtCenter;
            AxisAlignedBB box;
            AxisAlignedBB axisAlignedBB = box = (AxisAlignedBB)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)axisAlignedBB, (String)"box");
            Vec3d center = MathExtensionsKt.getCenterForAllSides(axisAlignedBB);
            blockPos.func_189532_c(center.field_72450_a, center.field_72448_b, center.field_72449_c);
            IBlockState iBlockState = blockAtCenter = world.func_180495_p((BlockPos)blockPos);
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"blockAtCenter");
            if (!(iBlockState.func_177230_c() instanceof BlockIce)) continue;
            BlockPos.PooledMutableBlockPos pooledMutableBlockPos = blockPos;
            Intrinsics.checkExpressionValueIsNotNull((Object)pooledMutableBlockPos, (String)"blockPos");
            float progress = this.getBreakProgress(from, (BlockPos)pooledMutableBlockPos);
            progress += blockAtCenter.func_185887_b(world, (BlockPos)blockPos) / 20.0f;
            if (progress < 1.0f) {
                this.setBreakProgress(from, (BlockPos)blockPos, progress);
                int blockIndex = this.getBlockIndex(from, (BlockPos)blockPos);
                int fakeEntityID = -from.getEntityID() * blockIndex;
                world.func_175715_c(fakeEntityID, new BlockPos((Vec3i)blockPos), (int)(progress * 10.0f));
                continue;
            }
            this.clearBreakProgress(from, (BlockPos)blockPos);
            BlockPos blockPos2 = (BlockPos)blockPos;
            BlockStaticLiquid blockStaticLiquid = Blocks.field_150355_j;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockStaticLiquid, (String)"Blocks.WATER");
            world.func_175656_a(blockPos2, blockStaticLiquid.func_176223_P());
        }
        this.clearNotUpdatedFor(from, 20);
        this.saveState(from);
        blockPos.func_185344_t();
    }

    /*
     * WARNING - void declaration
     */
    private final int getBlockIndex(IControllable boat, BlockPos pos) {
        NBTTagCompound state = this.getState(boat);
        Set set = state.func_150296_c();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"state.keySet");
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)set)) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            String key;
            int index = indexedValue.component1();
            String string = key = (String)indexedValue.component2();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"Timestamp", (boolean)false, (int)2, null)) continue;
            Iterable iterable = $receiver$iv = (Iterable)CollectionsKt.drop((Iterable)StringsKt.split$default((CharSequence)key, (String[])new String[]{"_"}, (boolean)false, (int)0, (int)6, null), (int)1);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                String string3 = StringsKt.drop((String)it, (int)1);
                Integer n = Integer.parseInt(string3);
                collection.add(n);
            }
            List positions = (List)destination$iv$iv;
            int x = ((Number)positions.get(0)).intValue();
            int y = ((Number)positions.get(1)).intValue();
            int z = ((Number)positions.get(2)).intValue();
            if (x != pos.func_177958_n() || y != pos.func_177956_o() || z != pos.func_177952_p()) continue;
            return index;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private final void clearNotUpdatedFor(IControllable boat, int ticks) {
        NBTTagCompound state = this.getState(boat);
        BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
        Set set = state.func_150296_c();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"state.keySet");
        List keys = CollectionsKt.toList((Iterable)set);
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            int timeDiff;
            String key;
            String string = key = (String)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"Timestamp", (boolean)false, (int)2, null) || (timeDiff = boat.getCorrespondingEntity().field_70173_aa - state.func_74762_e(key)) < ticks) continue;
            Iterable iterable = $receiver$iv = (Iterable)CollectionsKt.drop((Iterable)StringsKt.split$default((CharSequence)key, (String[])new String[]{"_"}, (boolean)false, (int)0, (int)6, null), (int)1);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                String string3 = StringsKt.drop((String)it, (int)1);
                Integer n = Integer.parseInt(string3);
                collection.add(n);
            }
            List positions = (List)destination$iv$iv;
            int x = ((Number)positions.get(0)).intValue();
            int y = ((Number)positions.get(1)).intValue();
            int z = ((Number)positions.get(2)).intValue();
            pos.func_181079_c(x, y, z);
            boat.getWorldRef().func_175715_c(boat.getEntityID(), (BlockPos)pos, -1);
            BlockPos.PooledMutableBlockPos pooledMutableBlockPos = pos;
            Intrinsics.checkExpressionValueIsNotNull((Object)pooledMutableBlockPos, (String)"pos");
            this.clearBreakProgress(boat, (BlockPos)pooledMutableBlockPos);
        }
        pos.func_185344_t();
    }

    private final void clearBreakProgress(IControllable boat, BlockPos pos) {
        NBTTagCompound state = this.getState(boat);
        state.func_82580_o("breakProgress_X" + pos.func_177958_n() + "_Y" + pos.func_177956_o() + "_Z" + pos.func_177952_p());
        state.func_82580_o("breakTimestamp_X" + pos.func_177958_n() + "_Y" + pos.func_177956_o() + "_Z" + pos.func_177952_p());
    }

    private final void setBreakProgress(IControllable boat, BlockPos pos, float progress) {
        NBTTagCompound state = this.getState(boat);
        state.func_74776_a("breakProgress_X" + pos.func_177958_n() + "_Y" + pos.func_177956_o() + "_Z" + pos.func_177952_p(), progress);
        state.func_74768_a("breakTimestamp_X" + pos.func_177958_n() + "_Y" + pos.func_177956_o() + "_Z" + pos.func_177952_p(), boat.getCorrespondingEntity().field_70173_aa);
    }

    private final float getBreakProgress(IControllable boat, BlockPos pos) {
        NBTTagCompound state = this.getState(boat);
        return state.func_74760_g("breakProgress_X" + pos.func_177958_n() + "_Y" + pos.func_177956_o() + "_Z" + pos.func_177952_p());
    }

    @Override
    @NotNull
    public EmptyContainer createContainer(@NotNull EntityPlayer player, @NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        InventoryPlayer inventoryPlayer = player.field_71071_by;
        Intrinsics.checkExpressionValueIsNotNull((Object)inventoryPlayer, (String)"player.inventory");
        return new EmptyContainer(inventoryPlayer, false, 0, 6, null);
    }

    @Override
    @NotNull
    public GuiScreen createGui(@NotNull EntityPlayer player, @NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        InventoryPlayer inventoryPlayer = player.field_71071_by;
        Intrinsics.checkExpressionValueIsNotNull((Object)inventoryPlayer, (String)"player.inventory");
        return (GuiScreen)new GuiNoConfigModule(inventoryPlayer, this, boat);
    }

    @Override
    public void dropItemsOnDeath(@NotNull IControllable boat, boolean killedByPlayerInCreative) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        if (!killedByPlayerInCreative) {
            boat.getCorrespondingEntity().func_145779_a((Item)IceBreakerItem.INSTANCE, 1);
        }
    }

    private IceBreakerModule() {
    }

    static {
        IceBreakerModule iceBreakerModule;
        INSTANCE = iceBreakerModule = new IceBreakerModule();
        id = new ResourceLocation("moarboats", "icebreaker");
        moduleSpot = BoatModule.Spot.Misc;
    }
}

