/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.network;

import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.common.entities.ModularBoatEntity;
import org.jglrxavpok.moarboats.common.modules.HelmModule;
import org.jglrxavpok.moarboats.common.network.MBMessageHandler;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001eB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0013\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000b\"\u0004\b\u0015\u0010\rR\u001a\u0010\u0016\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000b\"\u0004\b\u0018\u0010\r\u00a8\u0006\u001f"}, d2={"Lorg/jglrxavpok/moarboats/common/network/CAddWaypoint;", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;", "blockPos", "Lnet/minecraft/util/math/BlockPos;", "boatID", "", "boost", "", "(Lnet/minecraft/util/math/BlockPos;ILjava/lang/Double;)V", "()V", "getBoatID", "()I", "setBoatID", "(I)V", "getBoost", "()Ljava/lang/Double;", "setBoost", "(Ljava/lang/Double;)V", "Ljava/lang/Double;", "x", "getX", "setX", "z", "getZ", "setZ", "fromBytes", "", "buf", "Lio/netty/buffer/ByteBuf;", "toBytes", "Handler", "moarboats"})
public final class CAddWaypoint
implements IMessage {
    private int x;
    private int z;
    private int boatID;
    @Nullable
    private Double boost;

    public final int getX() {
        return this.x;
    }

    public final void setX(int n) {
        this.x = n;
    }

    public final int getZ() {
        return this.z;
    }

    public final void setZ(int n) {
        this.z = n;
    }

    public final int getBoatID() {
        return this.boatID;
    }

    public final void setBoatID(int n) {
        this.boatID = n;
    }

    @Nullable
    public final Double getBoost() {
        return this.boost;
    }

    public final void setBoost(@Nullable Double d) {
        this.boost = d;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        this.x = buf.readInt();
        this.z = buf.readInt();
        this.boatID = buf.readInt();
        this.boost = buf.readBoolean() ? Double.valueOf(buf.readDouble()) : null;
    }

    public void toBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        buf.writeInt(this.x);
        buf.writeInt(this.z);
        buf.writeInt(this.boatID);
        buf.writeBoolean(this.boost != null);
        if (this.boost != null) {
            Double d = this.boost;
            if (d == null) {
                Intrinsics.throwNpe();
            }
            buf.writeDouble(d.doubleValue());
        }
    }

    public CAddWaypoint() {
    }

    public CAddWaypoint(@NotNull BlockPos blockPos, int boatID, @Nullable Double boost) {
        Intrinsics.checkParameterIsNotNull((Object)blockPos, (String)"blockPos");
        this();
        this.x = blockPos.func_177958_n();
        this.z = blockPos.func_177952_p();
        this.boatID = boatID;
        this.boost = boost;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jglrxavpok/moarboats/common/network/CAddWaypoint$Handler;", "Lorg/jglrxavpok/moarboats/common/network/MBMessageHandler;", "Lorg/jglrxavpok/moarboats/common/network/CAddWaypoint;", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;", "()V", "packetClass", "Lkotlin/reflect/KClass;", "getPacketClass", "()Lkotlin/reflect/KClass;", "receiverSide", "Lnet/minecraftforge/fml/relauncher/Side;", "getReceiverSide", "()Lnet/minecraftforge/fml/relauncher/Side;", "onMessage", "message", "ctx", "Lnet/minecraftforge/fml/common/network/simpleimpl/MessageContext;", "moarboats"})
    public static final class Handler
    implements MBMessageHandler<CAddWaypoint, IMessage> {
        @NotNull
        private static final KClass<CAddWaypoint> packetClass;
        @NotNull
        private static final Side receiverSide;
        public static final Handler INSTANCE;

        @Override
        @NotNull
        public KClass<CAddWaypoint> getPacketClass() {
            return packetClass;
        }

        @Override
        @NotNull
        public Side getReceiverSide() {
            return receiverSide;
        }

        @Nullable
        public IMessage onMessage(@NotNull CAddWaypoint message, @NotNull MessageContext ctx) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            World world = player.field_70170_p;
            Entity entity = world.func_73045_a(message.getBoatID());
            if (!(entity instanceof ModularBoatEntity)) {
                entity = null;
            }
            ModularBoatEntity modularBoatEntity = (ModularBoatEntity)entity;
            if (modularBoatEntity == null) {
                return null;
            }
            ModularBoatEntity boat = modularBoatEntity;
            HelmModule.INSTANCE.addWaypoint(boat, message.getX(), message.getZ(), message.getBoost());
            return null;
        }

        private Handler() {
        }

        static {
            Handler handler;
            INSTANCE = handler = new Handler();
            packetClass = Reflection.getOrCreateKotlinClass(CAddWaypoint.class);
            receiverSide = Side.SERVER;
        }

        @Override
        public void registerSelf(@NotNull SimpleNetworkWrapper network, int packetID) {
            Intrinsics.checkParameterIsNotNull((Object)network, (String)"network");
            MBMessageHandler.DefaultImpls.registerSelf(this, network, packetID);
        }
    }
}

