/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.network;

import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.common.data.LoopingOptions;
import org.jglrxavpok.moarboats.common.entities.ModularBoatEntity;
import org.jglrxavpok.moarboats.common.modules.HelmModule;
import org.jglrxavpok.moarboats.common.network.MBMessageHandler;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0016B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/jglrxavpok/moarboats/common/network/CChangeLoopingState;", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;", "loopingOptions", "Lorg/jglrxavpok/moarboats/common/data/LoopingOptions;", "boatID", "", "(Lorg/jglrxavpok/moarboats/common/data/LoopingOptions;I)V", "()V", "getBoatID", "()I", "setBoatID", "(I)V", "loopingOption", "getLoopingOption", "()Lorg/jglrxavpok/moarboats/common/data/LoopingOptions;", "setLoopingOption", "(Lorg/jglrxavpok/moarboats/common/data/LoopingOptions;)V", "fromBytes", "", "buf", "Lio/netty/buffer/ByteBuf;", "toBytes", "Handler", "moarboats"})
public final class CChangeLoopingState
implements IMessage {
    private int boatID;
    @NotNull
    private LoopingOptions loopingOption;

    public final int getBoatID() {
        return this.boatID;
    }

    public final void setBoatID(int n) {
        this.boatID = n;
    }

    @NotNull
    public final LoopingOptions getLoopingOption() {
        return this.loopingOption;
    }

    public final void setLoopingOption(@NotNull LoopingOptions loopingOptions) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)loopingOptions), (String)"<set-?>");
        this.loopingOption = loopingOptions;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        this.boatID = buf.readInt();
        this.loopingOption = LoopingOptions.values()[RangesKt.coerceIn((int)buf.readInt(), (ClosedRange)((ClosedRange)ArraysKt.getIndices((Object[])((Object[])LoopingOptions.values()))))];
    }

    public void toBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        buf.writeInt(this.boatID);
        buf.writeInt(this.loopingOption.ordinal());
    }

    public CChangeLoopingState() {
        this.loopingOption = LoopingOptions.NoLoop;
    }

    public CChangeLoopingState(@NotNull LoopingOptions loopingOptions, int boatID) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)loopingOptions), (String)"loopingOptions");
        this();
        this.boatID = boatID;
        this.loopingOption = loopingOptions;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jglrxavpok/moarboats/common/network/CChangeLoopingState$Handler;", "Lorg/jglrxavpok/moarboats/common/network/MBMessageHandler;", "Lorg/jglrxavpok/moarboats/common/network/CChangeLoopingState;", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;", "()V", "packetClass", "Lkotlin/reflect/KClass;", "getPacketClass", "()Lkotlin/reflect/KClass;", "receiverSide", "Lnet/minecraftforge/fml/relauncher/Side;", "getReceiverSide", "()Lnet/minecraftforge/fml/relauncher/Side;", "onMessage", "message", "ctx", "Lnet/minecraftforge/fml/common/network/simpleimpl/MessageContext;", "moarboats"})
    public static final class Handler
    implements MBMessageHandler<CChangeLoopingState, IMessage> {
        @NotNull
        private static final KClass<CChangeLoopingState> packetClass;
        @NotNull
        private static final Side receiverSide;
        public static final Handler INSTANCE;

        @Override
        @NotNull
        public KClass<CChangeLoopingState> getPacketClass() {
            return packetClass;
        }

        @Override
        @NotNull
        public Side getReceiverSide() {
            return receiverSide;
        }

        @Nullable
        public IMessage onMessage(@NotNull CChangeLoopingState message, @NotNull MessageContext ctx) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            World world = player.field_70170_p;
            Entity entity = world.func_73045_a(message.getBoatID());
            if (!(entity instanceof ModularBoatEntity)) {
                entity = null;
            }
            ModularBoatEntity modularBoatEntity = (ModularBoatEntity)entity;
            if (modularBoatEntity == null) {
                return null;
            }
            ModularBoatEntity boat = modularBoatEntity;
            HelmModule.INSTANCE.getLoopingProperty().set(boat, message.getLoopingOption());
            return null;
        }

        private Handler() {
        }

        static {
            Handler handler;
            INSTANCE = handler = new Handler();
            packetClass = Reflection.getOrCreateKotlinClass(CChangeLoopingState.class);
            receiverSide = Side.SERVER;
        }

        @Override
        public void registerSelf(@NotNull SimpleNetworkWrapper network, int packetID) {
            Intrinsics.checkParameterIsNotNull((Object)network, (String)"network");
            MBMessageHandler.DefaultImpls.registerSelf(this, network, packetID);
        }
    }
}

