/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.network;

import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.MoarBoats;
import org.jglrxavpok.moarboats.common.modules.HelmModule;
import org.jglrxavpok.moarboats.common.network.MBMessageHandler;
import org.jglrxavpok.moarboats.common.network.SMapImageAnswer;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000fB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0004\u00a8\u0006\u0010"}, d2={"Lorg/jglrxavpok/moarboats/common/network/CMapImageRequest;", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;", "name", "", "(Ljava/lang/String;)V", "()V", "mapName", "getMapName", "()Ljava/lang/String;", "setMapName", "fromBytes", "", "buf", "Lio/netty/buffer/ByteBuf;", "toBytes", "Handler", "moarboats"})
public final class CMapImageRequest
implements IMessage {
    @NotNull
    private String mapName;

    @NotNull
    public final String getMapName() {
        return this.mapName;
    }

    public final void setMapName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.mapName = string;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        String string = ByteBufUtils.readUTF8String((ByteBuf)buf);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ByteBufUtils.readUTF8String(buf)");
        this.mapName = string;
    }

    public void toBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.mapName);
    }

    public CMapImageRequest() {
        this.mapName = "";
    }

    public CMapImageRequest(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this();
        this.mapName = name;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006 "}, d2={"Lorg/jglrxavpok/moarboats/common/network/CMapImageRequest$Handler;", "Lorg/jglrxavpok/moarboats/common/network/MBMessageHandler;", "Lorg/jglrxavpok/moarboats/common/network/CMapImageRequest;", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;", "()V", "packetClass", "Lkotlin/reflect/KClass;", "getPacketClass", "()Lkotlin/reflect/KClass;", "receiverSide", "Lnet/minecraftforge/fml/relauncher/Side;", "getReceiverSide", "()Lnet/minecraftforge/fml/relauncher/Side;", "getMapColor", "", "mapColor", "Lnet/minecraft/block/material/MapColor;", "index", "onMessage", "message", "ctx", "Lnet/minecraftforge/fml/common/network/simpleimpl/MessageContext;", "reduceBrightness", "rgbColor", "depth", "takeScreenshotOfMapArea", "", "stripeIndex", "mapData", "Lnet/minecraft/world/storage/MapData;", "world", "Lnet/minecraft/world/World;", "moarboats"})
    public static final class Handler
    implements MBMessageHandler<CMapImageRequest, IMessage> {
        @NotNull
        private static final KClass<CMapImageRequest> packetClass;
        @NotNull
        private static final Side receiverSide;
        public static final Handler INSTANCE;

        @Override
        @NotNull
        public KClass<CMapImageRequest> getPacketClass() {
            return packetClass;
        }

        @Override
        @NotNull
        public Side getReceiverSide() {
            return receiverSide;
        }

        @Nullable
        public IMessage onMessage(@NotNull CMapImageRequest message, @NotNull MessageContext ctx) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            World world = player.field_70170_p;
            WorldSavedData worldSavedData = world.func_72943_a(MapData.class, message.getMapName());
            if (!(worldSavedData instanceof MapData)) {
                worldSavedData = null;
            }
            MapData mapData = (MapData)worldSavedData;
            if (mapData == null) {
                return null;
            }
            MapData mapData2 = mapData;
            int size = (1 << mapData2.field_76197_d) * 128;
            int stripes = size / HelmModule.INSTANCE.getStripeLength();
            int n = 0;
            int n2 = stripes - 1;
            if (n <= n2) {
                do {
                    int index = ++n;
                    ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(index, mapData2, world, message, player){
                        final /* synthetic */ int $index;
                        final /* synthetic */ MapData $mapData$inlined;
                        final /* synthetic */ World $world$inlined;
                        final /* synthetic */ CMapImageRequest $message$inlined;
                        final /* synthetic */ EntityPlayerMP $player$inlined;
                        {
                            this.$index = n;
                            this.$mapData$inlined = mapData;
                            this.$world$inlined = world;
                            this.$message$inlined = cMapImageRequest;
                            this.$player$inlined = entityPlayerMP;
                            super(0);
                        }

                        public final void invoke() {
                            World world = this.$world$inlined;
                            Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
                            int[] textureData = Handler.access$takeScreenshotOfMapArea(Handler.INSTANCE, this.$index, this.$mapData$inlined, world);
                            MoarBoats.INSTANCE.getNetwork().sendTo((IMessage)new SMapImageAnswer(this.$message$inlined.getMapName(), this.$index, textureData), this.$player$inlined);
                        }
                    }), (int)31, null);
                } while (n != n2);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private final int[] takeScreenshotOfMapArea(int stripeIndex, MapData mapData, World world) {
            int xCenter = mapData.field_76201_a;
            int zCenter = mapData.field_76199_b;
            int size = (1 << mapData.field_76197_d) * 128;
            int[] textureData = new int[size * HelmModule.INSTANCE.getStripeLength()];
            int minX = xCenter - size / 2;
            int minZ = zCenter - size / 2 + stripeIndex * HelmModule.INSTANCE.getStripeLength();
            int maxX = xCenter + size / 2 - 1;
            int maxZ = minZ + HelmModule.INSTANCE.getStripeLength() - 1;
            BlockPos.PooledMutableBlockPos blockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
            int n = minZ;
            int n2 = maxZ;
            if (n <= n2) {
                while (true) {
                    void z;
                    int n3;
                    int n4;
                    if ((n4 = minX) <= (n3 = maxX)) {
                        while (true) {
                            Chunk chunk;
                            int n5;
                            int mapX;
                            void x;
                            void pixelX = x - minX;
                            void pixelZ = z - minZ;
                            void chunkX = x >> 4;
                            void chunkZ = z >> 4;
                            int mapZ = (int)((double)(pixelZ + stripeIndex * HelmModule.INSTANCE.getStripeLength()) / (double)size * 128.0);
                            int i = mapZ * 128 + (mapX = (int)((double)pixelX / (double)size * 128.0));
                            int j = mapData.field_76198_e[i] & 0xFF;
                            if (j / 4 == 0) {
                                n5 = (i + i / 128 & 1) * 8 + 16 << 24;
                            } else {
                                MapColor mapColor = MapColor.field_76281_a[j / 4];
                                Intrinsics.checkExpressionValueIsNotNull((Object)mapColor, (String)"MapColor.COLORS[j / 4]");
                                n5 = this.getMapColor(mapColor, j & 3);
                            }
                            int mapColor = n5;
                            try {
                                chunk = world.func_72863_F().func_186026_b((int)chunkX, (int)chunkZ);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                chunk = null;
                            }
                            Chunk chunk2 = chunk;
                            if (j / 4 != 0) {
                                textureData[pixelZ * size + pixelX] = (int)0xFF000000L | mapColor;
                                if (chunk2 != null) {
                                    int n6 = world.func_72940_L();
                                    boolean bl = false;
                                    while (n6 >= 0) {
                                        void y;
                                        blockPos.func_181079_c((int)x, (int)y, (int)z);
                                        IBlockState blockState = chunk2.func_177435_g((BlockPos)blockPos);
                                        MapColor color = blockState.func_185909_g((IBlockAccess)world, (BlockPos)blockPos);
                                        if (Intrinsics.areEqual((Object)color, (Object)MapColor.field_151660_b) ^ true) {
                                            Material material;
                                            textureData[pixelZ * size + pixelX] = color.field_76291_p | (int)0xFF000000L;
                                            IBlockState iBlockState = blockState;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"blockState");
                                            Material material2 = iBlockState.func_185904_a();
                                            Intrinsics.checkExpressionValueIsNotNull((Object)material2, (String)"blockState.material");
                                            if (!material2.func_76224_d()) break;
                                            int depth = 0;
                                            do {
                                                IBlockState blockBelow;
                                                ++depth;
                                                BlockPos.PooledMutableBlockPos pooledMutableBlockPos = blockPos;
                                                Intrinsics.checkExpressionValueIsNotNull((Object)pooledMutableBlockPos, (String)"blockPos");
                                                int n7 = pooledMutableBlockPos.func_177956_o();
                                                pooledMutableBlockPos.func_185336_p(n7 + -1);
                                                IBlockState iBlockState2 = blockBelow = world.func_180495_p((BlockPos)blockPos);
                                                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState2, (String)"blockBelow");
                                                material = iBlockState2.func_185904_a();
                                                Intrinsics.checkExpressionValueIsNotNull((Object)material, (String)"blockBelow.material");
                                            } while (material.func_76224_d());
                                            textureData[pixelZ * size + pixelX] = this.reduceBrightness(color.field_76291_p, depth) | (int)0xFF000000L;
                                            break;
                                        }
                                        --y;
                                    }
                                }
                            }
                            if (x == n3) break;
                            ++x;
                        }
                    }
                    if (z == n2) break;
                    ++z;
                }
            }
            blockPos.func_185344_t();
            return textureData;
        }

        private final int getMapColor(MapColor mapColor, int index) {
            int i = 220;
            if (index == 3) {
                i = 135;
            }
            if (index == 2) {
                i = 255;
            }
            if (index == 1) {
                i = 220;
            }
            if (index == 0) {
                i = 180;
            }
            int j = (mapColor.field_76291_p >> 16 & 0xFF) * i / 255;
            int k = (mapColor.field_76291_p >> 8 & 0xFF) * i / 255;
            int l = (mapColor.field_76291_p & 0xFF) * i / 255;
            return 0xFF000000 | j << 16 | k << 8 | l;
        }

        private final int reduceBrightness(int rgbColor, int depth) {
            if (depth == 1) {
                return rgbColor;
            }
            int red = rgbColor >> 16 & 0xFF;
            int green = rgbColor >> 8 & 0xFF;
            int blue = rgbColor & 0xFF;
            int correctedRed = red / depth * 2;
            int correctedGreen = green / depth * 2;
            int correctedBlue = blue / depth * 2;
            return correctedRed << 16 | correctedGreen << 8 | correctedBlue;
        }

        private Handler() {
        }

        static {
            Handler handler;
            INSTANCE = handler = new Handler();
            packetClass = Reflection.getOrCreateKotlinClass(CMapImageRequest.class);
            receiverSide = Side.SERVER;
        }

        @Override
        public void registerSelf(@NotNull SimpleNetworkWrapper network, int packetID) {
            Intrinsics.checkParameterIsNotNull((Object)network, (String)"network");
            MBMessageHandler.DefaultImpls.registerSelf(this, network, packetID);
        }

        @NotNull
        public static final /* synthetic */ int[] access$takeScreenshotOfMapArea(Handler $this, int stripeIndex, @NotNull MapData mapData, @NotNull World world) {
            return $this.takeScreenshotOfMapArea(stripeIndex, mapData, world);
        }
    }
}

