/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.network;

import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.api.BoatModule;
import org.jglrxavpok.moarboats.api.BoatModuleRegistry;
import org.jglrxavpok.moarboats.api.IControllable;
import org.jglrxavpok.moarboats.common.entities.ModularBoatEntity;
import org.jglrxavpok.moarboats.common.modules.HelmModule;
import org.jglrxavpok.moarboats.common.network.MBMessageHandler;
import org.jglrxavpok.moarboats.common.network.SMapAnswer;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001cB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lorg/jglrxavpok/moarboats/common/network/CMapRequest;", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;", "name", "", "boatID", "", "moduleLocation", "Lnet/minecraft/util/ResourceLocation;", "(Ljava/lang/String;ILnet/minecraft/util/ResourceLocation;)V", "()V", "getBoatID", "()I", "setBoatID", "(I)V", "mapName", "getMapName", "()Ljava/lang/String;", "setMapName", "(Ljava/lang/String;)V", "getModuleLocation", "()Lnet/minecraft/util/ResourceLocation;", "setModuleLocation", "(Lnet/minecraft/util/ResourceLocation;)V", "fromBytes", "", "buf", "Lio/netty/buffer/ByteBuf;", "toBytes", "Handler", "moarboats"})
public final class CMapRequest
implements IMessage {
    @NotNull
    private String mapName;
    private int boatID;
    @NotNull
    private ResourceLocation moduleLocation;

    @NotNull
    public final String getMapName() {
        return this.mapName;
    }

    public final void setMapName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.mapName = string;
    }

    public final int getBoatID() {
        return this.boatID;
    }

    public final void setBoatID(int n) {
        this.boatID = n;
    }

    @NotNull
    public final ResourceLocation getModuleLocation() {
        return this.moduleLocation;
    }

    public final void setModuleLocation(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkParameterIsNotNull((Object)resourceLocation, (String)"<set-?>");
        this.moduleLocation = resourceLocation;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        String string = ByteBufUtils.readUTF8String((ByteBuf)buf);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ByteBufUtils.readUTF8String(buf)");
        this.mapName = string;
        this.boatID = buf.readInt();
        this.moduleLocation = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
    }

    public void toBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.mapName);
        buf.writeInt(this.boatID);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.moduleLocation.toString());
    }

    public CMapRequest() {
        this.mapName = "";
        this.moduleLocation = new ResourceLocation("moarboats:none");
    }

    public CMapRequest(@NotNull String name, int boatID, @NotNull ResourceLocation moduleLocation) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)moduleLocation, (String)"moduleLocation");
        this();
        this.mapName = name;
        this.boatID = boatID;
        this.moduleLocation = moduleLocation;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jglrxavpok/moarboats/common/network/CMapRequest$Handler;", "Lorg/jglrxavpok/moarboats/common/network/MBMessageHandler;", "Lorg/jglrxavpok/moarboats/common/network/CMapRequest;", "Lorg/jglrxavpok/moarboats/common/network/SMapAnswer;", "()V", "packetClass", "Lkotlin/reflect/KClass;", "getPacketClass", "()Lkotlin/reflect/KClass;", "receiverSide", "Lnet/minecraftforge/fml/relauncher/Side;", "getReceiverSide", "()Lnet/minecraftforge/fml/relauncher/Side;", "onMessage", "message", "ctx", "Lnet/minecraftforge/fml/common/network/simpleimpl/MessageContext;", "moarboats"})
    public static final class Handler
    implements MBMessageHandler<CMapRequest, SMapAnswer> {
        @NotNull
        private static final KClass<CMapRequest> packetClass;
        @NotNull
        private static final Side receiverSide;
        public static final Handler INSTANCE;

        @Override
        @NotNull
        public KClass<CMapRequest> getPacketClass() {
            return packetClass;
        }

        @Override
        @NotNull
        public Side getReceiverSide() {
            return receiverSide;
        }

        @Nullable
        public SMapAnswer onMessage(@NotNull CMapRequest message, @NotNull MessageContext ctx) {
            ItemStack stack;
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            World world = player.field_70170_p;
            Entity entity = world.func_73045_a(message.getBoatID());
            if (!(entity instanceof ModularBoatEntity)) {
                entity = null;
            }
            ModularBoatEntity modularBoatEntity = (ModularBoatEntity)entity;
            if (modularBoatEntity == null) {
                return null;
            }
            ModularBoatEntity boat = modularBoatEntity;
            ResourceLocation moduleLocation = message.getModuleLocation();
            BoatModule module = BoatModuleRegistry.INSTANCE.get(moduleLocation).getModule();
            ItemStack itemStack = stack = boat.getInventory(module).func_70301_a(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
            Item item = itemStack.func_77973_b();
            if (!(item instanceof ItemMap)) {
                item = null;
            }
            ItemMap itemMap = (ItemMap)item;
            if (itemMap == null) {
                return null;
            }
            ItemMap item2 = itemMap;
            String mapName = message.getMapName();
            MapData mapData = item2.func_77873_a(stack, boat.getWorldRef());
            if (mapData == null) {
                Intrinsics.throwNpe();
            }
            MapData mapdata = mapData;
            SMapAnswer packet = new SMapAnswer(mapName, message.getBoatID(), message.getModuleLocation());
            mapdata.func_189551_b(packet.getMapData());
            BoatModule boatModule = module;
            if (boatModule == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jglrxavpok.moarboats.common.modules.HelmModule");
            }
            HelmModule cfr_ignored_0 = (HelmModule)boatModule;
            HelmModule helmModule = (HelmModule)module;
            IControllable iControllable = boat;
            MapData mapData2 = mapdata;
            Intrinsics.checkExpressionValueIsNotNull((Object)mapData2, (String)"mapdata");
            helmModule.receiveMapData(iControllable, mapData2);
            return packet;
        }

        private Handler() {
        }

        static {
            Handler handler;
            INSTANCE = handler = new Handler();
            packetClass = Reflection.getOrCreateKotlinClass(CMapRequest.class);
            receiverSide = Side.SERVER;
        }

        @Override
        public void registerSelf(@NotNull SimpleNetworkWrapper network, int packetID) {
            Intrinsics.checkParameterIsNotNull((Object)network, (String)"network");
            MBMessageHandler.DefaultImpls.registerSelf(this, network, packetID);
        }
    }
}

