/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.network;

import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.MoarBoats;
import org.jglrxavpok.moarboats.api.BoatModule;
import org.jglrxavpok.moarboats.api.BoatModuleInventory;
import org.jglrxavpok.moarboats.api.BoatModuleRegistry;
import org.jglrxavpok.moarboats.common.containers.ContainerHelmModule;
import org.jglrxavpok.moarboats.common.data.LoopingOptions;
import org.jglrxavpok.moarboats.common.entities.ModularBoatEntity;
import org.jglrxavpok.moarboats.common.items.ItemMapWithPath;
import org.jglrxavpok.moarboats.common.modules.HelmModule;
import org.jglrxavpok.moarboats.common.network.MBMessageHandler;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\rB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jglrxavpok/moarboats/common/network/CSaveItineraryToMap;", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;", "boatID", "", "moduleID", "Lnet/minecraft/util/ResourceLocation;", "(ILnet/minecraft/util/ResourceLocation;)V", "()V", "fromBytes", "", "buf", "Lio/netty/buffer/ByteBuf;", "toBytes", "Handler", "moarboats"})
public final class CSaveItineraryToMap
implements IMessage {
    private int boatID;
    private ResourceLocation moduleID;

    public void fromBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        this.boatID = buf.readInt();
        this.moduleID = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
    }

    public void toBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        buf.writeInt(this.boatID);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.moduleID.toString());
    }

    public CSaveItineraryToMap() {
        this.moduleID = new ResourceLocation("moarboats", "none");
    }

    public CSaveItineraryToMap(int boatID, @NotNull ResourceLocation moduleID) {
        Intrinsics.checkParameterIsNotNull((Object)moduleID, (String)"moduleID");
        this();
        this.boatID = boatID;
        this.moduleID = moduleID;
    }

    public static final /* synthetic */ void access$setBoatID$p(CSaveItineraryToMap $this, int n) {
        $this.boatID = n;
    }

    public static final /* synthetic */ void access$setModuleID$p(CSaveItineraryToMap $this, @NotNull ResourceLocation resourceLocation) {
        $this.moduleID = resourceLocation;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jglrxavpok/moarboats/common/network/CSaveItineraryToMap$Handler;", "Lorg/jglrxavpok/moarboats/common/network/MBMessageHandler;", "Lorg/jglrxavpok/moarboats/common/network/CSaveItineraryToMap;", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;", "()V", "packetClass", "Lkotlin/reflect/KClass;", "getPacketClass", "()Lkotlin/reflect/KClass;", "receiverSide", "Lnet/minecraftforge/fml/relauncher/Side;", "getReceiverSide", "()Lnet/minecraftforge/fml/relauncher/Side;", "onMessage", "message", "ctx", "Lnet/minecraftforge/fml/common/network/simpleimpl/MessageContext;", "moarboats"})
    public static final class Handler
    implements MBMessageHandler<CSaveItineraryToMap, IMessage> {
        @NotNull
        private static final KClass<CSaveItineraryToMap> packetClass;
        @NotNull
        private static final Side receiverSide;
        public static final Handler INSTANCE;

        @Override
        @NotNull
        public KClass<CSaveItineraryToMap> getPacketClass() {
            return packetClass;
        }

        @Override
        @NotNull
        public Side getReceiverSide() {
            return receiverSide;
        }

        @Nullable
        public IMessage onMessage(@NotNull CSaveItineraryToMap message, @NotNull MessageContext ctx) {
            BoatModule module;
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (!(player.field_71070_bA instanceof ContainerHelmModule)) {
                MoarBoats.INSTANCE.getLogger().warn("Player " + player + " tried to save an itinerary to a map while not in a helm container, they might be lagging or cheating");
                return null;
            }
            World world = player.field_70170_p;
            Entity entity = world.func_73045_a(message.boatID);
            if (!(entity instanceof ModularBoatEntity)) {
                entity = null;
            }
            ModularBoatEntity modularBoatEntity = (ModularBoatEntity)entity;
            if (modularBoatEntity == null) {
                return null;
            }
            ModularBoatEntity boat = modularBoatEntity;
            ResourceLocation moduleLocation = message.moduleID;
            BoatModule boatModule = module = BoatModuleRegistry.INSTANCE.get(moduleLocation).getModule();
            if (boatModule == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jglrxavpok.moarboats.common.modules.HelmModule");
            }
            HelmModule cfr_ignored_0 = (HelmModule)boatModule;
            NBTTagList list = ((NBTTagList)((HelmModule)module).getWaypointsProperty().get(boat)).func_74737_b();
            BoatModuleInventory inv = boat.getInventory(module);
            ItemStack itemStack = inv.func_70301_a(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"inv.getStackInSlot(0)");
            if (Intrinsics.areEqual((Object)itemStack.func_77973_b(), (Object)Items.field_151098_aY)) {
                ItemStack itemStack2 = inv.func_70301_a(0);
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"inv.getStackInSlot(0)");
                int id = itemStack2.func_77952_i();
                NBTTagList nBTTagList = list;
                Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagList, (String)"list");
                inv.func_70299_a(0, ItemMapWithPath.INSTANCE.createStack(nBTTagList, "map_" + id, (LoopingOptions)((Object)((HelmModule)module).getLoopingProperty().get(boat))));
                player.field_71070_bA.func_75142_b();
            }
            return null;
        }

        private Handler() {
        }

        static {
            Handler handler;
            INSTANCE = handler = new Handler();
            packetClass = Reflection.getOrCreateKotlinClass(CSaveItineraryToMap.class);
            receiverSide = Side.SERVER;
        }

        @Override
        public void registerSelf(@NotNull SimpleNetworkWrapper network, int packetID) {
            Intrinsics.checkParameterIsNotNull((Object)network, (String)"network");
            MBMessageHandler.DefaultImpls.registerSelf(this, network, packetID);
        }
    }
}

