/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.network;

import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.api.BoatModule;
import org.jglrxavpok.moarboats.api.BoatModuleRegistry;
import org.jglrxavpok.moarboats.common.entities.ModularBoatEntity;
import org.jglrxavpok.moarboats.common.modules.HelmModule;
import org.jglrxavpok.moarboats.common.network.MBMessageHandler;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\"B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006#"}, d2={"Lorg/jglrxavpok/moarboats/common/network/SMapAnswer;", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;", "name", "", "boatID", "", "moduleLocation", "Lnet/minecraft/util/ResourceLocation;", "(Ljava/lang/String;ILnet/minecraft/util/ResourceLocation;)V", "()V", "getBoatID", "()I", "setBoatID", "(I)V", "mapData", "Lnet/minecraft/nbt/NBTTagCompound;", "getMapData", "()Lnet/minecraft/nbt/NBTTagCompound;", "setMapData", "(Lnet/minecraft/nbt/NBTTagCompound;)V", "mapName", "getMapName", "()Ljava/lang/String;", "setMapName", "(Ljava/lang/String;)V", "getModuleLocation", "()Lnet/minecraft/util/ResourceLocation;", "setModuleLocation", "(Lnet/minecraft/util/ResourceLocation;)V", "fromBytes", "", "buf", "Lio/netty/buffer/ByteBuf;", "toBytes", "Handler", "moarboats"})
public final class SMapAnswer
implements IMessage {
    @NotNull
    private String mapName;
    @NotNull
    private NBTTagCompound mapData;
    private int boatID;
    @NotNull
    private ResourceLocation moduleLocation;

    @NotNull
    public final String getMapName() {
        return this.mapName;
    }

    public final void setMapName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.mapName = string;
    }

    @NotNull
    public final NBTTagCompound getMapData() {
        return this.mapData;
    }

    public final void setMapData(@NotNull NBTTagCompound nBTTagCompound) {
        Intrinsics.checkParameterIsNotNull((Object)nBTTagCompound, (String)"<set-?>");
        this.mapData = nBTTagCompound;
    }

    public final int getBoatID() {
        return this.boatID;
    }

    public final void setBoatID(int n) {
        this.boatID = n;
    }

    @NotNull
    public final ResourceLocation getModuleLocation() {
        return this.moduleLocation;
    }

    public final void setModuleLocation(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkParameterIsNotNull((Object)resourceLocation, (String)"<set-?>");
        this.moduleLocation = resourceLocation;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        String string = ByteBufUtils.readUTF8String((ByteBuf)buf);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ByteBufUtils.readUTF8String(buf)");
        this.mapName = string;
        NBTTagCompound nBTTagCompound = ByteBufUtils.readTag((ByteBuf)buf);
        if (nBTTagCompound == null) {
            Intrinsics.throwNpe();
        }
        this.mapData = nBTTagCompound;
        this.boatID = buf.readInt();
        this.moduleLocation = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
    }

    public void toBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.mapName);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.mapData);
        buf.writeInt(this.boatID);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.moduleLocation.toString());
    }

    public SMapAnswer() {
        this.mapName = "";
        this.mapData = new NBTTagCompound();
        this.moduleLocation = new ResourceLocation("moarboats:none");
    }

    public SMapAnswer(@NotNull String name, int boatID, @NotNull ResourceLocation moduleLocation) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)moduleLocation, (String)"moduleLocation");
        this();
        this.mapName = name;
        this.boatID = boatID;
        this.moduleLocation = moduleLocation;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jglrxavpok/moarboats/common/network/SMapAnswer$Handler;", "Lorg/jglrxavpok/moarboats/common/network/MBMessageHandler;", "Lorg/jglrxavpok/moarboats/common/network/SMapAnswer;", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;", "()V", "packetClass", "Lkotlin/reflect/KClass;", "getPacketClass", "()Lkotlin/reflect/KClass;", "receiverSide", "Lnet/minecraftforge/fml/relauncher/Side;", "getReceiverSide", "()Lnet/minecraftforge/fml/relauncher/Side;", "onMessage", "message", "ctx", "Lnet/minecraftforge/fml/common/network/simpleimpl/MessageContext;", "moarboats"})
    public static final class Handler
    implements MBMessageHandler<SMapAnswer, IMessage> {
        @NotNull
        private static final KClass<SMapAnswer> packetClass;
        @NotNull
        private static final Side receiverSide;
        public static final Handler INSTANCE;

        @Override
        @NotNull
        public KClass<SMapAnswer> getPacketClass() {
            return packetClass;
        }

        @Override
        @NotNull
        public Side getReceiverSide() {
            return receiverSide;
        }

        @Nullable
        public IMessage onMessage(@NotNull SMapAnswer message, @NotNull MessageContext ctx) {
            BoatModule module;
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            String mapID = message.getMapName();
            MapData data = new MapData(mapID);
            data.func_76184_a(message.getMapData());
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            Entity entity = world.func_73045_a(message.getBoatID());
            if (!(entity instanceof ModularBoatEntity)) {
                entity = null;
            }
            ModularBoatEntity modularBoatEntity = (ModularBoatEntity)entity;
            if (modularBoatEntity == null) {
                return null;
            }
            ModularBoatEntity boat = modularBoatEntity;
            ResourceLocation moduleLocation = message.getModuleLocation();
            BoatModule boatModule = module = BoatModuleRegistry.INSTANCE.get(moduleLocation).getModule();
            if (boatModule == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jglrxavpok.moarboats.common.modules.HelmModule");
            }
            HelmModule cfr_ignored_0 = (HelmModule)boatModule;
            ((HelmModule)module).receiveMapData(boat, data);
            return null;
        }

        private Handler() {
        }

        static {
            Handler handler;
            INSTANCE = handler = new Handler();
            packetClass = Reflection.getOrCreateKotlinClass(SMapAnswer.class);
            receiverSide = Side.CLIENT;
        }

        @Override
        public void registerSelf(@NotNull SimpleNetworkWrapper network, int packetID) {
            Intrinsics.checkParameterIsNotNull((Object)network, (String)"network");
            MBMessageHandler.DefaultImpls.registerSelf(this, network, packetID);
        }
    }
}

