/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.network;

import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import net.minecraft.client.Minecraft;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.common.data.MapImageStripe;
import org.jglrxavpok.moarboats.common.network.MBMessageHandler;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001cB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lorg/jglrxavpok/moarboats/common/network/SMapImageAnswer;", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;", "name", "", "stripeIndex", "", "textureStripe", "", "(Ljava/lang/String;I[I)V", "()V", "mapName", "getMapName", "()Ljava/lang/String;", "setMapName", "(Ljava/lang/String;)V", "getStripeIndex", "()I", "setStripeIndex", "(I)V", "getTextureStripe", "()[I", "setTextureStripe", "([I)V", "fromBytes", "", "buf", "Lio/netty/buffer/ByteBuf;", "toBytes", "Handler", "moarboats"})
public final class SMapImageAnswer
implements IMessage {
    @NotNull
    private String mapName;
    private int stripeIndex;
    @NotNull
    private int[] textureStripe;

    @NotNull
    public final String getMapName() {
        return this.mapName;
    }

    public final void setMapName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.mapName = string;
    }

    public final int getStripeIndex() {
        return this.stripeIndex;
    }

    public final void setStripeIndex(int n) {
        this.stripeIndex = n;
    }

    @NotNull
    public final int[] getTextureStripe() {
        return this.textureStripe;
    }

    public final void setTextureStripe(@NotNull int[] nArray) {
        Intrinsics.checkParameterIsNotNull((Object)nArray, (String)"<set-?>");
        this.textureStripe = nArray;
    }

    /*
     * WARNING - void declaration
     */
    public void fromBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        String string = ByteBufUtils.readUTF8String((ByteBuf)buf);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ByteBufUtils.readUTF8String(buf)");
        this.mapName = string;
        this.stripeIndex = buf.readInt();
        int stripePixelCount = buf.readInt();
        this.textureStripe = new int[stripePixelCount];
        int n = 0;
        int n2 = this.textureStripe.length;
        while (n < n2) {
            void i;
            this.textureStripe[i] = buf.readInt();
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void toBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.mapName);
        buf.writeInt(this.stripeIndex);
        buf.writeInt(this.textureStripe.length);
        int n = 0;
        int n2 = this.textureStripe.length;
        while (n < n2) {
            void i;
            buf.writeInt(this.textureStripe[i]);
            ++i;
        }
    }

    public SMapImageAnswer() {
        this.mapName = "";
        this.textureStripe = new int[0];
    }

    public SMapImageAnswer(@NotNull String name, int stripeIndex, @NotNull int[] textureStripe) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)textureStripe, (String)"textureStripe");
        this();
        this.mapName = name;
        this.stripeIndex = stripeIndex;
        this.textureStripe = textureStripe;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jglrxavpok/moarboats/common/network/SMapImageAnswer$Handler;", "Lorg/jglrxavpok/moarboats/common/network/MBMessageHandler;", "Lorg/jglrxavpok/moarboats/common/network/SMapImageAnswer;", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;", "()V", "packetClass", "Lkotlin/reflect/KClass;", "getPacketClass", "()Lkotlin/reflect/KClass;", "receiverSide", "Lnet/minecraftforge/fml/relauncher/Side;", "getReceiverSide", "()Lnet/minecraftforge/fml/relauncher/Side;", "onMessage", "message", "ctx", "Lnet/minecraftforge/fml/common/network/simpleimpl/MessageContext;", "moarboats"})
    public static final class Handler
    implements MBMessageHandler<SMapImageAnswer, IMessage> {
        @NotNull
        private static final KClass<SMapImageAnswer> packetClass;
        @NotNull
        private static final Side receiverSide;
        public static final Handler INSTANCE;

        @Override
        @NotNull
        public KClass<SMapImageAnswer> getPacketClass() {
            return packetClass;
        }

        @Override
        @NotNull
        public Side getReceiverSide() {
            return receiverSide;
        }

        @Nullable
        public IMessage onMessage(@NotNull SMapImageAnswer message, @NotNull MessageContext ctx) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            String mapID = message.getMapName();
            String id = "moarboats:map_preview/" + mapID + '/' + message.getStripeIndex();
            MapImageStripe data = new MapImageStripe(id, message.getStripeIndex(), message.getTextureStripe());
            Minecraft.func_71410_x().field_71441_e.func_72823_a(id, (WorldSavedData)data);
            return null;
        }

        private Handler() {
        }

        static {
            Handler handler;
            INSTANCE = handler = new Handler();
            packetClass = Reflection.getOrCreateKotlinClass(SMapImageAnswer.class);
            receiverSide = Side.CLIENT;
        }

        @Override
        public void registerSelf(@NotNull SimpleNetworkWrapper network, int packetID) {
            Intrinsics.checkParameterIsNotNull((Object)network, (String)"network");
            MBMessageHandler.DefaultImpls.registerSelf(this, network, packetID);
        }
    }
}

