/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.api.BoatModule;
import org.jglrxavpok.moarboats.api.BoatModuleInventory;
import org.jglrxavpok.moarboats.api.BoatModuleRegistry;
import org.jglrxavpok.moarboats.common.entities.ModularBoatEntity;
import org.jglrxavpok.moarboats.common.network.MBMessageHandler;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001bB%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tB\u0005\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lorg/jglrxavpok/moarboats/common/network/SSyncInventory;", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;", "boatID", "", "moduleLocation", "Lnet/minecraft/util/ResourceLocation;", "inventoryContents", "", "Lnet/minecraft/item/ItemStack;", "(ILnet/minecraft/util/ResourceLocation;Ljava/util/Collection;)V", "()V", "getBoatID", "()I", "setBoatID", "(I)V", "", "getInventoryContents", "()Ljava/util/List;", "getModuleLocation", "()Lnet/minecraft/util/ResourceLocation;", "setModuleLocation", "(Lnet/minecraft/util/ResourceLocation;)V", "fromBytes", "", "buf", "Lio/netty/buffer/ByteBuf;", "toBytes", "Handler", "moarboats"})
public final class SSyncInventory
implements IMessage {
    private int boatID;
    @NotNull
    private ResourceLocation moduleLocation;
    @NotNull
    private final List<ItemStack> inventoryContents;

    public final int getBoatID() {
        return this.boatID;
    }

    public final void setBoatID(int n) {
        this.boatID = n;
    }

    @NotNull
    public final ResourceLocation getModuleLocation() {
        return this.moduleLocation;
    }

    public final void setModuleLocation(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkParameterIsNotNull((Object)resourceLocation, (String)"<set-?>");
        this.moduleLocation = resourceLocation;
    }

    @NotNull
    public final List<ItemStack> getInventoryContents() {
        return this.inventoryContents;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        this.boatID = buf.readInt();
        this.moduleLocation = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.inventoryContents.clear();
        NonNullList tmpList = NonNullList.func_191197_a((int)buf.readInt(), (Object)ItemStack.field_190927_a);
        NBTTagCompound nBTTagCompound = ByteBufUtils.readTag((ByteBuf)buf);
        if (nBTTagCompound == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.nbt.NBTTagCompound");
        }
        NBTTagCompound nbt = nBTTagCompound;
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, (NonNullList)tmpList);
        NonNullList nonNullList = tmpList;
        Intrinsics.checkExpressionValueIsNotNull((Object)nonNullList, (String)"tmpList");
        this.inventoryContents.addAll((Collection)nonNullList);
    }

    /*
     * WARNING - void declaration
     */
    public void toBytes(@NotNull ByteBuf buf) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        buf.writeInt(this.boatID);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.moduleLocation.toString());
        buf.writeInt(this.inventoryContents.size());
        NBTTagCompound nbt = new NBTTagCompound();
        Collection collection = this.inventoryContents;
        ItemStack itemStack = ItemStack.field_190927_a;
        void v0 = $receiver$iv;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        void thisCollection$iv = v0;
        ItemStack[] itemStackArray = thisCollection$iv.toArray(new ItemStack[thisCollection$iv.size()]);
        if (itemStackArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ItemStack[] itemStackArray2 = itemStackArray;
        NonNullList tmpList = NonNullList.func_193580_a((Object)itemStack, (Object[])Arrays.copyOf(itemStackArray2, itemStackArray2.length));
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, (NonNullList)tmpList);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbt);
    }

    public SSyncInventory() {
        List list;
        this.moduleLocation = new ResourceLocation("moarboats:none");
        SSyncInventory sSyncInventory = this;
        sSyncInventory.inventoryContents = list = (List)new ArrayList();
    }

    public SSyncInventory(int boatID, @NotNull ResourceLocation moduleLocation, @NotNull Collection<ItemStack> inventoryContents) {
        Intrinsics.checkParameterIsNotNull((Object)moduleLocation, (String)"moduleLocation");
        Intrinsics.checkParameterIsNotNull(inventoryContents, (String)"inventoryContents");
        this();
        this.boatID = boatID;
        this.moduleLocation = moduleLocation;
        this.inventoryContents.clear();
        this.inventoryContents.addAll(inventoryContents);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jglrxavpok/moarboats/common/network/SSyncInventory$Handler;", "Lorg/jglrxavpok/moarboats/common/network/MBMessageHandler;", "Lorg/jglrxavpok/moarboats/common/network/SSyncInventory;", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;", "()V", "packetClass", "Lkotlin/reflect/KClass;", "getPacketClass", "()Lkotlin/reflect/KClass;", "receiverSide", "Lnet/minecraftforge/fml/relauncher/Side;", "getReceiverSide", "()Lnet/minecraftforge/fml/relauncher/Side;", "onMessage", "message", "ctx", "Lnet/minecraftforge/fml/common/network/simpleimpl/MessageContext;", "moarboats"})
    public static final class Handler
    implements MBMessageHandler<SSyncInventory, IMessage> {
        @NotNull
        private static final KClass<SSyncInventory> packetClass;
        @NotNull
        private static final Side receiverSide;
        public static final Handler INSTANCE;

        @Override
        @NotNull
        public KClass<SSyncInventory> getPacketClass() {
            return packetClass;
        }

        @Override
        @NotNull
        public Side getReceiverSide() {
            return receiverSide;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public IMessage onMessage(@NotNull SSyncInventory message, @NotNull MessageContext ctx) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            Entity entity = world.func_73045_a(message.getBoatID());
            if (!(entity instanceof ModularBoatEntity)) {
                entity = null;
            }
            ModularBoatEntity modularBoatEntity = (ModularBoatEntity)entity;
            if (modularBoatEntity == null) {
                return null;
            }
            ModularBoatEntity boat = modularBoatEntity;
            ResourceLocation moduleLocation = message.getModuleLocation();
            BoatModule module = BoatModuleRegistry.INSTANCE.get(moduleLocation).getModule();
            BoatModuleInventory inventory = boat.getInventory(module);
            inventory.func_174888_l();
            int n = 0;
            int n2 = inventory.func_70302_i_();
            while (n < n2) {
                void index;
                inventory.func_70299_a((int)index, message.getInventoryContents().get((int)index));
                ++index;
            }
            return null;
        }

        private Handler() {
        }

        static {
            Handler handler;
            INSTANCE = handler = new Handler();
            packetClass = Reflection.getOrCreateKotlinClass(SSyncInventory.class);
            receiverSide = Side.CLIENT;
        }

        @Override
        public void registerSelf(@NotNull SimpleNetworkWrapper network, int packetID) {
            Intrinsics.checkParameterIsNotNull((Object)network, (String)"network");
            MBMessageHandler.DefaultImpls.registerSelf(this, network, packetID);
        }
    }
}

