/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.tileentity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.common.tileentity.TileEntityEnergy;
import org.jglrxavpok.moarboats.common.tileentity.TileEntityListenable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005J,\u0010\u0011\u001a\u00020\u00052\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000f0\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J-\u0010\u001a\u001a\u0004\u0018\u0001H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\u0005H\u0016J\u001a\u0010!\u001a\u0004\u0018\u00010\u00022\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u0014H\u0002J\u001e\u0010$\u001a\u00020\u000f2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0014H\u0016J\u0012\u0010%\u001a\u00020\u000f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0014H&J2\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000f0\u0016H\u0002J\u001e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00052\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u001e\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020\u00052\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u0010\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020.H\u0016J\u0018\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u0010\u00101\u001a\u00020.2\u0006\u0010-\u001a\u00020.H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0012\u0010\f\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007\u00a8\u00062"}, d2={"Lorg/jglrxavpok/moarboats/common/tileentity/TileEntityEnergy;", "Lorg/jglrxavpok/moarboats/common/tileentity/TileEntityListenable;", "Lnet/minecraftforge/energy/IEnergyStorage;", "()V", "energy", "", "getEnergy$moarboats", "()I", "setEnergy$moarboats", "(I)V", "maxExtractableEnergy", "getMaxExtractableEnergy", "maxReceivableEnergy", "getMaxReceivableEnergy", "consumeEnergy", "", "amount", "countNeighbors", "facings", "", "Lnet/minecraft/util/EnumFacing;", "powerFunction", "Lkotlin/Function1;", "extractEnergy", "maxExtract", "simulate", "getCapability", "T", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "facing", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "getEnergyStored", "getPowerCapability", "pos", "Lnet/minecraft/util/math/BlockPos;", "hasCapability", "isEnergyFacing", "neighborsThatCanReceivePower", "pullEnergyFromNeighbors", "", "totalEnergyToReceive", "pushEnergyToNeighbors", "totalEnergyToSend", "readFromNBT", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "receiveEnergy", "maxReceive", "writeToNBT", "moarboats"})
public abstract class TileEntityEnergy
extends TileEntityListenable
implements IEnergyStorage {
    private int energy;

    public final int getEnergy$moarboats() {
        return this.energy;
    }

    public final void setEnergy$moarboats(int n) {
        this.energy = n;
    }

    protected abstract int getMaxReceivableEnergy();

    protected abstract int getMaxExtractableEnergy();

    public void func_145839_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.func_145839_a(compound);
        this.energy = compound.func_74762_e("energy");
    }

    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        compound.func_74768_a("energy", this.energy);
        NBTTagCompound nBTTagCompound = super.func_189515_b(compound);
        Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"super.writeToNBT(compound)");
        return nBTTagCompound;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int maxExtracted = Math.min(this.energy, Math.min(maxExtract, this.getMaxExtractableEnergy()));
        int newEnergyLevel = this.energy - maxExtracted;
        int actuallyExtracted = this.energy - newEnergyLevel;
        if (!simulate) {
            this.energy -= maxExtracted;
            this.func_70296_d();
        }
        return actuallyExtracted;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int maxExtracted = Math.min(this.getMaxEnergyStored() - this.energy, Math.min(maxReceive, this.getMaxReceivableEnergy()));
        int newEnergyLevel = this.energy + maxExtracted;
        int actuallyReceived = newEnergyLevel - this.energy;
        if (!simulate) {
            this.energy += maxExtracted;
            this.func_70296_d();
        }
        return actuallyReceived;
    }

    public final void pushEnergyToNeighbors(int totalEnergyToSend, @NotNull List<? extends EnumFacing> facings) {
        Intrinsics.checkParameterIsNotNull(facings, (String)"facings");
        int neighborCount2 = this.countNeighbors(facings, (Function1<? super IEnergyStorage, Boolean>)((Function1)pushEnergyToNeighbors.neighborCount.1.INSTANCE));
        if (neighborCount2 <= 0) {
            return;
        }
        int n = this.energy;
        int energyToSend = Math.min(totalEnergyToSend, n);
        int energyToSendToASingleNeighbor = (int)Math.ceil((double)energyToSend / (double)neighborCount2);
        int energyActuallySent = 0;
        Iterable $receiver$iv = this.neighborsThatCanReceivePower(facings, (Function1<? super IEnergyStorage, Boolean>)((Function1)pushEnergyToNeighbors.1.INSTANCE));
        for (Object element$iv : $receiver$iv) {
            IEnergyStorage it = (IEnergyStorage)element$iv;
            energyActuallySent += it.receiveEnergy(energyToSendToASingleNeighbor, false);
        }
        this.energy -= energyActuallySent;
        this.func_70296_d();
    }

    public static /* bridge */ /* synthetic */ void pushEnergyToNeighbors$default(TileEntityEnergy tileEntityEnergy, int n, List list, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: pushEnergyToNeighbors");
        }
        if ((n2 & 2) != 0) {
            list = ArraysKt.toList((Object[])EnumFacing.values());
        }
        tileEntityEnergy.pushEnergyToNeighbors(n, list);
    }

    public final void pullEnergyFromNeighbors(int totalEnergyToReceive, @NotNull List<? extends EnumFacing> facings) {
        Intrinsics.checkParameterIsNotNull(facings, (String)"facings");
        int neighborCount2 = this.countNeighbors(facings, (Function1<? super IEnergyStorage, Boolean>)((Function1)pullEnergyFromNeighbors.neighborCount.1.INSTANCE));
        if (neighborCount2 <= 0) {
            return;
        }
        int n = this.getMaxEnergyStored() - this.energy;
        int energyToReceive = Math.min(totalEnergyToReceive, n);
        int energyToReceiveFromASingleNeighbor = (int)Math.ceil((double)energyToReceive / (double)neighborCount2);
        int energyActuallyReceived = 0;
        Iterable $receiver$iv = this.neighborsThatCanReceivePower(facings, (Function1<? super IEnergyStorage, Boolean>)((Function1)pullEnergyFromNeighbors.1.INSTANCE));
        for (Object element$iv : $receiver$iv) {
            IEnergyStorage it = (IEnergyStorage)element$iv;
            energyActuallyReceived += it.extractEnergy(energyToReceiveFromASingleNeighbor, false);
        }
        this.energy += energyActuallyReceived;
        this.func_70296_d();
    }

    public static /* bridge */ /* synthetic */ void pullEnergyFromNeighbors$default(TileEntityEnergy tileEntityEnergy, int n, List list, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: pullEnergyFromNeighbors");
        }
        if ((n2 & 2) != 0) {
            list = ArraysKt.toList((Object[])EnumFacing.values());
        }
        tileEntityEnergy.pullEnergyFromNeighbors(n, list);
    }

    private final List<IEnergyStorage> neighborsThatCanReceivePower(List<? extends EnumFacing> facings, Function1<? super IEnergyStorage, Boolean> powerFunction) {
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = facings;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator = $receiver$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            IEnergyStorage iEnergyStorage;
            BlockPos neighborPos;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            EnumFacing it = (EnumFacing)element$iv$iv;
            BlockPos blockPos = neighborPos = this.field_174879_c.func_177972_a(it);
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"neighborPos");
            EnumFacing enumFacing = it.func_176734_d();
            Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"it.opposite");
            if (this.getPowerCapability(blockPos, enumFacing) == null) continue;
            IEnergyStorage it$iv$iv = iEnergyStorage;
            destination$iv$iv.add(it$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!((Boolean)powerFunction.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static /* bridge */ /* synthetic */ List neighborsThatCanReceivePower$default(TileEntityEnergy tileEntityEnergy, List list, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: neighborsThatCanReceivePower");
        }
        if ((n & 1) != 0) {
            list = ArraysKt.toList((Object[])EnumFacing.values());
        }
        return tileEntityEnergy.neighborsThatCanReceivePower(list, (Function1<? super IEnergyStorage, Boolean>)function1);
    }

    private final int countNeighbors(List<? extends EnumFacing> facings, Function1<? super IEnergyStorage, Boolean> powerFunction) {
        Collection collection = this.neighborsThatCanReceivePower(facings, powerFunction);
        return collection.size();
    }

    static /* bridge */ /* synthetic */ int countNeighbors$default(TileEntityEnergy tileEntityEnergy, List list, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: countNeighbors");
        }
        if ((n & 1) != 0) {
            list = ArraysKt.toList((Object[])EnumFacing.values());
        }
        return tileEntityEnergy.countNeighbors(list, (Function1<? super IEnergyStorage, Boolean>)function1);
    }

    private final IEnergyStorage getPowerCapability(BlockPos pos, EnumFacing facing) {
        TileEntity te = this.field_145850_b.func_175625_s(pos);
        if (te != null && te.hasCapability(CapabilityEnergy.ENERGY, facing)) {
            return (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, facing);
        }
        return null;
    }

    public final boolean consumeEnergy(int amount) {
        if (amount > this.energy) {
            return false;
        }
        this.energy -= amount;
        this.func_70296_d();
        return true;
    }

    public abstract boolean isEnergyFacing(@Nullable EnumFacing var1);

    @Nullable
    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        if (Intrinsics.areEqual(capability, (Object)CapabilityEnergy.ENERGY) && this.isEnergyFacing(facing)) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        return Intrinsics.areEqual(capability, (Object)CapabilityEnergy.ENERGY) && this.isEnergyFacing(facing);
    }
}

