/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.tileentity;

import com.google.common.base.Predicate;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.common.MoarBoatsConfig;
import org.jglrxavpok.moarboats.common.blocks.BlockEnergyUnloaderKt;
import org.jglrxavpok.moarboats.common.tileentity.TileEntityEnergy;
import org.jglrxavpok.moarboats.common.tileentity.TileEntityEnergyLoader;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\b\u0010\u0013\u001a\u00020\tH\u0016J\u0012\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jglrxavpok/moarboats/common/tileentity/TileEntityEnergyLoader;", "Lorg/jglrxavpok/moarboats/common/tileentity/TileEntityEnergy;", "Lnet/minecraft/util/ITickable;", "()V", "blockFacing", "Lnet/minecraft/util/EnumFacing;", "getBlockFacing", "()Lnet/minecraft/util/EnumFacing;", "maxExtractableEnergy", "", "getMaxExtractableEnergy", "()I", "maxReceivableEnergy", "getMaxReceivableEnergy", "working", "", "canExtract", "canReceive", "getMaxEnergyStored", "getRedstonePower", "isEnergyFacing", "facing", "update", "", "moarboats"})
public final class TileEntityEnergyLoader
extends TileEntityEnergy
implements ITickable {
    private final int maxReceivableEnergy = this.getMaxEnergyStored();
    private final int maxExtractableEnergy = 0;
    private boolean working;

    @Override
    protected int getMaxReceivableEnergy() {
        return this.maxReceivableEnergy;
    }

    @Override
    protected int getMaxExtractableEnergy() {
        return this.maxExtractableEnergy;
    }

    @NotNull
    public final EnumFacing getBlockFacing() {
        Comparable comparable = this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockEnergyUnloaderKt.getFacing());
        Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"world.getBlockState(pos).getValue(Facing)");
        return (EnumFacing)comparable;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.working = false;
        this.updateListeners();
        List facings = ArraysKt.toMutableList((Object[])EnumFacing.values());
        facings.remove(this.getBlockFacing());
        this.pullEnergyFromNeighbors(MoarBoatsConfig.energyLoader.pullAmount, facings);
        BlockPos blockPos = this.field_174879_c.func_177972_a(this.getBlockFacing());
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos.offset(blockFacing)");
        AxisAlignedBB aabb = this.create3x3AxisAlignedBB(blockPos);
        List entities2 = this.field_145850_b.func_175647_a(Entity.class, aabb, (Predicate)update.entities.1.INSTANCE);
        int n = MoarBoatsConfig.energyLoader.sendAmount;
        int n2 = this.getEnergyStored();
        int totalEnergyToSend = Math.min(n, n2);
        int entityCount = entities2.size();
        if (entityCount <= 0) {
            return;
        }
        int energyToSendToASingleNeighbor = (int)Math.ceil((double)totalEnergyToSend / (double)entityCount);
        int energyActuallySent = 0;
        List list = entities2;
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"entities");
        Iterable $receiver$iv = list;
        for (Object element$iv : $receiver$iv) {
            Entity it = (Entity)element$iv;
            IEnergyStorage energyCapa = (IEnergyStorage)it.getCapability(CapabilityEnergy.ENERGY, null);
            if (energyCapa == null) continue;
            this.working = this.working || (energyActuallySent += energyCapa.receiveEnergy(energyToSendToASingleNeighbor, false)) > 0;
        }
        TileEntityEnergyLoader tileEntityEnergyLoader = this;
        tileEntityEnergyLoader.setEnergy$moarboats(tileEntityEnergyLoader.getEnergy$moarboats() - energyActuallySent);
        this.func_70296_d();
    }

    @Override
    public int getRedstonePower() {
        int n;
        if (this.working) {
            double ratio = (double)this.getEnergyStored() / (double)this.getMaxEnergyStored();
            int redstonePower = (int)(ratio * (double)15);
            int n2 = 1;
            n = Math.min(n2, redstonePower);
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    public boolean isEnergyFacing(@Nullable EnumFacing facing) {
        return Intrinsics.areEqual((Object)facing, (Object)this.getBlockFacing()) ^ true;
    }

    public boolean canExtract() {
        return false;
    }

    public int getMaxEnergyStored() {
        return MoarBoatsConfig.energyLoader.maxEnergy;
    }

    public boolean canReceive() {
        return true;
    }
}

