/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.tileentity;

import com.google.common.base.Predicate;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.common.MoarBoatsConfig;
import org.jglrxavpok.moarboats.common.blocks.BlockEnergyUnloaderKt;
import org.jglrxavpok.moarboats.common.tileentity.TileEntityFluidUnloader;
import org.jglrxavpok.moarboats.common.tileentity.TileEntityListenable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\u0012\u0010\u0011\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000fH\u0016J\u0012\u0010\u0015\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u000fH\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u000fH\u0016J\u0018\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u000fH\u0016J\u0016\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u000fJ-\u0010\u001d\u001a\u0004\u0018\u0001H\u001e\"\u0004\b\u0000\u0010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001e0 2\b\u0010!\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020\rH\u0016J\n\u0010$\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010%\u001a\u00020\rH\u0016J\u0013\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040'H\u0016\u00a2\u0006\u0002\u0010(J\u001e\u0010)\u001a\u00020\u000f2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 2\b\u0010!\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020+H\u0016J\u0010\u0010/\u001a\u00020-2\u0006\u0010,\u001a\u00020-H\u0016R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jglrxavpok/moarboats/common/tileentity/TileEntityFluidUnloader;", "Lorg/jglrxavpok/moarboats/common/tileentity/TileEntityListenable;", "Lnet/minecraft/util/ITickable;", "Lnet/minecraftforge/fluids/capability/IFluidHandler;", "Lnet/minecraftforge/fluids/capability/IFluidTankProperties;", "()V", "blockFacing", "Lnet/minecraft/util/EnumFacing;", "getBlockFacing", "()Lnet/minecraft/util/EnumFacing;", "fluid", "Lnet/minecraftforge/fluids/Fluid;", "fluidAmount", "", "working", "", "canDrain", "canDrainFluidType", "fluidStack", "Lnet/minecraftforge/fluids/FluidStack;", "canFill", "canFillFluidType", "drain", "maxDrain", "doDrain", "resource", "fill", "doFill", "forceFill", "getCapability", "T", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "facing", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "getCapacity", "getContents", "getRedstonePower", "getTankProperties", "", "()[Lnet/minecraftforge/fluids/capability/IFluidTankProperties;", "hasCapability", "readFromNBT", "", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "update", "writeToNBT", "moarboats"})
public final class TileEntityFluidUnloader
extends TileEntityListenable
implements ITickable,
IFluidHandler,
IFluidTankProperties {
    private Fluid fluid;
    private int fluidAmount;
    private boolean working;

    @NotNull
    public final EnumFacing getBlockFacing() {
        Comparable comparable = this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockEnergyUnloaderKt.getFacing());
        Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"world.getBlockState(pos).getValue(Facing)");
        return (EnumFacing)comparable;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.working = false;
        this.updateListeners();
        BlockPos blockPos = this.field_174879_c.func_177972_a(this.getBlockFacing());
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos.offset(blockFacing)");
        AxisAlignedBB aabb = this.create3x3AxisAlignedBB(blockPos);
        List entities2 = this.field_145850_b.func_175647_a(Entity.class, aabb, (Predicate)update.entities.1.INSTANCE);
        int n = MoarBoatsConfig.fluidUnloader.pullAmount;
        int n2 = this.getCapacity() - this.fluidAmount;
        int totalFluidToExtract = Math.min(n, n2);
        int entityCount = entities2.size();
        if (entityCount <= 0) {
            return;
        }
        int fluidToExtractFromASingleNeighbor = (int)Math.ceil((double)totalFluidToExtract / (double)entityCount);
        List list = entities2;
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"entities");
        Iterable $receiver$iv = list;
        for (Object element$iv : $receiver$iv) {
            int n3;
            Entity it = (Entity)element$iv;
            IFluidHandler fluidCapa = (IFluidHandler)it.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            if (fluidCapa == null) continue;
            if (this.fluid != null) {
                FluidStack fluidStack = fluidCapa.drain(new FluidStack(this.fluid, fluidToExtractFromASingleNeighbor), true);
                if (fluidStack == null) {
                    fluidStack = new FluidStack(this.fluid, 0);
                }
                n3 = this.forceFill(fluidStack, true);
            } else {
                FluidStack fluidStack = fluidCapa.drain(fluidToExtractFromASingleNeighbor, true);
                if (fluidStack == null) {
                    fluidStack = new FluidStack(FluidRegistry.WATER, 0);
                }
                n3 = this.forceFill(fluidStack, true);
            }
            int amountFilled = n3;
            this.working = this.working || amountFilled > 0;
        }
    }

    @Override
    public int getRedstonePower() {
        int n;
        if (this.working) {
            double ratio = 1.0 - (double)this.fluidAmount / (double)this.getCapacity();
            int redstonePower = (int)(ratio * (double)15);
            int n2 = 1;
            n = Math.min(n2, redstonePower);
        } else {
            n = 0;
        }
        return n;
    }

    @Nullable
    public FluidStack drain(@NotNull FluidStack resource, boolean doDrain) {
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        if (!this.canDrain()) {
            return null;
        }
        if (!this.canDrainFluidType(resource)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)resource.getFluid(), (Object)this.fluid) ^ true && resource.getFluid() != null) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (!this.canDrain()) {
            return null;
        }
        if (this.fluid == null) {
            return null;
        }
        int n = this.fluidAmount;
        int maxDrainable = Math.min(maxDrain, n);
        if (doDrain) {
            this.fluidAmount -= maxDrainable;
            this.func_70296_d();
        }
        return new FluidStack(this.fluid, maxDrainable);
    }

    public int fill(@NotNull FluidStack resource, boolean doFill) {
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        if (!this.canFill()) {
            return 0;
        }
        if (!this.canFillFluidType(resource)) {
            return 0;
        }
        return this.forceFill(resource, doFill);
    }

    public final int forceFill(@NotNull FluidStack resource, boolean doFill) {
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        if (this.fluid == null) {
            this.fluid = resource.getFluid();
        }
        if (Intrinsics.areEqual((Object)this.fluid, (Object)resource.getFluid()) ^ true && this.fluidAmount > 0) {
            return 0;
        }
        this.fluid = resource.getFluid();
        int n = resource.amount;
        int n2 = this.getCapacity() - this.fluidAmount;
        int maxFillable = Math.min(n, n2);
        if (doFill) {
            this.fluidAmount += maxFillable;
            this.func_70296_d();
        }
        return maxFillable;
    }

    @NotNull
    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this};
    }

    @Nullable
    public FluidStack getContents() {
        if (this.fluid == null || this.fluidAmount == 0) {
            return null;
        }
        return new FluidStack(this.fluid, this.fluidAmount);
    }

    public int getCapacity() {
        return MoarBoatsConfig.fluidUnloader.capacity;
    }

    public boolean canFillFluidType(@Nullable FluidStack fluidStack) {
        return false;
    }

    public boolean canFill() {
        return false;
    }

    public boolean canDrainFluidType(@Nullable FluidStack fluidStack) {
        return true;
    }

    public boolean canDrain() {
        return true;
    }

    public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        if (Intrinsics.areEqual(capability, (Object)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        if (Intrinsics.areEqual(capability, (Object)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        compound.func_74768_a("fluidAmount", this.fluidAmount);
        Object object = this.fluid;
        if (object == null || (object = object.getName()) == null) {
            object = "";
        }
        compound.func_74778_a("fluidName", (String)object);
        NBTTagCompound nBTTagCompound = super.func_189515_b(compound);
        Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"super.writeToNBT(compound)");
        return nBTTagCompound;
    }

    public void func_145839_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.func_145839_a(compound);
        this.fluid = FluidRegistry.getFluid((String)compound.func_74779_i("fluidName"));
        this.fluidAmount = compound.func_74762_e("fluidAmount");
    }
}

