/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.extensions;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.IFluidBlock;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001b\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\r2\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jglrxavpok/moarboats/extensions/Fluids;", "", "()V", "getBlockLiquidHeight", "", "blockstate", "Lnet/minecraft/block/state/IBlockState;", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "getLiquidHeight", "getLiquidLocalLevel", "", "kotlin.jvm.PlatformType", "(Lnet/minecraft/block/state/IBlockState;)Ljava/lang/Integer;", "isUsualLiquidBlock", "", "moarboats"})
public final class Fluids {
    public static final Fluids INSTANCE;

    public final float getLiquidHeight(@NotNull IBlockState blockstate, @NotNull World world, @NotNull BlockPos pos) {
        float f;
        Intrinsics.checkParameterIsNotNull((Object)blockstate, (String)"blockstate");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Block block = blockstate.func_177230_c();
        if (block instanceof BlockLiquid) {
            f = BlockLiquid.func_190972_g((IBlockState)blockstate, (IBlockAccess)((IBlockAccess)world), (BlockPos)pos);
        } else if (block instanceof BlockFluidBase) {
            f = (float)pos.func_177956_o() + this.getBlockLiquidHeight(blockstate, world, pos);
        } else {
            String string = "Unknown liquid type " + blockstate + " (" + blockstate.func_177230_c() + ") in MoarBoats";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return f;
    }

    public final Integer getLiquidLocalLevel(@NotNull IBlockState blockstate) {
        Integer n;
        Intrinsics.checkParameterIsNotNull((Object)blockstate, (String)"blockstate");
        Block block = blockstate.func_177230_c();
        if (block instanceof BlockLiquid) {
            n = (Integer)blockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b);
        } else if (block instanceof BlockFluidBase) {
            n = (Integer)blockstate.func_177229_b((IProperty)BlockFluidBase.LEVEL);
        } else {
            String string = "Unknown liquid type " + blockstate + " (" + blockstate.func_177230_c() + ") in MoarBoats";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return n;
    }

    public final float getBlockLiquidHeight(@NotNull IBlockState blockstate, @NotNull World world, @NotNull BlockPos pos) {
        float f;
        IBlockState blockUp;
        Intrinsics.checkParameterIsNotNull((Object)blockstate, (String)"blockstate");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Integer level = this.getLiquidLocalLevel(blockstate);
        IBlockState iBlockState = blockUp = world.func_180495_p(pos.func_177984_a());
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"blockUp");
        Material material = iBlockState.func_185904_a();
        Intrinsics.checkExpressionValueIsNotNull((Object)material, (String)"blockUp.material");
        if (material.func_76224_d() || blockUp.func_177230_c() instanceof IFluidBlock) {
            f = 1.0f;
        } else {
            Integer n = level;
            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"level");
            f = 1.0f - BlockLiquid.func_149801_b((int)n);
        }
        return f;
    }

    public final boolean isUsualLiquidBlock(@NotNull IBlockState blockstate) {
        Intrinsics.checkParameterIsNotNull((Object)blockstate, (String)"blockstate");
        return blockstate.func_177230_c() instanceof BlockFluidBase || blockstate.func_177230_c() instanceof BlockLiquid;
    }

    private Fluids() {
    }

    static {
        Fluids fluids;
        INSTANCE = fluids = new Fluids();
    }
}

