/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.integration.journeymap;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import journeymap.client.io.FileHandler;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.moarboats.MoarBoats;
import org.jglrxavpok.moarboats.api.BoatModuleEntry;
import org.jglrxavpok.moarboats.client.renders.BoatModuleRenderer;
import org.jglrxavpok.moarboats.common.network.MBMessageHandler;
import org.jglrxavpok.moarboats.integration.IWaypointProvider;
import org.jglrxavpok.moarboats.integration.IWaypointProviderKt;
import org.jglrxavpok.moarboats.integration.MoarBoatsIntegration;
import org.jglrxavpok.moarboats.integration.MoarBoatsPlugin;
import org.jglrxavpok.moarboats.integration.WaypointInfo;

@MoarBoatsIntegration(dependency="journeymap")
@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jglrxavpok/moarboats/integration/journeymap/JourneyMapPlugin;", "Lorg/jglrxavpok/moarboats/integration/MoarBoatsPlugin;", "Lorg/jglrxavpok/moarboats/integration/IWaypointProvider;", "()V", "gson", "Lcom/google/gson/Gson;", "name", "Lnet/minecraft/util/text/TextComponentTranslation;", "getName", "()Lnet/minecraft/util/text/TextComponentTranslation;", "waypointList", "", "Lorg/jglrxavpok/moarboats/integration/WaypointInfo;", "getList", "", "preInit", "", "updateList", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "moarboats"})
public final class JourneyMapPlugin
implements MoarBoatsPlugin,
IWaypointProvider {
    private final List<WaypointInfo> waypointList;
    @NotNull
    private final TextComponentTranslation name;
    private final Gson gson;

    @NotNull
    public TextComponentTranslation getName() {
        return this.name;
    }

    @Override
    public void preInit() {
        Collection collection = IWaypointProviderKt.getWaypointProviders();
        JourneyMapPlugin journeyMapPlugin = this;
        collection.add(journeyMapPlugin);
    }

    @Override
    @NotNull
    public List<WaypointInfo> getList() {
        return this.waypointList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void updateList(@NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        this.waypointList.clear();
        File folder = FileHandler.getWaypointDir();
        Logger logger = MoarBoats.INSTANCE.getLogger();
        StringBuilder stringBuilder = new StringBuilder().append("[journeymap Plugin] Reading waypoints from ");
        File file = folder;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"folder");
        logger.debug(stringBuilder.append(file.getAbsolutePath()).append(" - folder really exists: ").append(folder.exists()).toString());
        File[] fileArray = folder.listFiles();
        if (fileArray != null) {
            Object[] $receiver$iv = fileArray;
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Object object;
                File file2;
                Object element$iv = $receiver$iv[i];
                File file3 = file2 = (File)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"file");
                Object object2 = file3;
                Object object3 = Charsets.UTF_8;
                int n = 8192;
                Object object4 = object = object2;
                object4 = new FileInputStream((File)object4);
                object = new InputStreamReader((InputStream)object4, (Charset)object3);
                object2 = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
                object3 = null;
                try {
                    BufferedReader it = (BufferedReader)object2;
                    JsonObject waypointObject = (JsonObject)this.gson.fromJson((Reader)it, JsonObject.class);
                    JsonElement jsonElement = waypointObject.get("enable");
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"waypointObject.get(\"enable\")");
                    boolean enabled = jsonElement.getAsBoolean();
                    if (enabled) {
                        void $receiver$iv$iv;
                        Iterable $receiver$iv2;
                        JsonElement jsonElement2 = waypointObject.get("name");
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"waypointObject.get(\"name\")");
                        String name = jsonElement2.getAsString();
                        JsonElement jsonElement3 = waypointObject.get("x");
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement3, (String)"waypointObject.get(\"x\")");
                        int x = jsonElement3.getAsInt();
                        JsonElement jsonElement4 = waypointObject.get("z");
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement4, (String)"waypointObject.get(\"z\")");
                        int z = jsonElement4.getAsInt();
                        JsonArray jsonArray = waypointObject.getAsJsonArray("dimensions");
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"waypointObject.getAsJsonArray(\"dimensions\")");
                        Iterable iterable = $receiver$iv2 = (Iterable)jsonArray;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                        for (Object item$iv$iv : $receiver$iv$iv) {
                            void p1;
                            JsonElement jsonElement5 = (JsonElement)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            Integer n2 = p1.getAsInt();
                            collection.add(n2);
                        }
                        List dimensions = (List)destination$iv$iv;
                        String string = name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                        WaypointInfo waypoint = new WaypointInfo(string, x, z, null);
                        if (dimensions.contains(player.field_71093_bK)) {
                            this.waypointList.add(waypoint);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                    continue;
                }
                catch (Throwable throwable) {
                    object3 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
                }
            }
        }
    }

    public JourneyMapPlugin() {
        List list;
        JourneyMapPlugin journeyMapPlugin = this;
        journeyMapPlugin.waypointList = list = (List)new ArrayList();
        this.name = new TextComponentTranslation("waypoint_provider.journeymap", new Object[0]);
        this.gson = new Gson();
    }

    @Override
    public void init() {
        MoarBoatsPlugin.DefaultImpls.init(this);
    }

    @Override
    public void postInit() {
        MoarBoatsPlugin.DefaultImpls.postInit(this);
    }

    @Override
    public void registerModules(@NotNull IForgeRegistry<BoatModuleEntry> registry) {
        Intrinsics.checkParameterIsNotNull(registry, (String)"registry");
        MoarBoatsPlugin.DefaultImpls.registerModules(this, registry);
    }

    @Override
    @NotNull
    public List<MBMessageHandler<? extends IMessage, ? extends IMessage>> handlers() {
        return MoarBoatsPlugin.DefaultImpls.handlers(this);
    }

    @Override
    public void registerAsEventSubscriber() {
        MoarBoatsPlugin.DefaultImpls.registerAsEventSubscriber(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModuleRenderers(@NotNull IForgeRegistry<BoatModuleRenderer> registry) {
        Intrinsics.checkParameterIsNotNull(registry, (String)"registry");
        MoarBoatsPlugin.DefaultImpls.registerModuleRenderers(this, registry);
    }
}

