/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.entities;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.api.BoatModule;
import org.jglrxavpok.moarboats.api.BoatModuleInventory;
import org.jglrxavpok.moarboats.common.EntityEntries;
import org.jglrxavpok.moarboats.common.entities.BasicBoatEntity;
import org.jglrxavpok.moarboats.common.items.AnimalBoatItem;
import org.jglrxavpok.moarboats.common.state.BoatProperty;
import org.jglrxavpok.moarboats.extensions.Fluids;
import org.jglrxavpok.moarboats.extensions.MathExtensionsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J\b\u0010 \u001a\u00020\u0018H\u0016J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0014J \u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\u001d\u0010+\u001a\u00020\u0018\"\u0004\b\u0000\u0010,2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H,0.H\u0096\u0002J\b\u0010/\u001a\u000200H\u0016J,\u00101\u001a\u00020(2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020(2\b\u00105\u001a\u0004\u0018\u0001062\b\u00107\u001a\u0004\u0018\u000108H\u0016J\u0010\u00109\u001a\u0002002\u0006\u0010:\u001a\u00020\u0018H\u0016J\b\u0010;\u001a\u000206H\u0016J\b\u0010<\u001a\u00020=H\u0016J\u0019\u0010>\u001a\u0002H,\"\n\b\u0000\u0010,*\u0004\u0018\u00010?H\u0016\u00a2\u0006\u0002\u0010@J\b\u0010A\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\u0014H\u0016J\b\u0010F\u001a\u00020\u0005H\u0016J\n\u0010G\u001a\u0004\u0018\u00010HH\u0016J\n\u0010I\u001a\u0004\u0018\u00010JH\u0016J\u0018\u0010K\u001a\u00020L2\u0006\u0010E\u001a\u00020\u00142\u0006\u0010M\u001a\u00020\u0018H\u0016J\b\u0010N\u001a\u00020\u0005H\u0016J\b\u0010O\u001a\u00020\u0005H\u0016J\b\u0010P\u001a\u00020\u0005H\u0016J\u0010\u0010Q\u001a\u0002002\u0006\u0010R\u001a\u00020\u001cH\u0016J\b\u0010S\u001a\u00020\u0018H\u0016J\u0010\u0010T\u001a\u00020\u00182\u0006\u0010U\u001a\u000206H\u0016J\u0010\u0010V\u001a\u0002082\u0006\u00107\u001a\u000208H\u0016J\u0018\u0010W\u001a\u0002002\u0006\u0010E\u001a\u00020\u00142\u0006\u0010M\u001a\u00020\u0018H\u0016J\b\u0010X\u001a\u000200H\u0016J\u0010\u0010Y\u001a\u0002002\u0006\u0010\"\u001a\u00020#H\u0016R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006Z"}, d2={"Lorg/jglrxavpok/moarboats/common/entities/AnimalBoatEntity;", "Lorg/jglrxavpok/moarboats/common/entities/BasicBoatEntity;", "world", "Lnet/minecraft/world/World;", "x", "", "y", "z", "(Lnet/minecraft/world/World;DDD)V", "(Lnet/minecraft/world/World;)V", "entityID", "", "getEntityID", "()I", "moduleRNG", "Ljava/util/Random;", "getModuleRNG", "()Ljava/util/Random;", "modules", "", "Lorg/jglrxavpok/moarboats/api/BoatModule;", "getModules", "()Ljava/util/List;", "attackEntityFrom", "", "source", "Lnet/minecraft/util/DamageSource;", "amount", "", "calculateAnchorPosition", "Lnet/minecraft/util/math/Vec3d;", "linkType", "canBePushed", "canFitPassenger", "passenger", "Lnet/minecraft/entity/Entity;", "canStartRiding", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "heldItem", "Lnet/minecraft/item/ItemStack;", "hand", "Lnet/minecraft/util/EnumHand;", "contains", "T", "property", "Lorg/jglrxavpok/moarboats/common/state/BoatProperty;", "controlBoat", "", "dispense", "behavior", "Lnet/minecraft/dispenser/IBehaviorDispenseItem;", "stack", "overridePosition", "Lnet/minecraft/util/math/BlockPos;", "overrideFacing", "Lnet/minecraft/util/EnumFacing;", "dropItemsOnDeath", "killedByPlayerInCreative", "getBlockPos", "getBlockState", "Lnet/minecraft/block/state/IBlockState;", "getBlockTileEntity", "Lnet/minecraft/tileentity/TileEntity;", "()Lnet/minecraft/tileentity/TileEntity;", "getBoatItem", "Lorg/jglrxavpok/moarboats/common/items/AnimalBoatItem;", "getInventory", "Lorg/jglrxavpok/moarboats/api/BoatModuleInventory;", "module", "getMountedYOffset", "getOwnerIdOrNull", "Ljava/util/UUID;", "getOwnerNameOrNull", "", "getState", "Lnet/minecraft/nbt/NBTTagCompound;", "isLocal", "getX", "getY", "getZ", "imposeSpeed", "speed", "isSpeedImposed", "isValidLiquidBlock", "pos", "reorientate", "saveState", "tick", "updatePassenger", "moarboats"})
public final class AnimalBoatEntity
extends BasicBoatEntity {
    @NotNull
    private final List<BoatModule> modules;
    @NotNull
    private final Random moduleRNG;

    @Override
    public int getEntityID() {
        return this.func_145782_y();
    }

    @Override
    @NotNull
    public List<BoatModule> getModules() {
        return this.modules;
    }

    @Override
    @NotNull
    public Random getModuleRNG() {
        return this.moduleRNG;
    }

    @Override
    @NotNull
    public AnimalBoatItem getBoatItem() {
        return AnimalBoatItem.INSTANCE;
    }

    @Override
    @Nullable
    public UUID getOwnerIdOrNull() {
        return null;
    }

    @Override
    @Nullable
    public String getOwnerNameOrNull() {
        return null;
    }

    @Override
    public double func_70042_X() {
        return 0.0;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b((double)0.2f, (double)0.01f, (double)0.2f), EntitySelectors.func_200823_a((Entity)this));
        for (Entity entity : list) {
            if (entity.func_184196_w((Entity)this) || !this.func_184188_bt().isEmpty()) continue;
            Entity entity2 = entity;
            Intrinsics.checkExpressionValueIsNotNull((Object)entity2, (String)"entity");
            if (entity2.func_184187_bx() != null || !(entity.field_70130_N < this.field_70130_N) || !(entity instanceof EntityLivingBase) || entity instanceof EntityWaterMob || entity instanceof EntityPlayer) continue;
            entity.func_184220_m((Entity)this);
        }
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    @Override
    public void controlBoat() {
    }

    @Override
    @NotNull
    public Vec3d calculateAnchorPosition(int linkType) {
        float distanceFromCenter = 1.0625f * (linkType == BasicBoatEntity.Companion.getFrontLink() ? 1.0f : -1.0f) * 1.5f;
        double anchorX = this.getPositionX() + (double)(MathHelper.func_76134_b((float)MathExtensionsKt.toRadians(this.getYaw() + 90.0f)) * distanceFromCenter);
        double anchorY = this.getPositionY() + (double)1.0f;
        double anchorZ = this.getPositionZ() + (double)(MathHelper.func_76126_a((float)MathExtensionsKt.toRadians(this.getYaw() + 90.0f)) * distanceFromCenter);
        return new Vec3d(anchorX, anchorY, anchorZ);
    }

    @Override
    public void dropItemsOnDeath(boolean killedByPlayerInCreative) {
        if (!killedByPlayerInCreative) {
            this.func_199702_a((IItemProvider)AnimalBoatItem.INSTANCE, 1);
        }
    }

    @Override
    public boolean isValidLiquidBlock(@NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        World world = this.field_70170_p;
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
        return Fluids.INSTANCE.isUsualLiquidBlock(world, pos);
    }

    @Override
    public boolean func_70097_a(@NotNull DamageSource source, float amount) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        DamageSource damageSource = source;
        return Intrinsics.areEqual((Object)damageSource, (Object)DamageSource.field_76371_c) || Intrinsics.areEqual((Object)damageSource, (Object)DamageSource.field_76372_a) || Intrinsics.areEqual((Object)damageSource, (Object)DamageSource.field_76370_b) ? false : (damageSource instanceof EntityDamageSourceIndirect ? false : super.func_70097_a(source, amount));
    }

    @Override
    public boolean canStartRiding(@NotNull EntityPlayer player, @NotNull ItemStack heldItem, @NotNull EnumHand hand) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)heldItem, (String)"heldItem");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        return false;
    }

    @Override
    public void saveState(@NotNull BoatModule module, boolean isLocal) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
    }

    @Override
    @NotNull
    public NBTTagCompound getState(@NotNull BoatModule module, boolean isLocal) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return new NBTTagCompound();
    }

    @Override
    @NotNull
    public BoatModuleInventory getInventory(@NotNull BoatModule module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        String string = "Animal boats cannot have inventories!";
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @Override
    @NotNull
    public ItemStack dispense(@NotNull IBehaviorDispenseItem behavior, @NotNull ItemStack stack, @Nullable BlockPos overridePosition, @Nullable EnumFacing overrideFacing) {
        Intrinsics.checkParameterIsNotNull((Object)behavior, (String)"behavior");
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        ItemStack itemStack = ItemStack.field_190927_a;
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
        return itemStack;
    }

    @Override
    @NotNull
    public EnumFacing reorientate(@NotNull EnumFacing overrideFacing) {
        Intrinsics.checkParameterIsNotNull((Object)overrideFacing, (String)"overrideFacing");
        return overrideFacing;
    }

    public <T extends TileEntity> T func_150835_j() {
        return (T)((TileEntity)new TileEntityDispenser());
    }

    public double func_82615_a() {
        return this.field_70165_t;
    }

    public double func_82617_b() {
        return this.field_70163_u;
    }

    public double func_82616_c() {
        return this.field_70161_v;
    }

    @NotNull
    public IBlockState func_189992_e() {
        IBlockState iBlockState = this.field_70170_p.func_180495_p(this.func_180425_c());
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(position)");
        return iBlockState;
    }

    @NotNull
    public BlockPos func_180699_d() {
        BlockPos blockPos = this.func_180425_c();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"position");
        return blockPos;
    }

    @Override
    public void func_184232_k(@NotNull Entity passenger) {
        Intrinsics.checkParameterIsNotNull((Object)passenger, (String)"passenger");
        if (this.func_184196_w(passenger)) {
            float f1 = (float)((!this.func_70089_S() ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
            passenger.func_70107_b(this.field_70165_t, this.field_70163_u + (double)f1, this.field_70161_v);
            passenger.field_70177_z += this.getDeltaRotation();
            passenger.func_70034_d(passenger.func_70079_am() + this.getDeltaRotation());
            this.applyYawToEntity(passenger);
        }
    }

    @Override
    protected boolean func_184219_q(@NotNull Entity passenger) {
        Intrinsics.checkParameterIsNotNull((Object)passenger, (String)"passenger");
        return this.func_184188_bt().isEmpty() && !(passenger instanceof EntityPlayer);
    }

    @Override
    public boolean isSpeedImposed() {
        return false;
    }

    @Override
    public void imposeSpeed(float speed) {
    }

    @Override
    public <T> boolean contains(@NotNull BoatProperty<T> property) {
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        return false;
    }

    public AnimalBoatEntity(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        super(EntityEntries.INSTANCE.getAnimalBoat(), world);
        this.modules = CollectionsKt.emptyList();
        this.moduleRNG = new Random();
        this.field_70156_m = true;
        this.func_70105_a(2.0625f, 0.5625f);
    }

    public AnimalBoatEntity(@NotNull World world, double x, double y, double z) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        this(world);
        this.func_70107_b(x, y, z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }
}

