/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.items;

import com.mojang.authlib.GameProfile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.moarboats.common.entities.BasicBoatEntity;
import org.jglrxavpok.moarboats.common.entities.ModularBoatEntity;
import org.jglrxavpok.moarboats.common.items.BaseBoatItem;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/jglrxavpok/moarboats/common/items/ModularBoatItem;", "Lorg/jglrxavpok/moarboats/common/items/BaseBoatItem;", "dyeColor", "Lnet/minecraft/item/EnumDyeColor;", "(Lnet/minecraft/item/EnumDyeColor;)V", "getDyeColor", "()Lnet/minecraft/item/EnumDyeColor;", "createBoat", "Lorg/jglrxavpok/moarboats/common/entities/BasicBoatEntity;", "worldIn", "Lnet/minecraft/world/World;", "raytraceresult", "Lnet/minecraft/util/math/RayTraceResult;", "inUsualFluid", "", "itemstack", "Lnet/minecraft/item/ItemStack;", "playerIn", "Lnet/minecraft/entity/player/EntityPlayer;", "Companion", "moarboats"})
public final class ModularBoatItem
extends BaseBoatItem {
    @NotNull
    private final EnumDyeColor dyeColor;
    @NotNull
    private static final ModularBoatItem White;
    @NotNull
    private static final ModularBoatItem Orange;
    @NotNull
    private static final ModularBoatItem Magenta;
    @NotNull
    private static final ModularBoatItem LightBlue;
    @NotNull
    private static final ModularBoatItem Yellow;
    @NotNull
    private static final ModularBoatItem Lime;
    @NotNull
    private static final ModularBoatItem Pink;
    @NotNull
    private static final ModularBoatItem Gray;
    @NotNull
    private static final ModularBoatItem LightGray;
    @NotNull
    private static final ModularBoatItem Cyan;
    @NotNull
    private static final ModularBoatItem Purple;
    @NotNull
    private static final ModularBoatItem Blue;
    @NotNull
    private static final ModularBoatItem Brown;
    @NotNull
    private static final ModularBoatItem Green;
    @NotNull
    private static final ModularBoatItem Red;
    @NotNull
    private static final ModularBoatItem Black;
    @NotNull
    private static final ModularBoatItem[] AllVersions;
    public static final Companion Companion;

    @Override
    @NotNull
    public BasicBoatEntity createBoat(@NotNull World worldIn, @NotNull RayTraceResult raytraceresult, boolean inUsualFluid, @NotNull ItemStack itemstack, @NotNull EntityPlayer playerIn) {
        ModularBoatEntity modularBoatEntity;
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)raytraceresult, (String)"raytraceresult");
        Intrinsics.checkParameterIsNotNull((Object)itemstack, (String)"itemstack");
        Intrinsics.checkParameterIsNotNull((Object)playerIn, (String)"playerIn");
        EnumDyeColor color = this.dyeColor;
        double d = raytraceresult.field_72307_f.field_72450_a;
        double d2 = inUsualFluid ? raytraceresult.field_72307_f.field_72448_b - 0.12 : raytraceresult.field_72307_f.field_72448_b;
        double d3 = raytraceresult.field_72307_f.field_72449_c;
        GameProfile gameProfile = playerIn.func_146103_bH();
        Intrinsics.checkExpressionValueIsNotNull((Object)gameProfile, (String)"playerIn.gameProfile");
        ModularBoatEntity $receiver = modularBoatEntity = new ModularBoatEntity(worldIn, d, d2, d3, color, ModularBoatEntity.OwningMode.PlayerOwned, gameProfile.getId());
        boolean bl = false;
        NBTTagCompound nBTTagCompound = itemstack.func_190925_c("boat_data");
        Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"itemstack.getOrCreateChildTag(\"boat_data\")");
        $receiver.func_70037_a(nBTTagCompound);
        return modularBoatEntity;
    }

    @NotNull
    public final EnumDyeColor getDyeColor() {
        return this.dyeColor;
    }

    public ModularBoatItem(@NotNull EnumDyeColor dyeColor) {
        Intrinsics.checkParameterIsNotNull((Object)dyeColor, (String)"dyeColor");
        this.dyeColor = dyeColor;
        this.setRegistryName(new ResourceLocation("moarboats", "modular_boat_" + this.dyeColor.func_176762_d()));
    }

    static {
        Companion = new Companion(null);
        White = new ModularBoatItem(EnumDyeColor.WHITE);
        Orange = new ModularBoatItem(EnumDyeColor.ORANGE);
        Magenta = new ModularBoatItem(EnumDyeColor.MAGENTA);
        LightBlue = new ModularBoatItem(EnumDyeColor.LIGHT_BLUE);
        Yellow = new ModularBoatItem(EnumDyeColor.YELLOW);
        Lime = new ModularBoatItem(EnumDyeColor.LIME);
        Pink = new ModularBoatItem(EnumDyeColor.PINK);
        Gray = new ModularBoatItem(EnumDyeColor.GRAY);
        LightGray = new ModularBoatItem(EnumDyeColor.LIGHT_GRAY);
        Cyan = new ModularBoatItem(EnumDyeColor.CYAN);
        Purple = new ModularBoatItem(EnumDyeColor.PURPLE);
        Blue = new ModularBoatItem(EnumDyeColor.BLUE);
        Brown = new ModularBoatItem(EnumDyeColor.BROWN);
        Green = new ModularBoatItem(EnumDyeColor.GREEN);
        Red = new ModularBoatItem(EnumDyeColor.RED);
        Black = new ModularBoatItem(EnumDyeColor.BLACK);
        AllVersions = new ModularBoatItem[]{White, Orange, Magenta, LightBlue, Yellow, Lime, Pink, Gray, LightGray, Cyan, Purple, Blue, Brown, Green, Red, Black};
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b&\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020,H\u0086\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000bR\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000bR\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000bR\u0011\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000bR\u0011\u0010\u001c\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000bR\u0011\u0010\u001e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000bR\u0011\u0010 \u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000bR\u0011\u0010\"\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u000bR\u0011\u0010$\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u000bR\u0011\u0010&\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u000bR\u0011\u0010(\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u000b\u00a8\u0006-"}, d2={"Lorg/jglrxavpok/moarboats/common/items/ModularBoatItem$Companion;", "", "()V", "AllVersions", "", "Lorg/jglrxavpok/moarboats/common/items/ModularBoatItem;", "getAllVersions", "()[Lorg/jglrxavpok/moarboats/common/items/ModularBoatItem;", "[Lorg/jglrxavpok/moarboats/common/items/ModularBoatItem;", "Black", "getBlack", "()Lorg/jglrxavpok/moarboats/common/items/ModularBoatItem;", "Blue", "getBlue", "Brown", "getBrown", "Cyan", "getCyan", "Gray", "getGray", "Green", "getGreen", "LightBlue", "getLightBlue", "LightGray", "getLightGray", "Lime", "getLime", "Magenta", "getMagenta", "Orange", "getOrange", "Pink", "getPink", "Purple", "getPurple", "Red", "getRed", "White", "getWhite", "Yellow", "getYellow", "get", "color", "Lnet/minecraft/item/EnumDyeColor;", "moarboats"})
    public static final class Companion {
        @NotNull
        public final ModularBoatItem getWhite() {
            return White;
        }

        @NotNull
        public final ModularBoatItem getOrange() {
            return Orange;
        }

        @NotNull
        public final ModularBoatItem getMagenta() {
            return Magenta;
        }

        @NotNull
        public final ModularBoatItem getLightBlue() {
            return LightBlue;
        }

        @NotNull
        public final ModularBoatItem getYellow() {
            return Yellow;
        }

        @NotNull
        public final ModularBoatItem getLime() {
            return Lime;
        }

        @NotNull
        public final ModularBoatItem getPink() {
            return Pink;
        }

        @NotNull
        public final ModularBoatItem getGray() {
            return Gray;
        }

        @NotNull
        public final ModularBoatItem getLightGray() {
            return LightGray;
        }

        @NotNull
        public final ModularBoatItem getCyan() {
            return Cyan;
        }

        @NotNull
        public final ModularBoatItem getPurple() {
            return Purple;
        }

        @NotNull
        public final ModularBoatItem getBlue() {
            return Blue;
        }

        @NotNull
        public final ModularBoatItem getBrown() {
            return Brown;
        }

        @NotNull
        public final ModularBoatItem getGreen() {
            return Green;
        }

        @NotNull
        public final ModularBoatItem getRed() {
            return Red;
        }

        @NotNull
        public final ModularBoatItem getBlack() {
            return Black;
        }

        @NotNull
        public final ModularBoatItem[] getAllVersions() {
            return AllVersions;
        }

        @NotNull
        public final ModularBoatItem get(@NotNull EnumDyeColor color) {
            Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
            return this.getAllVersions()[color.ordinal()];
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

