/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.modules;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.moarboats.api.BoatModule;
import org.jglrxavpok.moarboats.api.IControllable;
import org.jglrxavpok.moarboats.client.gui.GuiBatteryModule;
import org.jglrxavpok.moarboats.common.MoarBoatsConfig;
import org.jglrxavpok.moarboats.common.blocks.BlockBoatBattery;
import org.jglrxavpok.moarboats.common.containers.EmptyContainer;
import org.jglrxavpok.moarboats.common.modules.IEnergyBoatModule;
import org.jglrxavpok.moarboats.common.state.BoatPropertyKt;
import org.jglrxavpok.moarboats.common.state.IntBoatProperty;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0016H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010!\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u0011H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u0016H\u0016J(\u0010'\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0011H\u0016J\u0010\u0010+\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0016H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006,"}, d2={"Lorg/jglrxavpok/moarboats/common/modules/BatteryModule;", "Lorg/jglrxavpok/moarboats/api/BoatModule;", "Lorg/jglrxavpok/moarboats/common/modules/IEnergyBoatModule;", "()V", "energyProperty", "Lorg/jglrxavpok/moarboats/common/state/IntBoatProperty;", "getEnergyProperty", "()Lorg/jglrxavpok/moarboats/common/state/IntBoatProperty;", "id", "Lnet/minecraft/util/ResourceLocation;", "getId", "()Lnet/minecraft/util/ResourceLocation;", "moduleSpot", "Lorg/jglrxavpok/moarboats/api/BoatModule$Spot;", "getModuleSpot", "()Lorg/jglrxavpok/moarboats/api/BoatModule$Spot;", "usesInventory", "", "getUsesInventory", "()Z", "canGiveEnergy", "boat", "Lorg/jglrxavpok/moarboats/api/IControllable;", "canReceiveEnergy", "controlBoat", "", "from", "createContainer", "Lorg/jglrxavpok/moarboats/common/containers/EmptyContainer;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "createGui", "Lorg/jglrxavpok/moarboats/client/gui/GuiBatteryModule;", "dropItemsOnDeath", "killedByPlayerInCreative", "getMaxStorableEnergy", "", "onAddition", "to", "onInteract", "hand", "Lnet/minecraft/util/EnumHand;", "sneaking", "update", "moarboats"})
public final class BatteryModule
extends BoatModule
implements IEnergyBoatModule {
    @NotNull
    private static final IntBoatProperty energyProperty;
    @NotNull
    private static final ResourceLocation id;
    private static final boolean usesInventory = false;
    @NotNull
    private static final BoatModule.Spot moduleSpot;
    public static final BatteryModule INSTANCE;

    @Override
    @NotNull
    public IntBoatProperty getEnergyProperty() {
        return energyProperty;
    }

    @Override
    public boolean canReceiveEnergy(@NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        return true;
    }

    @Override
    public boolean canGiveEnergy(@NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        return true;
    }

    @Override
    public int getMaxStorableEnergy(@NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        Object object = MoarBoatsConfig.boatBattery.getMaxEnergy().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"MoarBoatsConfig.boatBattery.maxEnergy.get()");
        return ((Number)object).intValue();
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return id;
    }

    @Override
    public boolean getUsesInventory() {
        return usesInventory;
    }

    @Override
    @NotNull
    public BoatModule.Spot getModuleSpot() {
        return moduleSpot;
    }

    @Override
    public boolean onInteract(@NotNull IControllable from, @NotNull EntityPlayer player, @NotNull EnumHand hand, boolean sneaking) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        return false;
    }

    @Override
    public void controlBoat(@NotNull IControllable from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
    }

    @Override
    public void update(@NotNull IControllable from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
    }

    @Override
    public void onAddition(@NotNull IControllable to) {
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        this.getEnergyProperty().set(to, 0);
    }

    @Override
    @NotNull
    public EmptyContainer createContainer(@NotNull EntityPlayer player, @NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        InventoryPlayer inventoryPlayer = player.field_71071_by;
        Intrinsics.checkExpressionValueIsNotNull((Object)inventoryPlayer, (String)"player.inventory");
        return new EmptyContainer(inventoryPlayer, false, 0, 6, null);
    }

    @NotNull
    public GuiBatteryModule createGui(@NotNull EntityPlayer player, @NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        InventoryPlayer inventoryPlayer = player.field_71071_by;
        Intrinsics.checkExpressionValueIsNotNull((Object)inventoryPlayer, (String)"player.inventory");
        return new GuiBatteryModule(inventoryPlayer, this, boat);
    }

    @Override
    public void dropItemsOnDeath(@NotNull IControllable boat, boolean killedByPlayerInCreative) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        if (!killedByPlayerInCreative) {
            boat.getCorrespondingEntity().func_199702_a((IItemProvider)ItemBlock.func_150898_a((Block)BlockBoatBattery.INSTANCE), 1);
        }
    }

    private BatteryModule() {
    }

    static {
        BatteryModule batteryModule;
        INSTANCE = batteryModule = new BatteryModule();
        energyProperty = BoatPropertyKt.IntBoatProperty(batteryModule, "energy");
        id = new ResourceLocation("moarboats", "battery");
        moduleSpot = BoatModule.Spot.Storage;
    }

    @Override
    public int extractEnergy(@NotNull IControllable boat, int amount, boolean simulate) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        return IEnergyBoatModule.DefaultImpls.extractEnergy(this, boat, amount, simulate);
    }

    @Override
    public int getCurrentEnergy(@NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        return IEnergyBoatModule.DefaultImpls.getCurrentEnergy(this, boat);
    }

    @Override
    public int receiveEnergy(@NotNull IControllable boat, int amount, boolean simulate) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        return IEnergyBoatModule.DefaultImpls.receiveEnergy(this, boat, amount, simulate);
    }
}

