/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.modules;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.Particles;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.moarboats.api.BoatModule;
import org.jglrxavpok.moarboats.api.BoatModuleInventory;
import org.jglrxavpok.moarboats.api.IControllable;
import org.jglrxavpok.moarboats.common.containers.ContainerBase;
import org.jglrxavpok.moarboats.common.containers.ContainerFurnaceEngine;
import org.jglrxavpok.moarboats.common.modules.BaseEngineModule;
import org.jglrxavpok.moarboats.common.state.BoatPropertyKt;
import org.jglrxavpok.moarboats.common.state.IntBoatProperty;
import org.jglrxavpok.moarboats.extensions.MathExtensionsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u000eH\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u0016H\u0016J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u0016H\u0016J(\u0010$\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000eH\u0016J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u0016H\u0016J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u0016H\u0016J\u0010\u0010*\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010+\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00060"}, d2={"Lorg/jglrxavpok/moarboats/common/modules/FurnaceEngineModule;", "Lorg/jglrxavpok/moarboats/common/modules/BaseEngineModule;", "()V", "fuelTimeProperty", "Lorg/jglrxavpok/moarboats/common/state/IntBoatProperty;", "getFuelTimeProperty", "()Lorg/jglrxavpok/moarboats/common/state/IntBoatProperty;", "fuelTotalTimeProperty", "getFuelTotalTimeProperty", "id", "Lnet/minecraft/util/ResourceLocation;", "getId", "()Lnet/minecraft/util/ResourceLocation;", "usesInventory", "", "getUsesInventory", "()Z", "createContainer", "Lorg/jglrxavpok/moarboats/common/containers/ContainerBase;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "boat", "Lorg/jglrxavpok/moarboats/api/IControllable;", "dropItemsOnDeath", "", "killedByPlayerInCreative", "estimatedTotalTicks", "", "getFuelTime", "", "fuelItem", "Lnet/minecraft/item/ItemStack;", "hasFuel", "from", "onAddition", "to", "onInteract", "hand", "Lnet/minecraft/util/EnumHand;", "sneaking", "remainingTimeInPercent", "remainingTimeInTicks", "tryToFindFuel", "updateFuelState", "state", "Lnet/minecraft/nbt/NBTTagCompound;", "inv", "Lnet/minecraft/inventory/IInventory;", "moarboats"})
public final class FurnaceEngineModule
extends BaseEngineModule {
    @NotNull
    private static final ResourceLocation id;
    private static final boolean usesInventory = true;
    @NotNull
    private static final IntBoatProperty fuelTotalTimeProperty;
    @NotNull
    private static final IntBoatProperty fuelTimeProperty;
    public static final FurnaceEngineModule INSTANCE;

    @Override
    @NotNull
    public ContainerBase createContainer(@NotNull EntityPlayer player, @NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        InventoryPlayer inventoryPlayer = player.field_71071_by;
        Intrinsics.checkExpressionValueIsNotNull((Object)inventoryPlayer, (String)"player.inventory");
        return new ContainerFurnaceEngine(inventoryPlayer, this, boat);
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return id;
    }

    @Override
    public boolean getUsesInventory() {
        return usesInventory;
    }

    @NotNull
    public final IntBoatProperty getFuelTotalTimeProperty() {
        return fuelTotalTimeProperty;
    }

    @NotNull
    public final IntBoatProperty getFuelTimeProperty() {
        return fuelTimeProperty;
    }

    @Override
    public float remainingTimeInTicks(@NotNull IControllable from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        return ((Number)fuelTotalTimeProperty.get(from)).intValue() - ((Number)fuelTimeProperty.get(from)).intValue();
    }

    @Override
    public float remainingTimeInPercent(@NotNull IControllable from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        int currentFuel = ((Number)fuelTimeProperty.get(from)).intValue();
        int totalFuel = ((Number)fuelTotalTimeProperty.get(from)).intValue();
        return totalFuel == 0 ? 0.0f : 1.0f - (float)currentFuel / (float)totalFuel;
    }

    @Override
    public float estimatedTotalTicks(@NotNull IControllable boat) {
        ItemStack currentStack;
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        BoatModuleInventory inv = this.getInventory(boat);
        float diff = this.remainingTimeInTicks(boat);
        ItemStack itemStack = currentStack = inv.func_70301_a(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"currentStack");
        return diff + (float)(itemStack.func_190916_E() * this.getFuelTime(currentStack));
    }

    @Override
    public void onAddition(@NotNull IControllable to) {
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        super.onAddition(to);
        fuelTimeProperty.set(to, 0);
        fuelTotalTimeProperty.set(to, 0);
    }

    @Override
    public boolean onInteract(@NotNull IControllable from, @NotNull EntityPlayer player, @NotNull EnumHand hand, boolean sneaking) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        return false;
    }

    @Override
    public boolean hasFuel(@NotNull IControllable from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        int fuelTime = ((Number)fuelTimeProperty.get(from)).intValue();
        int fuelTotalTime = ((Number)fuelTotalTimeProperty.get(from)).intValue();
        return fuelTime < fuelTotalTime;
    }

    @Override
    protected void updateFuelState(@NotNull IControllable boat, @NotNull NBTTagCompound state, @NotNull IInventory inv) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)inv, (String)"inv");
        int fuelTime = ((Number)fuelTimeProperty.get(boat)).intValue();
        int fuelTotalTime = ((Number)fuelTotalTimeProperty.get(boat)).intValue();
        if (fuelTime < fuelTotalTime) {
            IntBoatProperty intBoatProperty = fuelTimeProperty;
            IControllable iControllable = boat;
            int n = ((Number)intBoatProperty.get(iControllable)).intValue();
            intBoatProperty.set(iControllable, n + 1);
        } else {
            ItemStack stack;
            ItemStack itemStack = stack = inv.func_70301_a(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
            if (itemStack.func_190926_b()) {
                this.tryToFindFuel(boat);
                stack = inv.func_70301_a(0);
            }
            ItemStack itemStack2 = stack;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"stack");
            Item fuelItem = itemStack2.func_77973_b();
            int itemFuelTime = this.getFuelTime(stack);
            if (itemFuelTime > 0 && !this.isStationary(boat)) {
                if (Intrinsics.areEqual((Object)fuelItem, (Object)Items.field_151129_at)) {
                    inv.func_70299_a(0, new ItemStack((IItemProvider)Items.field_151133_ar));
                } else {
                    inv.func_70298_a(0, 1);
                }
                fuelTimeProperty.set(boat, 0);
                fuelTotalTimeProperty.set(boat, itemFuelTime);
            }
        }
        if (this.hasFuel(boat) && this.getRng().nextInt(4) == 0) {
            float cos = MathHelper.func_76134_b((float)MathExtensionsKt.toRadians(boat.getYaw() + 90.0f));
            float sin = MathHelper.func_76126_a((float)MathExtensionsKt.toRadians(boat.getYaw() + 90.0f));
            double dist = 0.5;
            boat.getWorldRef().func_195594_a((IParticleData)Particles.field_197594_E, boat.getPositionX() + dist * (double)cos, boat.getPositionY() + 0.8, boat.getPositionZ() + dist * (double)sin, 0.0, 0.0, 0.0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void tryToFindFuel(IControllable boat) {
        Object v0;
        block4: {
            Iterable iterable;
            Iterable iterable2 = iterable = (Iterable)boat.getModules();
            for (Object t : iterable2) {
                BoatModule it = (BoatModule)t;
                boolean bl = false;
                if (!(it.getModuleSpot() == BoatModule.Spot.Storage && it.getUsesInventory())) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        BoatModule storageModule = v0;
        if (storageModule != null) {
            BoatModuleInventory inventory = this.getInventory(boat);
            BoatModuleInventory storageInventory = boat.getInventory(storageModule);
            int n = 0;
            int n2 = storageInventory.func_70302_i_();
            while (n < n2) {
                void index;
                ItemStack stack;
                ItemStack itemStack = stack = storageInventory.func_70301_a((int)index);
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
                if (this.isItemFuel(itemStack)) {
                    storageInventory.func_70299_a((int)index, ItemStack.field_190927_a);
                    inventory.func_70299_a(0, stack);
                    break;
                }
                ++index;
            }
            inventory.syncToClient();
            storageInventory.syncToClient();
        }
    }

    @Override
    public int getFuelTime(@NotNull ItemStack fuelItem) {
        Intrinsics.checkParameterIsNotNull((Object)fuelItem, (String)"fuelItem");
        Item item = fuelItem.func_77973_b();
        return Intrinsics.areEqual((Object)item, (Object)Blocks.field_150478_aa.func_199767_j()) ? 1 * BaseEngineModule.Companion.getSECONDS_TO_TICKS() : (Intrinsics.areEqual((Object)item, (Object)Items.field_151044_h) ? 180 * BaseEngineModule.Companion.getSECONDS_TO_TICKS() : (Intrinsics.areEqual((Object)item, (Object)Items.field_151129_at) ? 900 * BaseEngineModule.Companion.getSECONDS_TO_TICKS() : (Intrinsics.areEqual((Object)item, (Object)Blocks.field_196814_hQ.func_199767_j()) ? 1800 * BaseEngineModule.Companion.getSECONDS_TO_TICKS() : (Intrinsics.areEqual((Object)item, (Object)Blocks.field_150402_ci.func_199767_j()) ? 900 * BaseEngineModule.Companion.getSECONDS_TO_TICKS() : (int)((double)TileEntityFurnace.func_145952_a((ItemStack)fuelItem) * 0.9)))));
    }

    @Override
    public void dropItemsOnDeath(@NotNull IControllable boat, boolean killedByPlayerInCreative) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        if (!killedByPlayerInCreative) {
            boat.getCorrespondingEntity().func_199702_a((IItemProvider)ItemBlock.func_150898_a((Block)Blocks.field_150460_al), 1);
        }
    }

    private FurnaceEngineModule() {
    }

    static {
        FurnaceEngineModule furnaceEngineModule;
        INSTANCE = furnaceEngineModule = new FurnaceEngineModule();
        id = new ResourceLocation("moarboats:furnace_engine");
        usesInventory = true;
        fuelTotalTimeProperty = BoatPropertyKt.IntBoatProperty(furnaceEngineModule, "fuelTotalTime");
        fuelTimeProperty = BoatPropertyKt.IntBoatProperty(furnaceEngineModule, "fuelTime");
    }
}

