/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.modules;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.api.BoatModule;
import org.jglrxavpok.moarboats.api.IControllable;
import org.jglrxavpok.moarboats.client.gui.GuiNoConfigModule;
import org.jglrxavpok.moarboats.common.containers.ContainerBase;
import org.jglrxavpok.moarboats.common.containers.EmptyContainer;
import org.jglrxavpok.moarboats.common.math.MutableVec2;
import org.jglrxavpok.moarboats.common.modules.SurroundingsMatrix;
import org.jglrxavpok.moarboats.extensions.MathExtensionsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0017H\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0017H\u0016J\u0018\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\bH\u0016J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u0017H\u0016J(\u0010#\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\bH\u0016J\u0010\u0010'\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\t\u00a8\u0006("}, d2={"Lorg/jglrxavpok/moarboats/common/modules/SonarModule;", "Lorg/jglrxavpok/moarboats/api/BoatModule;", "()V", "id", "Lnet/minecraft/util/ResourceLocation;", "getId", "()Lnet/minecraft/util/ResourceLocation;", "isMenuInteresting", "", "()Z", "moduleSpot", "Lorg/jglrxavpok/moarboats/api/BoatModule$Spot;", "getModuleSpot", "()Lorg/jglrxavpok/moarboats/api/BoatModule$Spot;", "usesInventory", "getUsesInventory", "averageGradient", "Lorg/jglrxavpok/moarboats/common/math/MutableVec2;", "matrix", "Lorg/jglrxavpok/moarboats/common/modules/SurroundingsMatrix;", "controlBoat", "", "from", "Lorg/jglrxavpok/moarboats/api/IControllable;", "createContainer", "Lorg/jglrxavpok/moarboats/common/containers/ContainerBase;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "boat", "createGui", "Lorg/jglrxavpok/moarboats/client/gui/GuiNoConfigModule;", "dropItemsOnDeath", "killedByPlayerInCreative", "onAddition", "to", "onInteract", "hand", "Lnet/minecraft/util/EnumHand;", "sneaking", "update", "moarboats"})
public final class SonarModule
extends BoatModule {
    @NotNull
    private static final ResourceLocation id;
    private static final boolean usesInventory = false;
    @NotNull
    private static final BoatModule.Spot moduleSpot;
    private static final boolean isMenuInteresting = false;
    public static final SonarModule INSTANCE;

    @Override
    @NotNull
    public ResourceLocation getId() {
        return id;
    }

    @Override
    public boolean getUsesInventory() {
        return usesInventory;
    }

    @Override
    @NotNull
    public BoatModule.Spot getModuleSpot() {
        return moduleSpot;
    }

    @Override
    public boolean isMenuInteresting() {
        return isMenuInteresting;
    }

    @Override
    public boolean onInteract(@NotNull IControllable from, @NotNull EntityPlayer player, @NotNull EnumHand hand, boolean sneaking) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        return false;
    }

    @Override
    public void controlBoat(@NotNull IControllable from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        SurroundingsMatrix testMatrix = new SurroundingsMatrix(32);
        testMatrix.compute(from.getWorldRef(), from.getPositionX(), from.getPositionY(), from.getPositionZ()).removeNotConnectedToCenter();
        MutableVec2 localGradient = this.averageGradient(testMatrix);
        if ((int)localGradient.getX() == 0 && (int)localGradient.getY() == 0) {
            return;
        }
        float yawRad = MathExtensionsKt.toRadians(from.getYaw());
        double speed = Math.sqrt(from.getVelocityX() * from.getVelocityX() + from.getVelocityZ() * from.getVelocityZ());
        if (speed > 0.01) {
            Vec3d force = new Vec3d(-localGradient.getX(), 0.0, -localGradient.getY());
            double cos = MathHelper.func_76134_b((float)yawRad);
            double sin = MathHelper.func_76126_a((float)yawRad);
            Vec3d r = new Vec3d(cos, 0.0, sin);
            Vec3d moment = r.func_72431_c(force);
            double angularRotation = moment.field_72448_b / speed;
            float rotationMultiplier = MathExtensionsKt.toDegrees((float)angularRotation) / 500.0f;
            from.turnLeft(rotationMultiplier);
        }
    }

    private final MutableVec2 averageGradient(SurroundingsMatrix matrix) {
        MutableVec2[] gradient = matrix.computeGradient();
        MutableVec2 v = new MutableVec2(gradient[matrix.pos2index(0, 0)]);
        Function2<Integer, Integer, Unit> add$ = new Function2<Integer, Integer, Unit>(matrix, gradient, v){
            final /* synthetic */ SurroundingsMatrix $matrix;
            final /* synthetic */ MutableVec2[] $gradient;
            final /* synthetic */ MutableVec2 $v;

            public final void invoke(int x, int z) {
                int index = this.$matrix.pos2index(x, z);
                double gx = this.$gradient[index].getX();
                double gz = this.$gradient[index].getY();
                this.$v.translate(gx, gz);
            }
            {
                this.$matrix = surroundingsMatrix;
                this.$gradient = mutableVec2Array;
                this.$v = mutableVec2;
                super(2);
            }
        };
        add$.invoke(-1, -1);
        add$.invoke(0, -1);
        add$.invoke(1, -1);
        add$.invoke(-1, 0);
        add$.invoke(1, 0);
        add$.invoke(-1, 1);
        add$.invoke(0, 1);
        add$.invoke(1, 1);
        v.scale(0.1111111111111111);
        return v;
    }

    @Override
    public void update(@NotNull IControllable from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
    }

    @Override
    public void onAddition(@NotNull IControllable to) {
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
    }

    @Override
    @Nullable
    public ContainerBase createContainer(@NotNull EntityPlayer player, @NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        InventoryPlayer inventoryPlayer = player.field_71071_by;
        Intrinsics.checkExpressionValueIsNotNull((Object)inventoryPlayer, (String)"player.inventory");
        return new EmptyContainer(inventoryPlayer, false, 0, 6, null);
    }

    @NotNull
    public GuiNoConfigModule createGui(@NotNull EntityPlayer player, @NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        InventoryPlayer inventoryPlayer = player.field_71071_by;
        Intrinsics.checkExpressionValueIsNotNull((Object)inventoryPlayer, (String)"player.inventory");
        return new GuiNoConfigModule(inventoryPlayer, this, boat);
    }

    @Override
    public void dropItemsOnDeath(@NotNull IControllable boat, boolean killedByPlayerInCreative) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        if (!killedByPlayerInCreative) {
            boat.getCorrespondingEntity().func_199702_a((IItemProvider)Blocks.field_196586_al.func_199767_j(), 1);
        }
    }

    private SonarModule() {
    }

    static {
        SonarModule sonarModule;
        INSTANCE = sonarModule = new SonarModule();
        id = new ResourceLocation("moarboats", "sonar");
        moduleSpot = BoatModule.Spot.Navigation;
    }
}

