/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.network;

import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.MoarBoats;
import org.jglrxavpok.moarboats.common.modules.HelmModule;
import org.jglrxavpok.moarboats.common.network.CMapImageRequest;
import org.jglrxavpok.moarboats.common.network.CMapImageRequest$Handler$onMessage$;
import org.jglrxavpok.moarboats.common.network.CMapImageRequest$sam$java_util_function_Function$0;
import org.jglrxavpok.moarboats.common.network.MBMessageHandler;
import org.jglrxavpok.moarboats.common.network.MoarBoatsPacket;
import org.jglrxavpok.moarboats.common.network.SMapImageAnswer;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001\nB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0004\u00a8\u0006\u000b"}, d2={"Lorg/jglrxavpok/moarboats/common/network/CMapImageRequest;", "Lorg/jglrxavpok/moarboats/common/network/MoarBoatsPacket;", "name", "", "(Ljava/lang/String;)V", "()V", "mapName", "getMapName", "()Ljava/lang/String;", "setMapName", "Handler", "moarboats"})
public final class CMapImageRequest
implements MoarBoatsPacket {
    @NotNull
    private String mapName;

    @NotNull
    public final String getMapName() {
        return this.mapName;
    }

    public final void setMapName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.mapName = string;
    }

    public CMapImageRequest() {
        this.mapName = "";
    }

    public CMapImageRequest(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this();
        this.mapName = name;
    }

    @Override
    public void encode(@NotNull PacketBuffer to) {
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        MoarBoatsPacket.DefaultImpls.encode(this, to);
    }

    @Override
    @NotNull
    public MoarBoatsPacket decode(@NotNull PacketBuffer from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        return MoarBoatsPacket.DefaultImpls.decode(this, from);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006 "}, d2={"Lorg/jglrxavpok/moarboats/common/network/CMapImageRequest$Handler;", "Lorg/jglrxavpok/moarboats/common/network/MBMessageHandler;", "Lorg/jglrxavpok/moarboats/common/network/CMapImageRequest;", "Lorg/jglrxavpok/moarboats/common/network/MoarBoatsPacket;", "()V", "packetClass", "Ljava/lang/Class;", "getPacketClass", "()Ljava/lang/Class;", "receiverSide", "Lnet/minecraftforge/api/distmarker/Dist;", "getReceiverSide", "()Lnet/minecraftforge/api/distmarker/Dist;", "getMapColor", "", "mapColor", "Lnet/minecraft/block/material/MaterialColor;", "index", "onMessage", "message", "ctx", "Lnet/minecraftforge/fml/network/NetworkEvent$Context;", "reduceBrightness", "rgbColor", "depth", "takeScreenshotOfMapArea", "", "stripeIndex", "mapData", "Lnet/minecraft/world/storage/MapData;", "world", "Lnet/minecraft/world/World;", "moarboats"})
    public static final class Handler
    implements MBMessageHandler<CMapImageRequest, MoarBoatsPacket> {
        @NotNull
        private static final Class<CMapImageRequest> packetClass;
        @NotNull
        private static final Dist receiverSide;
        public static final Handler INSTANCE;

        @Override
        @NotNull
        public Class<CMapImageRequest> getPacketClass() {
            return packetClass;
        }

        @Override
        @NotNull
        public Dist getReceiverSide() {
            return receiverSide;
        }

        @Override
        @Nullable
        public MoarBoatsPacket onMessage(@NotNull CMapImageRequest message, @NotNull NetworkEvent.Context ctx) {
            WorldSavedData worldSavedData;
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            EntityPlayerMP entityPlayerMP = ctx.getSender();
            if (entityPlayerMP == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayerMP, (String)"ctx.sender!!");
            EntityPlayerMP player = entityPlayerMP;
            World world = player.field_70170_p;
            Object object = onMessage.mapData.1.INSTANCE;
            if (object != null) {
                Function1 function1 = object;
                object = new CMapImageRequest$sam$java_util_function_Function$0(function1);
            }
            if (!((worldSavedData = world.func_212411_a(DimensionType.OVERWORLD, (Function)object, message.getMapName())) instanceof MapData)) {
                worldSavedData = null;
            }
            MapData mapData2 = (MapData)worldSavedData;
            if (mapData2 == null) {
                return null;
            }
            MapData mapData3 = mapData2;
            int size = (1 << mapData3.field_76197_d) * 128;
            int stripes = size / HelmModule.INSTANCE.getStripeLength();
            int n = 0;
            int n2 = stripes;
            while (n < n2) {
                int index = n++;
                boolean bl = false;
                ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(index, mapData3, world, player, message){
                    final /* synthetic */ int $index;
                    final /* synthetic */ MapData $mapData$inlined;
                    final /* synthetic */ World $world$inlined;
                    final /* synthetic */ EntityPlayerMP $player$inlined;
                    final /* synthetic */ CMapImageRequest $message$inlined;
                    {
                        this.$index = n;
                        this.$mapData$inlined = mapData2;
                        this.$world$inlined = world;
                        this.$player$inlined = entityPlayerMP;
                        this.$message$inlined = cMapImageRequest;
                        super(0);
                    }

                    public final void invoke() {
                        World world = this.$world$inlined;
                        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
                        int[] textureData = Handler.access$takeScreenshotOfMapArea(Handler.INSTANCE, this.$index, this.$mapData$inlined, world);
                        MoarBoats.INSTANCE.getNetwork().send(PacketDistributor.PLAYER.with((Supplier)new Supplier<EntityPlayerMP>(this){
                            final /* synthetic */ Handler$onMessage$$inlined$repeat$lambda$1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            @NotNull
                            public final EntityPlayerMP get() {
                                return this.this$0.$player$inlined;
                            }
                        }), (Object)new SMapImageAnswer(this.$message$inlined.getMapName(), this.$index, textureData));
                    }
                }), (int)31, null);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private final int[] takeScreenshotOfMapArea(int stripeIndex, MapData mapData2, World world) {
            int xCenter = mapData2.field_76201_a;
            int zCenter = mapData2.field_76199_b;
            int size = (1 << mapData2.field_76197_d) * 128;
            int[] textureData = new int[size * HelmModule.INSTANCE.getStripeLength()];
            int minX = xCenter - size / 2;
            int minZ = zCenter - size / 2 + stripeIndex * HelmModule.INSTANCE.getStripeLength();
            int maxX = xCenter + size / 2 - 1;
            int maxZ = minZ + HelmModule.INSTANCE.getStripeLength() - 1;
            BlockPos.PooledMutableBlockPos blockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
            int n = minZ;
            int n2 = maxZ;
            if (n <= n2) {
                while (true) {
                    void z;
                    int n3;
                    int n4;
                    if ((n4 = minX) <= (n3 = maxX)) {
                        while (true) {
                            Chunk chunk;
                            int n5;
                            int mapX;
                            void x;
                            void pixelX = x - minX;
                            void pixelZ = z - minZ;
                            void chunkX = x >> 4;
                            void chunkZ = z >> 4;
                            int mapZ = (int)((double)(pixelZ + stripeIndex * HelmModule.INSTANCE.getStripeLength()) / (double)size * 128.0);
                            int i2 = mapZ * 128 + (mapX = (int)((double)pixelX / (double)size * 128.0));
                            int j = mapData2.field_76198_e[i2] & 0xFF;
                            if (j / 4 == 0) {
                                n5 = (i2 + i2 / 128 & 1) * 8 + 16 << 24;
                            } else {
                                MaterialColor materialColor = MaterialColor.field_76281_a[j / 4];
                                Intrinsics.checkExpressionValueIsNotNull((Object)materialColor, (String)"MaterialColor.COLORS[j / 4]");
                                n5 = this.getMapColor(materialColor, j & 3);
                            }
                            int mapColor = n5;
                            try {
                                chunk = world.func_72863_F().func_186025_d((int)chunkX, (int)chunkZ, false, false);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                chunk = null;
                            }
                            Chunk chunk2 = chunk;
                            if (j / 4 != 0) {
                                textureData[pixelZ * size + pixelX] = (int)0xFF000000L | mapColor;
                                if (chunk2 != null) {
                                    int n6 = world.func_72940_L();
                                    boolean bl = false;
                                    while (n6 >= 0) {
                                        void y;
                                        blockPos.func_181079_c((int)x, (int)y, (int)z);
                                        IBlockState blockState = chunk2.func_180495_p((BlockPos)blockPos);
                                        MaterialColor color = blockState.func_185909_g((IBlockReader)world, (BlockPos)blockPos);
                                        if (Intrinsics.areEqual((Object)color, (Object)MaterialColor.field_151660_b) ^ true) {
                                            Material material;
                                            textureData[pixelZ * size + pixelX] = color.field_76291_p | (int)0xFF000000L;
                                            IBlockState iBlockState = blockState;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"blockState");
                                            Material material2 = iBlockState.func_185904_a();
                                            Intrinsics.checkExpressionValueIsNotNull((Object)material2, (String)"blockState.material");
                                            if (!material2.func_76224_d()) break;
                                            int depth = 0;
                                            do {
                                                IBlockState blockBelow;
                                                ++depth;
                                                BlockPos.PooledMutableBlockPos pooledMutableBlockPos = blockPos;
                                                Intrinsics.checkExpressionValueIsNotNull((Object)pooledMutableBlockPos, (String)"blockPos");
                                                int n7 = pooledMutableBlockPos.func_177956_o();
                                                pooledMutableBlockPos.func_185336_p(n7 + -1);
                                                IBlockState iBlockState2 = blockBelow = world.func_180495_p((BlockPos)blockPos);
                                                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState2, (String)"blockBelow");
                                                material = iBlockState2.func_185904_a();
                                                Intrinsics.checkExpressionValueIsNotNull((Object)material, (String)"blockBelow.material");
                                            } while (material.func_76224_d());
                                            textureData[pixelZ * size + pixelX] = this.reduceBrightness(color.field_76291_p, depth) | (int)0xFF000000L;
                                            break;
                                        }
                                        --y;
                                    }
                                }
                            }
                            if (x == n3) break;
                            ++x;
                        }
                    }
                    if (z == n2) break;
                    ++z;
                }
            }
            blockPos.close();
            return textureData;
        }

        private final int getMapColor(MaterialColor mapColor, int index) {
            int i2 = 220;
            if (index == 3) {
                i2 = 135;
            }
            if (index == 2) {
                i2 = 255;
            }
            if (index == 1) {
                i2 = 220;
            }
            if (index == 0) {
                i2 = 180;
            }
            int j = (mapColor.field_76291_p >> 16 & 0xFF) * i2 / 255;
            int k = (mapColor.field_76291_p >> 8 & 0xFF) * i2 / 255;
            int l = (mapColor.field_76291_p & 0xFF) * i2 / 255;
            return 0xFF000000 | j << 16 | k << 8 | l;
        }

        private final int reduceBrightness(int rgbColor, int depth) {
            if (depth == 1) {
                return rgbColor;
            }
            int red = rgbColor >> 16 & 0xFF;
            int green = rgbColor >> 8 & 0xFF;
            int blue = rgbColor & 0xFF;
            int correctedRed = red / depth * 2;
            int correctedGreen = green / depth * 2;
            int correctedBlue = blue / depth * 2;
            return correctedRed << 16 | correctedGreen << 8 | correctedBlue;
        }

        private Handler() {
        }

        static {
            Handler handler;
            INSTANCE = handler = new Handler();
            packetClass = CMapImageRequest.class;
            receiverSide = Dist.DEDICATED_SERVER;
        }

        @Override
        public void handle(@NotNull CMapImageRequest packet, @NotNull NetworkEvent.Context ctx) {
            Intrinsics.checkParameterIsNotNull((Object)packet, (String)"packet");
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            MBMessageHandler.DefaultImpls.handle(this, (MoarBoatsPacket)packet, ctx);
        }

        @Override
        public void registerSelf(@NotNull SimpleChannel network2, int packetID) {
            Intrinsics.checkParameterIsNotNull((Object)network2, (String)"network");
            MBMessageHandler.DefaultImpls.registerSelf(this, network2, packetID);
        }

        public static final /* synthetic */ int[] access$takeScreenshotOfMapArea(Handler $this, int stripeIndex, MapData mapData2, World world) {
            return $this.takeScreenshotOfMapArea(stripeIndex, mapData2, world);
        }
    }
}

