/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.network;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.common.entities.ModularBoatEntity;
import org.jglrxavpok.moarboats.common.network.MBMessageHandler;
import org.jglrxavpok.moarboats.common.network.MoarBoatsPacket;
import org.jglrxavpok.moarboats.common.network.SMapAnswer;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\u0001\u0010B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0005\u00a2\u0006\u0002\u0010\u0007R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/jglrxavpok/moarboats/common/network/CRemoveModule;", "Lorg/jglrxavpok/moarboats/common/network/MoarBoatsPacket;", "boatID", "", "moduleLocation", "Lnet/minecraft/util/ResourceLocation;", "(ILnet/minecraft/util/ResourceLocation;)V", "()V", "getBoatID", "()I", "setBoatID", "(I)V", "getModuleLocation", "()Lnet/minecraft/util/ResourceLocation;", "setModuleLocation", "(Lnet/minecraft/util/ResourceLocation;)V", "Handler", "moarboats"})
public final class CRemoveModule
implements MoarBoatsPacket {
    private int boatID;
    @NotNull
    private ResourceLocation moduleLocation;

    public final int getBoatID() {
        return this.boatID;
    }

    public final void setBoatID(int n) {
        this.boatID = n;
    }

    @NotNull
    public final ResourceLocation getModuleLocation() {
        return this.moduleLocation;
    }

    public final void setModuleLocation(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkParameterIsNotNull((Object)resourceLocation, (String)"<set-?>");
        this.moduleLocation = resourceLocation;
    }

    public CRemoveModule() {
        this.moduleLocation = new ResourceLocation("moarboats:none");
    }

    public CRemoveModule(int boatID, @NotNull ResourceLocation moduleLocation) {
        Intrinsics.checkParameterIsNotNull((Object)moduleLocation, (String)"moduleLocation");
        this();
        this.boatID = boatID;
        this.moduleLocation = moduleLocation;
    }

    @Override
    public void encode(@NotNull PacketBuffer to) {
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        MoarBoatsPacket.DefaultImpls.encode(this, to);
    }

    @Override
    @NotNull
    public MoarBoatsPacket decode(@NotNull PacketBuffer from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        return MoarBoatsPacket.DefaultImpls.decode(this, from);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jglrxavpok/moarboats/common/network/CRemoveModule$Handler;", "Lorg/jglrxavpok/moarboats/common/network/MBMessageHandler;", "Lorg/jglrxavpok/moarboats/common/network/CRemoveModule;", "Lorg/jglrxavpok/moarboats/common/network/SMapAnswer;", "()V", "packetClass", "Ljava/lang/Class;", "getPacketClass", "()Ljava/lang/Class;", "receiverSide", "Lnet/minecraftforge/api/distmarker/Dist;", "getReceiverSide", "()Lnet/minecraftforge/api/distmarker/Dist;", "onMessage", "message", "ctx", "Lnet/minecraftforge/fml/network/NetworkEvent$Context;", "moarboats"})
    public static final class Handler
    implements MBMessageHandler<CRemoveModule, SMapAnswer> {
        @NotNull
        private static final Class<CRemoveModule> packetClass;
        @NotNull
        private static final Dist receiverSide;
        public static final Handler INSTANCE;

        @Override
        @NotNull
        public Class<CRemoveModule> getPacketClass() {
            return packetClass;
        }

        @Override
        @NotNull
        public Dist getReceiverSide() {
            return receiverSide;
        }

        @Override
        @Nullable
        public SMapAnswer onMessage(@NotNull CRemoveModule message, @NotNull NetworkEvent.Context ctx) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            EntityPlayerMP entityPlayerMP = ctx.getSender();
            if (entityPlayerMP == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayerMP, (String)"ctx.sender!!");
            EntityPlayerMP player = entityPlayerMP;
            World world = player.field_70170_p;
            Entity entity = world.func_73045_a(message.getBoatID());
            if (!(entity instanceof ModularBoatEntity)) {
                entity = null;
            }
            ModularBoatEntity modularBoatEntity = (ModularBoatEntity)entity;
            if (modularBoatEntity == null) {
                return null;
            }
            ModularBoatEntity boat = modularBoatEntity;
            ResourceLocation moduleLocation = message.getModuleLocation();
            boat.removeModule(moduleLocation);
            player.func_71053_j();
            return null;
        }

        private Handler() {
        }

        static {
            Handler handler;
            INSTANCE = handler = new Handler();
            packetClass = CRemoveModule.class;
            receiverSide = Dist.DEDICATED_SERVER;
        }

        @Override
        public void handle(@NotNull CRemoveModule packet, @NotNull NetworkEvent.Context ctx) {
            Intrinsics.checkParameterIsNotNull((Object)packet, (String)"packet");
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            MBMessageHandler.DefaultImpls.handle(this, (MoarBoatsPacket)packet, ctx);
        }

        @Override
        public void registerSelf(@NotNull SimpleChannel network2, int packetID) {
            Intrinsics.checkParameterIsNotNull((Object)network2, (String)"network");
            MBMessageHandler.DefaultImpls.registerSelf(this, network2, packetID);
        }
    }
}

