/*
 * Decompiled with CFR 0.152.
 */
package net.alexwells.kottle;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import net.alexwells.kottle.KotlinAutomaticEventSubscriber;
import net.alexwells.kottle.KotlinEventBusSubscriber;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.moddiscovery.ModAnnotation;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnet/alexwells/kottle/KotlinAutomaticEventSubscriber;", "", "()V", "AUTO_SUBSCRIBER", "Lorg/objectweb/asm/Type;", "kotlin.jvm.PlatformType", "logger", "Lorg/apache/logging/log4j/Logger;", "inject", "", "mod", "Lnet/minecraftforge/fml/ModContainer;", "scanData", "Lnet/minecraftforge/forgespi/language/ModFileScanData;", "loader", "Ljava/lang/ClassLoader;", "shouldBeRegistered", "", "modId", "", "ad", "Lnet/minecraftforge/forgespi/language/ModFileScanData$AnnotationData;", "Kottle"})
public final class KotlinAutomaticEventSubscriber {
    private static final Type AUTO_SUBSCRIBER;
    private static final Logger logger;
    public static final KotlinAutomaticEventSubscriber INSTANCE;

    public final void inject(@NotNull ModContainer mod, @Nullable ModFileScanData scanData, @NotNull ClassLoader loader) {
        List targets2;
        Intrinsics.checkParameterIsNotNull(mod, "mod");
        Intrinsics.checkParameterIsNotNull(loader, "loader");
        if (scanData == null) {
            return;
        }
        logger.debug(Logging.LOADING, "Attempting to inject @EventBusSubscriber classes into the eventbus for {}", (Object)mod.getModId());
        List list = targets2 = scanData.getAnnotations().stream().filter(inject.targets.1.INSTANCE).filter((Predicate)new Predicate<ModFileScanData.AnnotationData>(mod){
            final /* synthetic */ ModContainer $mod;

            public final boolean test(ModFileScanData.AnnotationData annotationData) {
                String string = this.$mod.getModId();
                Intrinsics.checkExpressionValueIsNotNull(string, "mod.modId");
                ModFileScanData.AnnotationData annotationData2 = annotationData;
                Intrinsics.checkExpressionValueIsNotNull(annotationData2, "annotationData");
                return KotlinAutomaticEventSubscriber.access$shouldBeRegistered(KotlinAutomaticEventSubscriber.INSTANCE, string, annotationData2);
            }
            {
                this.$mod = modContainer;
            }
        }).collect(Collectors.toList());
        Intrinsics.checkExpressionValueIsNotNull(list, "targets");
        Iterable $receiver$iv = list;
        for (Object element$iv : $receiver$iv) {
            ModAnnotation.EnumHolder busTargetHolder;
            ModFileScanData.AnnotationData ad = (ModFileScanData.AnnotationData)element$iv;
            boolean bl = false;
            ModFileScanData.AnnotationData annotationData = ad;
            Intrinsics.checkExpressionValueIsNotNull(annotationData, "ad");
            if (annotationData.getAnnotationData().getOrDefault("bus", new ModAnnotation.EnumHolder(null, "FORGE")) == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraftforge.fml.loading.moddiscovery.ModAnnotation.EnumHolder");
            }
            String string = busTargetHolder.getValue();
            Intrinsics.checkExpressionValueIsNotNull(string, "busTargetHolder.value");
            KotlinEventBusSubscriber.Bus busTarget = KotlinEventBusSubscriber.Bus.valueOf(string);
            try {
                Class<?> className;
                Type type2 = ad.getClassType();
                Intrinsics.checkExpressionValueIsNotNull(type2, "ad.classType");
                logger.debug(Logging.LOADING, "Auto-subscribing {} to {}", (Object)type2.getClassName(), (Object)busTarget);
                Type type3 = ad.getClassType();
                Intrinsics.checkExpressionValueIsNotNull(type3, "ad.classType");
                Class<?> clazz = className = Class.forName(type3.getClassName(), true, loader);
                Intrinsics.checkExpressionValueIsNotNull(clazz, "className");
                Object object = JvmClassMappingKt.getKotlinClass(clazz).getObjectInstance();
                if (object == null) {
                    object = className;
                }
                busTarget.bus().get().register(object);
            }
            catch (ClassNotFoundException e) {
                logger.fatal(Logging.LOADING, "Failed to load mod class {} for @EventBusSubscriber annotation", (Object)ad.getClassType(), (Object)e);
                throw (Throwable)e;
            }
        }
    }

    private final boolean shouldBeRegistered(String modId, ModFileScanData.AnnotationData ad) {
        List<ModAnnotation.EnumHolder> list = ad.getAnnotationData().getOrDefault("value", Arrays.asList(new ModAnnotation.EnumHolder(null, "CLIENT"), new ModAnnotation.EnumHolder(null, "DEDICATED_SERVER")));
        if (list == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<net.minecraftforge.fml.loading.moddiscovery.ModAnnotation.EnumHolder>");
        }
        List<ModAnnotation.EnumHolder> sidesValue = list;
        Object c = sidesValue.stream().map(shouldBeRegistered.sides.1.INSTANCE).collect(Collectors.toCollection(shouldBeRegistered.sides.2.INSTANCE));
        if (c == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.EnumSet<net.minecraftforge.api.distmarker.Dist>");
        }
        EnumSet sides2 = (EnumSet)c;
        String string = ad.getAnnotationData().getOrDefault("modid", modId);
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        String annotationModId = string;
        return Intrinsics.areEqual(modId, annotationModId) && sides2.contains(FMLEnvironment.dist);
    }

    private KotlinAutomaticEventSubscriber() {
    }

    static {
        KotlinAutomaticEventSubscriber kotlinAutomaticEventSubscriber;
        INSTANCE = kotlinAutomaticEventSubscriber = new KotlinAutomaticEventSubscriber();
        AUTO_SUBSCRIBER = Type.getType(KotlinEventBusSubscriber.class);
        logger = LogManager.getLogger();
    }

    public static final /* synthetic */ Type access$getAUTO_SUBSCRIBER$p(KotlinAutomaticEventSubscriber $this) {
        KotlinAutomaticEventSubscriber kotlinAutomaticEventSubscriber = $this;
        return AUTO_SUBSCRIBER;
    }

    public static final /* synthetic */ boolean access$shouldBeRegistered(KotlinAutomaticEventSubscriber $this, String modId, ModFileScanData.AnnotationData ad) {
        return $this.shouldBeRegistered(modId, ad);
    }
}

