/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.client.renders;

import com.mojang.blaze3d.platform.GlStateManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.moarboats.api.BoatModule;
import org.jglrxavpok.moarboats.client.renders.BoatModuleRenderer;
import org.jglrxavpok.moarboats.common.entities.ModularBoatEntity;
import org.jglrxavpok.moarboats.common.modules.AnchorModule;
import org.jglrxavpok.moarboats.extensions.MathExtensionsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002JH\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jglrxavpok/moarboats/client/renders/AnchorModuleRenderer;", "Lorg/jglrxavpok/moarboats/client/renders/BoatModuleRenderer;", "()V", "renderChain", "", "anchorX", "", "anchorY", "anchorZ", "renderModule", "boat", "Lorg/jglrxavpok/moarboats/common/entities/ModularBoatEntity;", "module", "Lorg/jglrxavpok/moarboats/api/BoatModule;", "x", "y", "z", "entityYaw", "", "partialTicks", "EntityRendererManager", "Lnet/minecraft/client/renderer/entity/EntityRendererManager;", "moarboats"})
public final class AnchorModuleRenderer
extends BoatModuleRenderer {
    public static final AnchorModuleRenderer INSTANCE;

    @Override
    public void renderModule(@NotNull ModularBoatEntity boat, @NotNull BoatModule module, double x, double y, double z, float entityYaw, float partialTicks, @NotNull EntityRendererManager EntityRendererManager2) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)EntityRendererManager2, (String)"EntityRendererManager");
        GlStateManager.pushMatrix();
        AnchorModule anchor = (AnchorModule)module;
        double anchorX = ((Number)anchor.getAnchorXProperty().get(boat)).doubleValue();
        double anchorY = ((Number)anchor.getAnchorYProperty().get(boat)).doubleValue();
        double anchorZ = ((Number)anchor.getAnchorZProperty().get(boat)).doubleValue();
        if (((Boolean)anchor.getDeployedProperty().get(boat)).booleanValue()) {
            double dx = -(anchorX - boat.getPositionX());
            double dy = anchorY - boat.getPositionY();
            double dz = -(anchorZ - boat.getPositionZ());
            GlStateManager.rotatef((float)(180.0f - entityYaw - 90.0f), (float)0.0f, (float)-1.0f, (float)0.0f);
            GlStateManager.translated((double)dx, (double)dy, (double)dz);
            GlStateManager.rotatef((float)(180.0f - entityYaw - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            anchorX = boat.getPositionX();
            anchorY = boat.getPositionY();
            anchorZ = boat.getPositionZ();
        }
        double localX = -0.6;
        double localY = 0.0;
        double localZ = 0.7;
        GlStateManager.translated((double)localX, (double)localY, (double)localZ);
        GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)0.5f);
        double anchorScale = 0.75;
        GlStateManager.pushMatrix();
        GlStateManager.scaled((double)anchorScale, (double)anchorScale, (double)anchorScale);
        EntityRendererManager2.field_78724_e.func_110577_a(AtlasTexture.field_110575_b);
        Minecraft minecraft = Minecraft.func_71410_x();
        Intrinsics.checkExpressionValueIsNotNull((Object)minecraft, (String)"Minecraft.getInstance()");
        BlockRendererDispatcher blockRendererDispatcher = minecraft.func_175602_ab();
        Block block = Blocks.field_150467_bQ;
        Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"Blocks.ANVIL");
        blockRendererDispatcher.func_175016_a(block.func_176223_P(), boat.func_70013_c());
        GlStateManager.popMatrix();
        GlStateManager.translatef((float)0.5f, (float)0.5f, (float)-0.5f);
        float radangle = MathExtensionsKt.toRadians(90.0f - entityYaw);
        double dx = anchorX - boat.func_82615_a();
        double dy = anchorY - boat.func_82617_b();
        double dz = anchorZ - boat.func_82616_c();
        double localAnchorX = (double)(-MathHelper.func_76126_a((float)radangle)) * dz + (double)MathHelper.func_76134_b((float)radangle) * dx;
        double localAnchorZ = (double)MathHelper.func_76134_b((float)radangle) * dz + (double)MathHelper.func_76126_a((float)radangle) * dx;
        this.renderChain(localAnchorX, dy, localAnchorZ);
        GlStateManager.popMatrix();
    }

    /*
     * WARNING - void declaration
     */
    private final void renderChain(double anchorX, double anchorY, double anchorZ) {
        Tessellator tessellator;
        Tessellator tessellator2 = tessellator = Tessellator.func_178181_a();
        Intrinsics.checkExpressionValueIsNotNull((Object)tessellator2, (String)"tessellator");
        BufferBuilder bufferbuilder = tessellator2.func_178180_c();
        float yOffset = -0.06f;
        double dx = anchorX;
        double dy = -anchorY - (double)(yOffset * 2.0f);
        double dz = anchorZ;
        GlStateManager.disableTexture();
        GlStateManager.disableLighting();
        bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        int segmentCount = 16;
        GlStateManager.translatef((float)0.0f, (float)yOffset, (float)0.0f);
        boolean bl = false;
        int n = segmentCount;
        while (true) {
            void index;
            float step = (float)index / (float)segmentCount;
            bufferbuilder.func_181662_b(dx * (double)step, dy * (double)(step * step + step) * 0.5 + 0.25, dz * (double)step).func_181669_b(0, 0, 0, 255).func_181675_d();
            if (index == n) break;
            ++index;
        }
        tessellator.func_78381_a();
        GlStateManager.enableLighting();
        GlStateManager.enableTexture();
    }

    private AnchorModuleRenderer() {
    }

    static {
        AnchorModuleRenderer anchorModuleRenderer;
        INSTANCE = anchorModuleRenderer = new AnchorModuleRenderer();
        anchorModuleRenderer.setRegistryName(AnchorModule.INSTANCE.getId());
    }
}

