/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.blocks;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.common.items.WaterborneConductorItem;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u001c\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00060\u0010H\u0014J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u00020\u00132\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0014J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u001eH\u0016J \u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010 \u001a\u00020!H\u0016J,\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u00062\b\u0010$\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010&\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020'2\u0006\u0010\t\u001a\u00020\nH\u0016J2\u0010(\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020)2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u001dH\u0016J0\u0010-\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020)2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u0004H\u0016\u00a8\u00060"}, d2={"Lorg/jglrxavpok/moarboats/common/blocks/BlockWaterborneConductor;", "Lnet/minecraft/block/RedstoneDiodeBlock;", "()V", "canConnectRedstone", "", "state", "Lnet/minecraft/block/BlockState;", "level", "Lnet/minecraft/world/IBlockReader;", "pos", "Lnet/minecraft/util/math/BlockPos;", "side", "Lnet/minecraft/util/Direction;", "fillStateContainer", "", "builder", "Lnet/minecraft/state/StateContainer$Builder;", "Lnet/minecraft/block/Block;", "getActiveSignal", "", "levelIn", "getCollisionShape", "Lnet/minecraft/util/math/shapes/VoxelShape;", "worldIn", "context", "Lnet/minecraft/util/math/shapes/ISelectionContext;", "getDelay", "getDrops", "", "Lnet/minecraft/item/ItemStack;", "Lnet/minecraft/world/storage/loot/LootContext$Builder;", "getItem", "getRenderLayer", "Lnet/minecraft/util/BlockRenderLayer;", "getWeakPower", "blockState", "blockAccess", "isSolid", "isValidPosition", "Lnet/minecraft/world/IWorldReader;", "onBlockPlacedBy", "Lnet/minecraft/world/World;", "placer", "Lnet/minecraft/entity/LivingEntity;", "stack", "onReplaced", "newState", "isMoving", "moarboats"})
public final class BlockWaterborneConductor
extends RedstoneDiodeBlock {
    public static final BlockWaterborneConductor INSTANCE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canConnectRedstone(@Nullable BlockState state, @Nullable IBlockReader level, @Nullable BlockPos pos, @Nullable Direction side) {
        if (state == null) return false;
        if (side == null) return false;
        if (side == Direction.DOWN) return false;
        if (side == Direction.UP) return false;
        if (side == (Direction)state.func_177229_b((IProperty)HorizontalBlock.field_185512_D)) return true;
        Comparable comparable = state.func_177229_b((IProperty)HorizontalBlock.field_185512_D);
        Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"state.get(HorizontalBlock.HORIZONTAL_FACING)");
        if (side != ((Direction)comparable).func_176734_d()) return false;
        return true;
    }

    @NotNull
    public VoxelShape func_220071_b(@NotNull BlockState state, @NotNull IBlockReader worldIn, @NotNull BlockPos pos, @NotNull ISelectionContext context) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        VoxelShape voxelShape = VoxelShapes.func_197880_a();
        Intrinsics.checkExpressionValueIsNotNull((Object)voxelShape, (String)"VoxelShapes.empty()");
        return voxelShape;
    }

    public boolean func_196260_a(@NotNull BlockState state, @NotNull IWorldReader levelIn, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)levelIn, (String)"levelIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return levelIn.func_204610_c(pos.func_177977_b()).func_206884_a(FluidTags.field_206959_a);
    }

    protected int func_196346_i(@Nullable BlockState state) {
        return 0;
    }

    public int func_180656_a(@NotNull BlockState blockState, @Nullable IBlockReader blockAccess, @Nullable BlockPos pos, @NotNull Direction side) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)blockState, (String)"blockState");
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        if (!((Boolean)blockState.func_177229_b((IProperty)RedstoneDiodeBlock.field_196348_c)).booleanValue()) {
            n = 0;
        } else if (this.canConnectRedstone(blockState, blockAccess, pos, side)) {
            IBlockReader iBlockReader = blockAccess;
            if (iBlockReader == null) {
                Intrinsics.throwNpe();
            }
            BlockPos blockPos = pos;
            if (blockPos == null) {
                Intrinsics.throwNpe();
            }
            n = this.func_176408_a(iBlockReader, blockPos, blockState);
        } else {
            n = 0;
        }
        return n;
    }

    protected int func_176408_a(@NotNull IBlockReader levelIn, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)levelIn, (String)"levelIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Direction behindSide = (Direction)state.func_177229_b((IProperty)HorizontalBlock.field_185512_D);
        BlockPos posBehind = pos.func_177972_a(behindSide);
        BlockState behind = levelIn.func_180495_p(posBehind);
        return behind.func_185911_a(levelIn, posBehind, behindSide);
    }

    public boolean func_200124_e(@NotNull BlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        return false;
    }

    protected void func_206840_a(@NotNull StateContainer.Builder<Block, BlockState> builder) {
        Intrinsics.checkParameterIsNotNull(builder, (String)"builder");
        builder.func_206894_a(new IProperty[]{(IProperty)HorizontalBlock.field_185512_D, (IProperty)RedstoneDiodeBlock.field_196348_c});
    }

    public void func_196243_a(@NotNull BlockState state, @NotNull World levelIn, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)levelIn, (String)"levelIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)newState, (String)"newState");
        super.func_196243_a(state, levelIn, pos, newState, isMoving);
        this.func_176400_h(levelIn, pos, state);
    }

    public void func_180633_a(@NotNull World levelIn, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)levelIn, (String)"levelIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        super.func_180633_a(levelIn, pos, state, placer, stack);
    }

    @NotNull
    public List<ItemStack> func_220076_a(@NotNull BlockState state, @NotNull LootContext.Builder builder) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        return CollectionsKt.mutableListOf((Object[])new ItemStack[]{new ItemStack((IItemProvider)WaterborneConductorItem.INSTANCE, 1)});
    }

    @NotNull
    public ItemStack func_185473_a(@NotNull IBlockReader worldIn, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        return new ItemStack((IItemProvider)WaterborneConductorItem.INSTANCE, 1);
    }

    @NotNull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    private BlockWaterborneConductor() {
        super(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200943_b(0.0f).func_200947_a(SoundType.field_185848_a));
    }

    static {
        BlockWaterborneConductor blockWaterborneConductor;
        INSTANCE = blockWaterborneConductor = new BlockWaterborneConductor();
        blockWaterborneConductor.setRegistryName(new ResourceLocation("moarboats", "waterborne_redstone"));
        StateContainer stateContainer = blockWaterborneConductor.field_176227_L;
        Intrinsics.checkExpressionValueIsNotNull((Object)stateContainer, (String)"stateContainer");
        blockWaterborneConductor.func_180632_j((BlockState)((BlockState)((BlockState)stateContainer.func_177621_b()).func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((IProperty)RedstoneDiodeBlock.field_196348_c, (Comparable)Boolean.valueOf(false)));
    }
}

