/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.items;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.MoarBoats;
import org.jglrxavpok.moarboats.common.data.LoopingOptions;
import org.jglrxavpok.moarboats.common.items.ItemGoldenTicket;
import org.jglrxavpok.moarboats.common.items.ItemPath;
import org.jglrxavpok.moarboats.common.items.MapItemWithPath;
import org.jglrxavpok.moarboats.common.network.SSetGoldenItinerary;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001)B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0019J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010!\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u0017H\u0016J.\u0010#\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dJ\u001e\u0010#\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jglrxavpok/moarboats/common/items/ItemGoldenTicket;", "Lorg/jglrxavpok/moarboats/common/items/ItemPath;", "()V", "EmptyName", "Lnet/minecraft/util/text/TranslationTextComponent;", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "worldIn", "Lnet/minecraft/world/World;", "tooltip", "", "Lnet/minecraft/util/text/ITextComponent;", "flagIn", "Lnet/minecraft/client/util/ITooltipFlag;", "createStack", "uuid", "", "getData", "Lorg/jglrxavpok/moarboats/common/items/ItemGoldenTicket$WaypointData;", "getDisplayName", "getLoopingOptions", "Lorg/jglrxavpok/moarboats/common/data/LoopingOptions;", "getUUID", "Ljava/util/UUID;", "getWaypointData", "Lnet/minecraft/nbt/ListNBT;", "mapStorage", "Lnet/minecraft/world/storage/DimensionSavedDataManager;", "initStack", "isEmpty", "", "setLoopingOptions", "option", "updateItinerary", "list", "mapID", "map", "Lorg/jglrxavpok/moarboats/common/items/MapItemWithPath;", "mapStack", "WaypointData", "moarboats"})
public final class ItemGoldenTicket
extends ItemPath {
    private static final TranslationTextComponent EmptyName;
    public static final ItemGoldenTicket INSTANCE;

    @Override
    public void setLoopingOptions(@NotNull ItemStack stack, @NotNull LoopingOptions option) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)((Object)option), (String)"option");
        this.getData(stack).setLoopingOption(option);
    }

    @Override
    @NotNull
    public LoopingOptions getLoopingOptions(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return this.getData(stack).getLoopingOption();
    }

    @Override
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull(tooltip, (String)"tooltip");
        Intrinsics.checkParameterIsNotNull((Object)flagIn, (String)"flagIn");
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        UUID uuid = this.getUUID(stack);
        if (uuid != null) {
            tooltip.add((ITextComponent)new StringTextComponent("UUID: " + uuid));
        }
    }

    @Override
    @NotNull
    public ListNBT getWaypointData(@NotNull ItemStack stack, @NotNull DimensionSavedDataManager mapStorage) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)mapStorage, (String)"mapStorage");
        WaypointData data2 = this.getData(stack);
        return data2.getBackingList();
    }

    public final void initStack(@NotNull ItemStack stack, @NotNull UUID uuid) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
        stack.func_190925_c("moarboats.path").func_186854_a("path_uuid", uuid);
    }

    @Nullable
    public final UUID getUUID(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        CompoundNBT compoundNBT = stack.func_179543_a("moarboats.path");
        return compoundNBT != null ? compoundNBT.func_186857_a("path_uuid") : null;
    }

    @NotNull
    public ITextComponent func_200295_i(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (!this.isEmpty(stack)) {
            ITextComponent iTextComponent = super.func_200295_i(stack);
            Intrinsics.checkExpressionValueIsNotNull((Object)iTextComponent, (String)"super.getDisplayName(stack)");
            return iTextComponent;
        }
        return (ITextComponent)EmptyName;
    }

    @NotNull
    public final ItemStack createStack(@NotNull String uuid) {
        Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
        ItemStack result = new ItemStack((IItemProvider)this);
        result.func_190925_c("moarboats.path").func_186854_a("path_uuid", UUID.fromString(uuid));
        return result;
    }

    public final boolean isEmpty(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return !stack.func_77942_o() || stack.func_179543_a("moarboats.path") == null;
    }

    public final void updateItinerary(@NotNull ItemStack stack, @NotNull MapItemWithPath map, @NotNull ItemStack mapStack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)((Object)map), (String)"map");
        Intrinsics.checkParameterIsNotNull((Object)mapStack, (String)"mapStack");
        DimensionSavedDataManager mapStorage = MoarBoats.getLocalMapStorage$default(MoarBoats.INSTANCE, null, 1, null);
        CompoundNBT compoundNBT = mapStack.func_77978_p();
        if (compoundNBT == null) {
            Intrinsics.throwNpe();
        }
        String mapID = compoundNBT.func_74779_i("moarboats.mapID");
        LoopingOptions loopingOption = LoopingOptions.NoLoop;
        CompoundNBT compoundNBT2 = mapStack.func_77978_p();
        if (compoundNBT2 == null) {
            Intrinsics.throwNpe();
        }
        if (compoundNBT2.func_74767_n("moarboats.loops")) {
            loopingOption = LoopingOptions.Loops;
        }
        CompoundNBT compoundNBT3 = mapStack.func_77978_p();
        if (compoundNBT3 == null) {
            Intrinsics.throwNpe();
        }
        if (compoundNBT3.func_74764_b("moarboats.loopingOption")) {
            LoopingOptions[] loopingOptionsArray = LoopingOptions.values();
            CompoundNBT compoundNBT4 = mapStack.func_77978_p();
            if (compoundNBT4 == null) {
                Intrinsics.throwNpe();
            }
            loopingOption = loopingOptionsArray[RangesKt.coerceIn((int)compoundNBT4.func_74762_e("moarboats.loopingOption"), (ClosedRange)((ClosedRange)ArraysKt.getIndices((Object[])LoopingOptions.values())))];
        }
        ListNBT listNBT = map.getWaypointData(mapStack, mapStorage);
        String string = mapID;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mapID");
        this.updateItinerary(stack, listNBT, string, loopingOption, mapStorage);
    }

    public final void updateItinerary(@NotNull ItemStack stack, @NotNull ListNBT list, @NotNull String mapID, @NotNull LoopingOptions option, @NotNull DimensionSavedDataManager mapStorage) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)list, (String)"list");
        Intrinsics.checkParameterIsNotNull((Object)mapID, (String)"mapID");
        Intrinsics.checkParameterIsNotNull((Object)((Object)option), (String)"option");
        Intrinsics.checkParameterIsNotNull((Object)mapStorage, (String)"mapStorage");
        String uuid = String.valueOf(this.getUUID(stack));
        WaypointData data2 = new WaypointData(uuid);
        data2.setBackingList(list);
        data2.setLoopingOption(option);
        data2.setMapID(mapID);
        mapStorage.func_215757_a((WorldSavedData)data2);
        DistExecutor.callWhenOn((Dist)Dist.DEDICATED_SERVER, (Supplier)new Supplier<Callable<T>>(data2){
            final /* synthetic */ WaypointData $data;

            @NotNull
            public final Callable<Unit> get() {
                return new Callable<Unit>(this){
                    final /* synthetic */ updateItinerary.1 this$0;

                    public final void call() {
                        MoarBoats.INSTANCE.getNetwork().send(PacketDistributor.ALL.noArg(), (Object)new SSetGoldenItinerary(this.this$0.$data));
                    }
                    {
                        this.this$0 = var1_1;
                    }
                };
            }
            {
                this.$data = waypointData;
            }
        });
    }

    @NotNull
    public final WaypointData getData(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        DimensionSavedDataManager mapStorage = MoarBoats.getLocalMapStorage$default(MoarBoats.INSTANCE, null, 1, null);
        UUID uuid = this.getUUID(stack);
        String uuidString = String.valueOf(uuid);
        WaypointData data2 = (WaypointData)mapStorage.func_215753_b((Supplier)new Supplier<WaypointData>(uuidString){
            final /* synthetic */ String $uuidString;

            @NotNull
            public final WaypointData get() {
                return new WaypointData(this.$uuidString);
            }
            {
                this.$uuidString = string;
            }
        }, uuidString);
        if (data2 == null) {
            data2 = new WaypointData(uuidString);
            mapStorage.func_215757_a((WorldSavedData)data2);
        }
        return data2;
    }

    private ItemGoldenTicket() {
        super("golden_ticket", false, 2, null);
    }

    static {
        ItemGoldenTicket itemGoldenTicket;
        INSTANCE = itemGoldenTicket = new ItemGoldenTicket();
        EmptyName = new TranslationTextComponent("moarboats.item.golden_ticket.name.empty", new Object[0]);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\b\u0010\u001f\u001a\u00020\u001aH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001J\u0010\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020#H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0013\"\u0004\b\u0016\u0010\u0004\u00a8\u0006'"}, d2={"Lorg/jglrxavpok/moarboats/common/items/ItemGoldenTicket$WaypointData;", "Lnet/minecraft/world/storage/WorldSavedData;", "uuid", "", "(Ljava/lang/String;)V", "backingList", "Lnet/minecraft/nbt/ListNBT;", "getBackingList", "()Lnet/minecraft/nbt/ListNBT;", "setBackingList", "(Lnet/minecraft/nbt/ListNBT;)V", "loopingOption", "Lorg/jglrxavpok/moarboats/common/data/LoopingOptions;", "getLoopingOption", "()Lorg/jglrxavpok/moarboats/common/data/LoopingOptions;", "setLoopingOption", "(Lorg/jglrxavpok/moarboats/common/data/LoopingOptions;)V", "mapID", "getMapID", "()Ljava/lang/String;", "setMapID", "getUuid", "setUuid", "component1", "copy", "equals", "", "other", "", "hashCode", "", "isDirty", "read", "", "nbt", "Lnet/minecraft/nbt/CompoundNBT;", "toString", "write", "compound", "moarboats"})
    public static final class WaypointData
    extends WorldSavedData {
        @NotNull
        private ListNBT backingList;
        @NotNull
        private LoopingOptions loopingOption;
        @NotNull
        private String mapID;
        @NotNull
        private String uuid;

        @NotNull
        public final ListNBT getBackingList() {
            return this.backingList;
        }

        public final void setBackingList(@NotNull ListNBT listNBT) {
            Intrinsics.checkParameterIsNotNull((Object)listNBT, (String)"<set-?>");
            this.backingList = listNBT;
        }

        @NotNull
        public final LoopingOptions getLoopingOption() {
            return this.loopingOption;
        }

        public final void setLoopingOption(@NotNull LoopingOptions loopingOptions) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)loopingOptions), (String)"<set-?>");
            this.loopingOption = loopingOptions;
        }

        @NotNull
        public final String getMapID() {
            return this.mapID;
        }

        public final void setMapID(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.mapID = string;
        }

        public boolean func_76188_b() {
            return true;
        }

        @NotNull
        public CompoundNBT func_189551_b(@NotNull CompoundNBT compound) {
            Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
            compound.func_218657_a("moarboats.path", (INBT)this.backingList);
            compound.func_74768_a("moarboats.loopingOption", this.loopingOption.ordinal());
            compound.func_74778_a("moarboats.mapID", this.mapID);
            return compound;
        }

        public void func_76184_a(@NotNull CompoundNBT nbt) {
            Intrinsics.checkParameterIsNotNull((Object)nbt, (String)"nbt");
            ListNBT listNBT = nbt.func_150295_c("moarboats.path", 10);
            Intrinsics.checkExpressionValueIsNotNull((Object)listNBT, (String)"nbt.getList(\"${MoarBoats\u2026nstants.NBT.TAG_COMPOUND)");
            this.backingList = listNBT;
            if (nbt.func_74767_n("moarboats.loops")) {
                this.loopingOption = LoopingOptions.Loops;
            }
            if (nbt.func_74764_b("moarboats.loopingOption")) {
                this.loopingOption = LoopingOptions.values()[RangesKt.coerceIn((int)nbt.func_74762_e("moarboats.loopingOption"), (ClosedRange)((ClosedRange)ArraysKt.getIndices((Object[])LoopingOptions.values())))];
            }
            String string = nbt.func_74779_i("moarboats.mapID");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"nbt.getString(\"${MoarBoats.ModID}.mapID\")");
            this.mapID = string;
        }

        @NotNull
        public final String getUuid() {
            return this.uuid;
        }

        public final void setUuid(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.uuid = string;
        }

        public WaypointData(@NotNull String uuid) {
            Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
            super(uuid);
            this.uuid = uuid;
            this.backingList = new ListNBT();
            this.loopingOption = LoopingOptions.NoLoop;
            this.mapID = "";
        }

        @NotNull
        public final String component1() {
            return this.uuid;
        }

        @NotNull
        public final WaypointData copy(@NotNull String uuid) {
            Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
            return new WaypointData(uuid);
        }

        @NotNull
        public static /* synthetic */ WaypointData copy$default(WaypointData waypointData, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = waypointData.uuid;
            }
            return waypointData.copy(string);
        }

        @NotNull
        public String toString() {
            return "WaypointData(uuid=" + this.uuid + ")";
        }

        public int hashCode() {
            String string = this.uuid;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof WaypointData)) break block3;
                    WaypointData waypointData = (WaypointData)((Object)object);
                    if (!Intrinsics.areEqual((Object)this.uuid, (Object)waypointData.uuid)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

