/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.items;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.LeashKnotEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.common.entities.BasicBoatEntity;
import org.jglrxavpok.moarboats.common.items.MoarBoatsItem;
import org.jglrxavpok.moarboats.common.items.RopeItem$WhenMappings;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001)B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bJ&\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u001d2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#H\u0016J.\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u0011J\u0010\u0010'\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\bH\u0002J \u0010(\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jglrxavpok/moarboats/common/items/RopeItem;", "Lorg/jglrxavpok/moarboats/common/items/MoarBoatsItem;", "()V", "ropeInfo", "Lnet/minecraft/util/text/TranslationTextComponent;", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "levelIn", "Lnet/minecraft/world/World;", "tooltip", "", "Lnet/minecraft/util/text/ITextComponent;", "flagIn", "Lnet/minecraft/client/util/ITooltipFlag;", "getLinked", "Lorg/jglrxavpok/moarboats/common/entities/BasicBoatEntity;", "getState", "Lorg/jglrxavpok/moarboats/common/items/RopeItem$State;", "nbt", "Lnet/minecraft/nbt/CompoundNBT;", "onEntityInteract", "Lnet/minecraft/util/ActionResultType;", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "entity", "Lnet/minecraft/entity/Entity;", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "playerIn", "handIn", "Lnet/minecraft/util/Hand;", "onItemUse", "context", "Lnet/minecraft/item/ItemUseContext;", "onLinkUsed", "itemstack", "boatEntity", "resetLinked", "setLinked", "State", "moarboats"})
public final class RopeItem
extends MoarBoatsItem {
    private static final TranslationTextComponent ropeInfo;
    public static final RopeItem INSTANCE;

    private final void setLinked(World levelIn, ItemStack stack, BasicBoatEntity entity) {
        this.nbt(stack).func_74768_a("linked", entity.getEntityID());
    }

    private final BasicBoatEntity getLinked(World levelIn, ItemStack stack) {
        int id = this.nbt(stack).func_74762_e("linked");
        return (BasicBoatEntity)levelIn.func_73045_a(id);
    }

    private final CompoundNBT nbt(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new CompoundNBT());
        }
        CompoundNBT compoundNBT = stack.func_77978_p();
        if (compoundNBT == null) {
            Intrinsics.throwNpe();
        }
        return compoundNBT;
    }

    private final void resetLinked(ItemStack itemstack) {
        this.nbt(itemstack).func_82580_o("linked");
    }

    @NotNull
    public final State getState(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (this.nbt(stack).func_74764_b("linked")) {
            return State.WAITING_NEXT;
        }
        return State.READY;
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World levelIn, @NotNull PlayerEntity playerIn, @NotNull Hand handIn) {
        Intrinsics.checkParameterIsNotNull((Object)levelIn, (String)"levelIn");
        Intrinsics.checkParameterIsNotNull((Object)playerIn, (String)"playerIn");
        Intrinsics.checkParameterIsNotNull((Object)handIn, (String)"handIn");
        ItemStack itemStack = playerIn.func_184586_b(handIn);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"playerIn.getHeldItem(handIn)");
        this.resetLinked(itemStack);
        ActionResult actionResult = super.func_77659_a(levelIn, playerIn, handIn);
        Intrinsics.checkExpressionValueIsNotNull((Object)actionResult, (String)"super.onItemRightClick(levelIn, playerIn, handIn)");
        return actionResult;
    }

    public final void onLinkUsed(@NotNull ItemStack itemstack, @NotNull PlayerEntity playerIn, @NotNull Hand handIn, @NotNull World levelIn, @NotNull BasicBoatEntity boatEntity) {
        Intrinsics.checkParameterIsNotNull((Object)itemstack, (String)"itemstack");
        Intrinsics.checkParameterIsNotNull((Object)playerIn, (String)"playerIn");
        Intrinsics.checkParameterIsNotNull((Object)handIn, (String)"handIn");
        Intrinsics.checkParameterIsNotNull((Object)levelIn, (String)"levelIn");
        Intrinsics.checkParameterIsNotNull((Object)boatEntity, (String)"boatEntity");
        switch (RopeItem$WhenMappings.$EnumSwitchMapping$0[this.getState(itemstack).ordinal()]) {
            case 1: {
                BasicBoatEntity basicBoatEntity = this.getLinked(levelIn, itemstack);
                if (basicBoatEntity == null) {
                    return;
                }
                BasicBoatEntity other = basicBoatEntity;
                BasicBoatEntity hit = boatEntity;
                if (Intrinsics.areEqual((Object)other, (Object)hit)) {
                    playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("item.rope.notToSelf", new Object[0]), true);
                } else if (hit.hasLink(BasicBoatEntity.Companion.getBackLink())) {
                    playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("item.rope.backOccupied", new Object[0]), true);
                } else {
                    hit.linkTo(other, BasicBoatEntity.Companion.getBackLink());
                    other.linkTo(hit, BasicBoatEntity.Companion.getFrontLink());
                }
                this.resetLinked(itemstack);
                if (playerIn.func_184812_l_()) break;
                itemstack.func_190918_g(1);
                break;
            }
            default: {
                if (boatEntity.hasLink(BasicBoatEntity.Companion.getFrontLink())) {
                    playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("item.rope.frontOccupied", new Object[0]), true);
                    this.resetLinked(itemstack);
                    break;
                }
                this.setLinked(levelIn, itemstack, boatEntity);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public ActionResultType func_195939_a(@NotNull ItemUseContext context) {
        ActionResultType actionResultType;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        World world = context.func_195991_k();
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"context.world");
        World levelIn = world;
        BlockPos blockPos = context.func_195995_a();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"context.pos");
        BlockPos pos = blockPos;
        BlockState blockState = levelIn.func_180495_p(pos);
        Intrinsics.checkExpressionValueIsNotNull((Object)blockState, (String)"levelIn.getBlockState(pos)");
        Block block = blockState.func_177230_c();
        ItemStack stack = context.func_195996_i();
        if (block instanceof FenceBlock) {
            ItemStack itemStack = stack;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
            if (this.getState(itemStack) == State.WAITING_NEXT) {
                if (!levelIn.field_72995_K) {
                    LeashKnotEntity knot = LeashKnotEntity.func_213855_a((World)levelIn, (BlockPos)pos);
                    BasicBoatEntity basicBoatEntity = this.getLinked(levelIn, stack);
                    if (basicBoatEntity == null) return ActionResultType.PASS;
                    BasicBoatEntity target2 = basicBoatEntity;
                    target2.linkTo((Entity)knot, BasicBoatEntity.Companion.getFrontLink());
                }
                this.resetLinked(stack);
                actionResultType = ActionResultType.SUCCESS;
                return actionResultType;
            }
        }
        actionResultType = ActionResultType.PASS;
        return actionResultType;
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World levelIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull(tooltip, (String)"tooltip");
        Intrinsics.checkParameterIsNotNull((Object)flagIn, (String)"flagIn");
        super.func_77624_a(stack, levelIn, tooltip, flagIn);
        tooltip.add((ITextComponent)ropeInfo);
    }

    @NotNull
    public final ActionResultType onEntityInteract(@NotNull PlayerEntity player, @NotNull ItemStack stack, @NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        if (this.getState(stack) == State.WAITING_NEXT && entity instanceof LeashKnotEntity) {
            World level = player.field_70170_p;
            if (!level.field_72995_K) {
                World world = level;
                Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"level");
                BasicBoatEntity basicBoatEntity = this.getLinked(world, stack);
                if (basicBoatEntity == null) {
                    return ActionResultType.PASS;
                }
                BasicBoatEntity target2 = basicBoatEntity;
                target2.linkTo(entity, BasicBoatEntity.Companion.getFrontLink());
            }
            this.resetLinked(stack);
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private RopeItem() {
        super("rope", null, false, 6, null);
    }

    static {
        RopeItem ropeItem;
        INSTANCE = ropeItem = new RopeItem();
        ropeItem.func_185043_a(new ResourceLocation("first_knot"), 1.INSTANCE);
        ropeInfo = new TranslationTextComponent("item.rope.description", new Object[0]);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jglrxavpok/moarboats/common/items/RopeItem$State;", "", "(Ljava/lang/String;I)V", "WAITING_NEXT", "READY", "moarboats"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State WAITING_NEXT;
        public static final /* enum */ State READY;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[2];
            State[] stateArray2 = stateArray;
            stateArray[0] = WAITING_NEXT = new State();
            stateArray[1] = READY = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }
}

