/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.modules;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.api.BoatModule;
import org.jglrxavpok.moarboats.api.IControllable;
import org.jglrxavpok.moarboats.client.gui.GuiAnchorModule;
import org.jglrxavpok.moarboats.common.containers.ContainerBoatModule;
import org.jglrxavpok.moarboats.common.containers.EmptyModuleContainer;
import org.jglrxavpok.moarboats.common.modules.BlockReason;
import org.jglrxavpok.moarboats.common.state.BoatPropertyKt;
import org.jglrxavpok.moarboats.common.state.BooleanBoatProperty;
import org.jglrxavpok.moarboats.common.state.DoubleBoatProperty;
import org.jglrxavpok.moarboats.common.state.IntBoatProperty;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J&\u0010/\u001a\b\u0012\u0002\b\u0003\u0018\u0001002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020.H\u0016J \u00106\u001a\u0002072\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020.H\u0016J\u0016\u00108\u001a\u00020,2\u0006\u00105\u001a\u00020.2\u0006\u00103\u001a\u000204J\u0018\u00109\u001a\u00020,2\u0006\u00105\u001a\u00020.2\u0006\u0010:\u001a\u00020\u001fH\u0016J\u0010\u0010;\u001a\u00020,2\u0006\u0010<\u001a\u00020.H\u0016J(\u0010=\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020.2\u0006\u00103\u001a\u0002042\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u001fH\u0016J\u0010\u0010A\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010 R\u0014\u0010!\u001a\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020\u001fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010 \u00a8\u0006B"}, d2={"Lorg/jglrxavpok/moarboats/common/modules/AnchorModule;", "Lorg/jglrxavpok/moarboats/api/BoatModule;", "Lorg/jglrxavpok/moarboats/common/modules/BlockReason;", "()V", "activeProperty", "Lorg/jglrxavpok/moarboats/common/state/BooleanBoatProperty;", "getActiveProperty", "()Lorg/jglrxavpok/moarboats/common/state/BooleanBoatProperty;", "anchorDescentSpeed", "", "getAnchorDescentSpeed", "()D", "anchorDirectionProperty", "Lorg/jglrxavpok/moarboats/common/state/IntBoatProperty;", "getAnchorDirectionProperty", "()Lorg/jglrxavpok/moarboats/common/state/IntBoatProperty;", "anchorXProperty", "Lorg/jglrxavpok/moarboats/common/state/DoubleBoatProperty;", "getAnchorXProperty", "()Lorg/jglrxavpok/moarboats/common/state/DoubleBoatProperty;", "anchorYProperty", "getAnchorYProperty", "anchorZProperty", "getAnchorZProperty", "deployedProperty", "getDeployedProperty", "id", "Lnet/minecraft/util/ResourceLocation;", "getId", "()Lnet/minecraft/util/ResourceLocation;", "isMenuInteresting", "", "()Z", "moduleSpot", "Lorg/jglrxavpok/moarboats/api/BoatModule$Spot;", "getModuleSpot", "()Lorg/jglrxavpok/moarboats/api/BoatModule$Spot;", "spawnPointSet", "Lnet/minecraft/util/text/TranslationTextComponent;", "getSpawnPointSet", "()Lnet/minecraft/util/text/TranslationTextComponent;", "usesInventory", "getUsesInventory", "controlBoat", "", "from", "Lorg/jglrxavpok/moarboats/api/IControllable;", "createContainer", "Lorg/jglrxavpok/moarboats/common/containers/ContainerBoatModule;", "containerID", "", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "boat", "createGui", "Lnet/minecraft/client/gui/screen/Screen;", "deploy", "dropItemsOnDeath", "killedByPlayerInCreative", "onAddition", "to", "onInteract", "hand", "Lnet/minecraft/util/Hand;", "sneaking", "update", "moarboats"})
public final class AnchorModule
extends BoatModule
implements BlockReason {
    @NotNull
    private static final ResourceLocation id;
    private static final boolean usesInventory = false;
    @NotNull
    private static final BoatModule.Spot moduleSpot;
    private static final boolean isMenuInteresting = false;
    @NotNull
    private static final TranslationTextComponent spawnPointSet;
    @NotNull
    private static final BooleanBoatProperty activeProperty;
    @NotNull
    private static final IntBoatProperty anchorDirectionProperty;
    @NotNull
    private static final DoubleBoatProperty anchorXProperty;
    @NotNull
    private static final DoubleBoatProperty anchorYProperty;
    @NotNull
    private static final DoubleBoatProperty anchorZProperty;
    @NotNull
    private static final BooleanBoatProperty deployedProperty;
    public static final AnchorModule INSTANCE;

    @Override
    @NotNull
    public ResourceLocation getId() {
        return id;
    }

    @Override
    public boolean getUsesInventory() {
        return usesInventory;
    }

    @Override
    @NotNull
    public BoatModule.Spot getModuleSpot() {
        return moduleSpot;
    }

    @Override
    public boolean isMenuInteresting() {
        return isMenuInteresting;
    }

    @NotNull
    public final TranslationTextComponent getSpawnPointSet() {
        return spawnPointSet;
    }

    @NotNull
    public final BooleanBoatProperty getActiveProperty() {
        return activeProperty;
    }

    @NotNull
    public final IntBoatProperty getAnchorDirectionProperty() {
        return anchorDirectionProperty;
    }

    @NotNull
    public final DoubleBoatProperty getAnchorXProperty() {
        return anchorXProperty;
    }

    @NotNull
    public final DoubleBoatProperty getAnchorYProperty() {
        return anchorYProperty;
    }

    @NotNull
    public final DoubleBoatProperty getAnchorZProperty() {
        return anchorZProperty;
    }

    @NotNull
    public final BooleanBoatProperty getDeployedProperty() {
        return deployedProperty;
    }

    public final double getAnchorDescentSpeed() {
        return 0.2;
    }

    @Override
    public boolean onInteract(@NotNull IControllable from, @NotNull PlayerEntity player, @NotNull Hand hand, boolean sneaking) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        return false;
    }

    @Override
    public void controlBoat(@NotNull IControllable from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        boolean active = (Boolean)activeProperty.get(from);
        if (active) {
            from.blockMovement(this);
        }
    }

    @Override
    public void update(@NotNull IControllable from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        boolean deployed = (Boolean)deployedProperty.get(from);
        if (!deployed) {
            return;
        }
        int direction = ((Number)anchorDirectionProperty.get(from)).intValue();
        if (direction == 0) {
            return;
        }
        double anchorX = ((Number)anchorXProperty.get(from)).doubleValue();
        double anchorY = ((Number)anchorYProperty.get(from)).doubleValue();
        double anchorZ = ((Number)anchorZProperty.get(from)).doubleValue();
        if (direction == -1) {
            double nextY = anchorY + this.getAnchorDescentSpeed() * (double)direction;
            anchorYProperty.set(from, nextY);
            BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185345_c((double)anchorX, (double)nextY, (double)anchorZ);
            World world = from.getWorldRef();
            if (world.func_180495_p((BlockPos)pos).func_196955_c((IWorldReader)world, (BlockPos)pos)) {
                anchorDirectionProperty.set(from, 0);
                activeProperty.set(from, true);
            }
            pos.close();
        } else {
            double dx = from.getPositionX() - anchorX;
            double dy = from.getPositionY() - anchorY;
            double dz = from.getPositionZ() - anchorZ;
            double d = dx * dx + dy * dy + dz * dz;
            double totalLength = Math.sqrt(d);
            double toAdvance = this.getAnchorDescentSpeed();
            double length = Math.min(toAdvance, totalLength) / totalLength;
            double nextX = dx * length + anchorX;
            double nextY = dy * length + anchorY;
            double nextZ = dz * length + anchorZ;
            anchorXProperty.set(from, nextX);
            anchorYProperty.set(from, nextY);
            anchorZProperty.set(from, nextZ);
            if (from.getCorrespondingEntity().func_174791_d().func_186679_c(nextX, nextY, nextZ) < 1.0) {
                anchorDirectionProperty.set(from, 0);
                deployedProperty.set(from, false);
            }
        }
    }

    @Override
    public void onAddition(@NotNull IControllable to) {
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        activeProperty.set(to, false);
        deployedProperty.set(to, false);
        anchorXProperty.set(to, 0.0);
        anchorYProperty.set(to, 0.0);
        anchorZProperty.set(to, 0.0);
        anchorDirectionProperty.set(to, 0);
    }

    @Override
    @Nullable
    public ContainerBoatModule<?> createContainer(int containerID, @NotNull PlayerEntity player, @NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        PlayerInventory playerInventory = player.field_71071_by;
        Intrinsics.checkExpressionValueIsNotNull((Object)playerInventory, (String)"player.inventory");
        return new EmptyModuleContainer(containerID, playerInventory, this, boat, false, 0, 48, null);
    }

    @Override
    @NotNull
    public Screen createGui(int containerID, @NotNull PlayerEntity player, @NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        PlayerInventory playerInventory = player.field_71071_by;
        Intrinsics.checkExpressionValueIsNotNull((Object)playerInventory, (String)"player.inventory");
        return (Screen)new GuiAnchorModule(containerID, playerInventory, this, boat);
    }

    public final void deploy(@NotNull IControllable boat, @NotNull PlayerEntity player) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        boolean deployed = (Boolean)deployedProperty.get(boat);
        if (deployed) {
            anchorDirectionProperty.set(boat, 1);
            activeProperty.set(boat, false);
        } else {
            deployedProperty.set(boat, true);
            anchorDirectionProperty.set(boat, -1);
            anchorXProperty.set(boat, boat.getPositionX());
            anchorYProperty.set(boat, boat.getPositionY());
            anchorZProperty.set(boat, boat.getPositionZ());
            player.func_146105_b((ITextComponent)spawnPointSet, true);
            player.func_180473_a(boat.getCorrespondingEntity().func_180425_c(), true);
        }
    }

    @Override
    public void dropItemsOnDeath(@NotNull IControllable boat, boolean killedByPlayerInCreative) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        if (!killedByPlayerInCreative) {
            boat.getCorrespondingEntity().func_199702_a((IItemProvider)Blocks.field_150467_bQ.func_199767_j(), 1);
        }
    }

    private AnchorModule() {
    }

    static {
        AnchorModule anchorModule;
        INSTANCE = anchorModule = new AnchorModule();
        id = new ResourceLocation("moarboats", "anchor");
        moduleSpot = BoatModule.Spot.Misc;
        spawnPointSet = new TranslationTextComponent("gui.anchor.spawnPointSet", new Object[0]);
        activeProperty = BoatPropertyKt.BooleanBoatProperty(anchorModule, "active");
        anchorDirectionProperty = BoatPropertyKt.IntBoatProperty(anchorModule, "anchorDirection");
        anchorXProperty = BoatPropertyKt.DoubleBoatProperty(anchorModule, "anchorX");
        anchorYProperty = BoatPropertyKt.DoubleBoatProperty(anchorModule, "anchorY");
        anchorZProperty = BoatPropertyKt.DoubleBoatProperty(anchorModule, "anchorZ");
        deployedProperty = BoatPropertyKt.BooleanBoatProperty(anchorModule, "deployed");
    }

    @Override
    public boolean blocksSpeed() {
        return BlockReason.DefaultImpls.blocksSpeed(this);
    }

    @Override
    public boolean blocksRotation() {
        return BlockReason.DefaultImpls.blocksRotation(this);
    }
}

