/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.modules;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.BlockState;
import net.minecraft.block.HopperBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.moarboats.api.BoatModule;
import org.jglrxavpok.moarboats.api.BoatModuleInventory;
import org.jglrxavpok.moarboats.api.IControllable;
import org.jglrxavpok.moarboats.client.gui.GuiEngineModule;
import org.jglrxavpok.moarboats.common.containers.ContainerBoatModule;
import org.jglrxavpok.moarboats.common.modules.BlockedByRedstone;
import org.jglrxavpok.moarboats.common.modules.NoBlockReason;
import org.jglrxavpok.moarboats.common.state.BoatPropertyKt;
import org.jglrxavpok.moarboats.common.state.BooleanBoatProperty;
import org.jglrxavpok.moarboats.common.state.FloatBoatProperty;
import org.jglrxavpok.moarboats.extensions.MathExtensionsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 72\u00020\u0001:\u00017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H&J\u0010\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020%H&J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\u0018H&J\u000e\u0010(\u001a\u00020'2\u0006\u0010$\u001a\u00020%J\u000e\u0010)\u001a\u00020'2\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010*\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\u0018J\u0010\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u0018H\u0016J\u0010\u0010-\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0018H&J\u0010\u0010.\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0018H&J\u0016\u0010/\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00100\u001a\u00020'J\u0010\u00101\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J \u00102\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H$R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\n\u00a8\u00068"}, d2={"Lorg/jglrxavpok/moarboats/common/modules/BaseEngineModule;", "Lorg/jglrxavpok/moarboats/api/BoatModule;", "()V", "hopperPriority", "", "getHopperPriority", "()I", "lockedByRedstoneProperty", "Lorg/jglrxavpok/moarboats/common/state/BooleanBoatProperty;", "getLockedByRedstoneProperty", "()Lorg/jglrxavpok/moarboats/common/state/BooleanBoatProperty;", "moduleSpot", "Lorg/jglrxavpok/moarboats/api/BoatModule$Spot;", "getModuleSpot", "()Lorg/jglrxavpok/moarboats/api/BoatModule$Spot;", "speedProperty", "Lorg/jglrxavpok/moarboats/common/state/FloatBoatProperty;", "getSpeedProperty", "()Lorg/jglrxavpok/moarboats/common/state/FloatBoatProperty;", "stationaryProperty", "getStationaryProperty", "changeSpeed", "", "boat", "Lorg/jglrxavpok/moarboats/api/IControllable;", "speed", "", "controlBoat", "from", "createGui", "Lnet/minecraft/client/gui/screen/Screen;", "containerID", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "estimatedTotalTicks", "getFuelTime", "fuelItem", "Lnet/minecraft/item/ItemStack;", "hasFuel", "", "isItemFuel", "isLockedByRedstone", "isStationary", "onAddition", "to", "remainingTimeInPercent", "remainingTimeInTicks", "setStationary", "newState", "update", "updateFuelState", "state", "Lnet/minecraft/nbt/CompoundNBT;", "inv", "Lnet/minecraft/inventory/IInventory;", "Companion", "moarboats"})
public abstract class BaseEngineModule
extends BoatModule {
    @NotNull
    private final BooleanBoatProperty stationaryProperty = BoatPropertyKt.BooleanBoatProperty(this, "stationary");
    @NotNull
    private final BooleanBoatProperty lockedByRedstoneProperty = BoatPropertyKt.BooleanBoatProperty(this, "redstoneLocked");
    @NotNull
    private final FloatBoatProperty speedProperty = BoatPropertyKt.FloatBoatProperty(this, "speedSetting");
    @NotNull
    private final BoatModule.Spot moduleSpot = BoatModule.Spot.Engine;
    private final int hopperPriority = 0;
    private static final int SECONDS_TO_TICKS = 20;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final BooleanBoatProperty getStationaryProperty() {
        return this.stationaryProperty;
    }

    @NotNull
    public final BooleanBoatProperty getLockedByRedstoneProperty() {
        return this.lockedByRedstoneProperty;
    }

    @NotNull
    public final FloatBoatProperty getSpeedProperty() {
        return this.speedProperty;
    }

    @Override
    @NotNull
    public BoatModule.Spot getModuleSpot() {
        return this.moduleSpot;
    }

    @Override
    public int getHopperPriority() {
        return this.hopperPriority;
    }

    public abstract boolean hasFuel(@NotNull IControllable var1);

    public abstract int getFuelTime(@NotNull ItemStack var1);

    protected abstract void updateFuelState(@NotNull IControllable var1, @NotNull CompoundNBT var2, @NotNull IInventory var3);

    public abstract float remainingTimeInTicks(@NotNull IControllable var1);

    public abstract float remainingTimeInPercent(@NotNull IControllable var1);

    public abstract float estimatedTotalTicks(@NotNull IControllable var1);

    public final boolean isStationary(@NotNull IControllable from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        return (Boolean)this.stationaryProperty.get(from) != false || Intrinsics.areEqual((Object)from.getBlockedReason(), (Object)NoBlockReason.INSTANCE) ^ true;
    }

    @Override
    public void controlBoat(@NotNull IControllable from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        if (this.hasFuel(from) && !this.isStationary(from) && from.inLiquid()) {
            float speed = from.isSpeedImposed() ? from.getImposedSpeed() : ((Number)this.speedProperty.get(from)).floatValue();
            from.accelerate(speed + 1.0f);
        }
        if (((Boolean)this.lockedByRedstoneProperty.get(from)).booleanValue()) {
            if (!from.getWorldRef().field_72995_K) {
                Object v0;
                block8: {
                    Iterable $receiver$iv = from.getModules();
                    for (Object element$iv : $receiver$iv) {
                        BoatModule it = (BoatModule)element$iv;
                        boolean bl = false;
                        if (!(it.getModuleSpot() == BoatModule.Spot.Storage)) continue;
                        v0 = element$iv;
                        break block8;
                    }
                    v0 = null;
                }
                BoatModule storage = v0;
                if (storage != null && storage.getUsesInventory()) {
                    BlockState blockState;
                    BlockPos hopperPos = new BlockPos(from.getCorrespondingEntity()).func_177984_a();
                    BlockState blockState2 = blockState = from.getWorldRef().func_180495_p(hopperPos);
                    Intrinsics.checkExpressionValueIsNotNull((Object)blockState2, (String)"blockState");
                    if (blockState2.func_177230_c() instanceof HopperBlock) {
                        TileEntity tileEntity = from.getWorldRef().func_175625_s(hopperPos);
                        if (tileEntity == null) {
                            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.tileentity.HopperTileEntity");
                        }
                        HopperTileEntity te = (HopperTileEntity)tileEntity;
                        BoatModuleInventory storageInventory = from.getInventory(storage);
                        if (!storageInventory.canAddAnyFrom((IInventory)te)) {
                            return;
                        }
                    }
                }
            }
            from.blockMovement(BlockedByRedstone.INSTANCE);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public Screen createGui(int containerID, @NotNull PlayerEntity player, @NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        PlayerInventory playerInventory = player.field_71071_by;
        Intrinsics.checkExpressionValueIsNotNull((Object)playerInventory, (String)"player.inventory");
        BoatModule boatModule = this;
        ContainerBoatModule<?> containerBoatModule = this.createContainer(containerID, player, boat);
        if (containerBoatModule == null) {
            Intrinsics.throwNpe();
        }
        return (Screen)new GuiEngineModule(playerInventory, boatModule, boat, containerBoatModule);
    }

    @Override
    public void onAddition(@NotNull IControllable to) {
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        this.stationaryProperty.set(to, true);
        this.lockedByRedstoneProperty.set(to, false);
        this.speedProperty.set(to, Float.valueOf(0.0f));
    }

    @Override
    public void update(@NotNull IControllable from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        CompoundNBT state = this.getState(from);
        if (this.getUsesInventory()) {
            BoatModuleInventory inv = this.getInventory(from);
            this.updateFuelState(from, state, (IInventory)inv);
        }
        World world = from.getWorldRef();
        this.lockedByRedstoneProperty.set(from, world.func_175640_z(new BlockPos(from.getPositionX(), from.getPositionY() + 0.5, from.getPositionZ())));
        this.saveState(from);
        if (this.hasFuel(from) && !this.isStationary(from)) {
            int count = (int)(Math.random() * (double)5 + (double)3);
            double posX = from.getPositionX();
            double posY = from.getPositionY();
            double posZ = from.getPositionZ();
            float rotationYaw = from.getYaw();
            float angle = MathExtensionsKt.toRadians(rotationYaw + 90.0f);
            float distAlongLength = -1.0625f;
            BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185345_c((double)posX, (double)(posY - 0.5), (double)posZ);
            BlockState blockState = from.getWorldRef().func_180495_p((BlockPos)pos);
            int n = count;
            for (int j = 0; j < n; ++j) {
                int it = j;
                boolean bl = false;
                double distAlongWidth = (double)0.5f * (Math.random() * 2.0 - 1.0);
                double anchorX = posX + (double)(MathHelper.func_76134_b((float)angle) * distAlongLength) + (double)MathHelper.func_76126_a((float)angle) * distAlongWidth;
                double anchorY = posY + (double)0.25f;
                double anchorZ = posZ + (double)(MathHelper.func_76126_a((float)angle) * distAlongLength) - (double)MathHelper.func_76134_b((float)angle) * distAlongWidth;
                BlockState blockState2 = blockState;
                Intrinsics.checkExpressionValueIsNotNull((Object)blockState2, (String)"blockState");
                IParticleData particle = Intrinsics.areEqual((Object)blockState2.func_185904_a(), (Object)Material.field_151586_h) ? (IParticleData)ParticleTypes.field_197618_k : (Intrinsics.areEqual((Object)blockState.func_185904_a(), (Object)Material.field_151587_i) ? (IParticleData)ParticleTypes.field_197617_j : (IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockState));
                from.getWorldRef().func_195594_a(particle, anchorX, anchorY, anchorZ, -from.getVelocityX(), 1.0, -from.getVelocityZ());
            }
            pos.close();
        }
    }

    public final void setStationary(@NotNull IControllable boat, boolean newState) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        boolean isStationary = (Boolean)this.stationaryProperty.get(boat);
        this.stationaryProperty.set(boat, newState);
    }

    public final void changeSpeed(@NotNull IControllable boat, float speed) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        this.speedProperty.set(boat, Float.valueOf(speed));
    }

    public final boolean isItemFuel(@NotNull ItemStack fuelItem) {
        Intrinsics.checkParameterIsNotNull((Object)fuelItem, (String)"fuelItem");
        return this.getFuelTime(fuelItem) > 0;
    }

    public final boolean isLockedByRedstone(@NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        return (Boolean)this.lockedByRedstoneProperty.get(boat);
    }

    static {
        SECONDS_TO_TICKS = 20;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jglrxavpok/moarboats/common/modules/BaseEngineModule$Companion;", "", "()V", "SECONDS_TO_TICKS", "", "getSECONDS_TO_TICKS", "()I", "moarboats"})
    public static final class Companion {
        public final int getSECONDS_TO_TICKS() {
            return SECONDS_TO_TICKS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

