/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.modules;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.api.BoatModule;
import org.jglrxavpok.moarboats.api.IControllable;
import org.jglrxavpok.moarboats.client.gui.GuiNoConfigModule;
import org.jglrxavpok.moarboats.common.MoarBoatsConfig;
import org.jglrxavpok.moarboats.common.containers.ContainerBoatModule;
import org.jglrxavpok.moarboats.common.containers.EmptyModuleContainer;
import org.jglrxavpok.moarboats.common.items.ChunkLoaderItem;
import org.jglrxavpok.moarboats.extensions.MathExtensionsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J&\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0018H\u0016J \u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0018H\u0016J\u0018\u0010!\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\rH\u0016J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0018H\u0002J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u0018H\u0016J\u001a\u0010&\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u00182\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J(\u0010)\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\rH\u0016J\u0010\u0010-\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\"\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000e\u00a8\u0006."}, d2={"Lorg/jglrxavpok/moarboats/common/modules/ChunkLoadingModule;", "Lorg/jglrxavpok/moarboats/api/BoatModule;", "()V", "corners", "", "Lkotlin/Pair;", "", "[Lkotlin/Pair;", "id", "Lnet/minecraft/util/ResourceLocation;", "getId", "()Lnet/minecraft/util/ResourceLocation;", "isMenuInteresting", "", "()Z", "moduleSpot", "Lorg/jglrxavpok/moarboats/api/BoatModule$Spot;", "getModuleSpot", "()Lorg/jglrxavpok/moarboats/api/BoatModule$Spot;", "usesInventory", "getUsesInventory", "controlBoat", "", "from", "Lorg/jglrxavpok/moarboats/api/IControllable;", "createContainer", "Lorg/jglrxavpok/moarboats/common/containers/ContainerBoatModule;", "containerID", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "boat", "createGui", "Lorg/jglrxavpok/moarboats/client/gui/GuiNoConfigModule;", "dropItemsOnDeath", "killedByPlayerInCreative", "forceChunks", "onAddition", "to", "onInit", "fromItem", "Lnet/minecraft/item/ItemStack;", "onInteract", "hand", "Lnet/minecraft/util/Hand;", "sneaking", "update", "moarboats"})
public final class ChunkLoadingModule
extends BoatModule {
    @NotNull
    private static final ResourceLocation id;
    private static final boolean usesInventory = false;
    @NotNull
    private static final BoatModule.Spot moduleSpot;
    private static final boolean isMenuInteresting = false;
    private static final Pair<Integer, Integer>[] corners;
    public static final ChunkLoadingModule INSTANCE;

    @Override
    @NotNull
    public ResourceLocation getId() {
        return id;
    }

    @Override
    public boolean getUsesInventory() {
        return usesInventory;
    }

    @Override
    @NotNull
    public BoatModule.Spot getModuleSpot() {
        return moduleSpot;
    }

    @Override
    public boolean isMenuInteresting() {
        return isMenuInteresting;
    }

    @Override
    public boolean onInteract(@NotNull IControllable from, @NotNull PlayerEntity player, @NotNull Hand hand, boolean sneaking) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        return false;
    }

    @Override
    public void controlBoat(@NotNull IControllable from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
    }

    @Override
    public void update(@NotNull IControllable from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        if (!((Boolean)MoarBoatsConfig.chunkLoader.getAllowed().get()).booleanValue()) {
            return;
        }
        World world = from.func_197524_h();
        if (world == null) {
            Intrinsics.throwNpe();
        }
        if (!world.field_72995_K) {
            this.forceChunks(from);
            return;
        }
        World world2 = from.func_197524_h();
        if (world2 == null) {
            Intrinsics.throwNpe();
        }
        if (!world2.field_72995_K) {
            return;
        }
        double yaw = MathExtensionsKt.toRadians(from.getYaw() + 90.0f);
        float width = 0.9375f;
        float length = 0.5f;
        World world3 = from.getWorldRef();
        for (Pair<Integer, Integer> pair : corners) {
            int x = ((Number)pair.component1()).intValue();
            int z = ((Number)pair.component2()).intValue();
            double posX = from.getPositionX() + (double)((float)x * width) * Math.cos(yaw) + (double)((float)z * length) * Math.sin(yaw);
            double posZ = from.getPositionZ() + (double)((float)x * width) * Math.sin(yaw) - (double)((float)z * length) * Math.cos(yaw);
            double posY = from.getPositionY();
            double vx = (Math.random() * (double)2 - 1.0) * 0.2;
            double vy = 0.3;
            double vz = (Math.random() * (double)2 - 1.0) * 0.2;
            world3.func_195594_a((IParticleData)ParticleTypes.field_197599_J, posX, posY, posZ, vx, vy, vz);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void forceChunks(IControllable boat) {
        ChunkPos centerPos = new ChunkPos(boat.getCorrespondingEntity().field_70176_ah, boat.getCorrespondingEntity().field_70164_aj);
        int n = -2;
        int n2 = 2;
        while (n <= n2) {
            void i2;
            int n3 = -2;
            int n4 = 2;
            while (n3 <= n4) {
                void j;
                boat.forceChunkLoad(centerPos.field_77276_a + i2, centerPos.field_77275_b + j);
                ++j;
            }
            ++i2;
        }
    }

    @Override
    public void onInit(@NotNull IControllable to, @Nullable ItemStack fromItem) {
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        super.onInit(to, fromItem);
        if (!((Boolean)MoarBoatsConfig.chunkLoader.getAllowed().get()).booleanValue()) {
            return;
        }
        World world = to.func_197524_h();
        if (world == null) {
            Intrinsics.throwNpe();
        }
        if (!world.field_72995_K) {
            this.forceChunks(to);
        }
    }

    @Override
    public void onAddition(@NotNull IControllable to) {
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
    }

    @Override
    @Nullable
    public ContainerBoatModule<?> createContainer(int containerID, @NotNull PlayerEntity player, @NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        PlayerInventory playerInventory = player.field_71071_by;
        Intrinsics.checkExpressionValueIsNotNull((Object)playerInventory, (String)"player.inventory");
        return new EmptyModuleContainer(containerID, playerInventory, this, boat, false, 0, 48, null);
    }

    @NotNull
    public GuiNoConfigModule createGui(int containerID, @NotNull PlayerEntity player, @NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        PlayerInventory playerInventory = player.field_71071_by;
        Intrinsics.checkExpressionValueIsNotNull((Object)playerInventory, (String)"player.inventory");
        return new GuiNoConfigModule(containerID, playerInventory, this, boat);
    }

    @Override
    public void dropItemsOnDeath(@NotNull IControllable boat, boolean killedByPlayerInCreative) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        if (!killedByPlayerInCreative) {
            boat.getCorrespondingEntity().func_199702_a((IItemProvider)ChunkLoaderItem.INSTANCE, 1);
        }
    }

    private ChunkLoadingModule() {
    }

    static {
        ChunkLoadingModule chunkLoadingModule;
        INSTANCE = chunkLoadingModule = new ChunkLoadingModule();
        id = new ResourceLocation("moarboats", "chunk_loading");
        moduleSpot = BoatModule.Spot.Misc;
        corners = new Pair[]{new Pair((Object)-1, (Object)-1), new Pair((Object)-1, (Object)1), new Pair((Object)1, (Object)1), new Pair((Object)1, (Object)-1)};
    }
}

