/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.modules;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.api.IControllable;
import org.jglrxavpok.moarboats.common.state.IntBoatProperty;
import org.jglrxavpok.moarboats.common.state.StringBoatProperty;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH&J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH&J\"\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\"\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0017\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH&J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lorg/jglrxavpok/moarboats/common/modules/IFluidBoatModule;", "", "fluidAmountProperty", "Lorg/jglrxavpok/moarboats/common/state/IntBoatProperty;", "getFluidAmountProperty", "()Lorg/jglrxavpok/moarboats/common/state/IntBoatProperty;", "fluidNameProperty", "Lorg/jglrxavpok/moarboats/common/state/StringBoatProperty;", "getFluidNameProperty", "()Lorg/jglrxavpok/moarboats/common/state/StringBoatProperty;", "canBeDrained", "", "boat", "Lorg/jglrxavpok/moarboats/api/IControllable;", "fluidStack", "Lnet/minecraftforge/fluids/FluidStack;", "canBeFilled", "drain", "amount", "", "action", "Lnet/minecraftforge/fluids/capability/IFluidHandler$FluidAction;", "resource", "fill", "getCapacity", "getContents", "getFluidAmount", "getFluidInside", "Lnet/minecraft/fluid/Fluid;", "moarboats"})
public interface IFluidBoatModule {
    @NotNull
    public StringBoatProperty getFluidNameProperty();

    @NotNull
    public IntBoatProperty getFluidAmountProperty();

    public int getCapacity(@NotNull IControllable var1);

    public boolean canBeFilled(@NotNull IControllable var1);

    public boolean canBeDrained(@NotNull IControllable var1);

    public boolean canBeFilled(@NotNull IControllable var1, @NotNull FluidStack var2);

    public boolean canBeDrained(@NotNull IControllable var1, @NotNull FluidStack var2);

    @Nullable
    public FluidStack getContents(@NotNull IControllable var1);

    @Nullable
    public Fluid getFluidInside(@NotNull IControllable var1);

    public int getFluidAmount(@NotNull IControllable var1);

    public int fill(@NotNull IControllable var1, @NotNull FluidStack var2, @NotNull IFluidHandler.FluidAction var3);

    @Nullable
    public FluidStack drain(@NotNull IControllable var1, @NotNull FluidStack var2, @NotNull IFluidHandler.FluidAction var3);

    @Nullable
    public FluidStack drain(@NotNull IControllable var1, int var2, @NotNull IFluidHandler.FluidAction var3);

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Nullable
        public static FluidStack getContents(IFluidBoatModule $this, @NotNull IControllable boat) {
            Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
            Fluid fluid = $this.getFluidInside(boat);
            if (fluid == null) {
                return null;
            }
            Fluid fluid2 = fluid;
            return new FluidStack(fluid2, ((Number)$this.getFluidAmountProperty().get(boat)).intValue());
        }

        @Nullable
        public static Fluid getFluidInside(IFluidBoatModule $this, @NotNull IControllable boat) {
            Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
            String name = (String)$this.getFluidNameProperty().get(boat);
            return (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(name));
        }

        public static int getFluidAmount(IFluidBoatModule $this, @NotNull IControllable boat) {
            Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
            return ((Number)$this.getFluidAmountProperty().get(boat)).intValue();
        }

        public static int fill(IFluidBoatModule $this, @NotNull IControllable boat, @NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
            Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
            Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
            Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
            boolean simulate = action.simulate();
            if (!$this.canBeFilled(boat)) {
                return 0;
            }
            if (!$this.canBeFilled(boat, resource)) {
                return 0;
            }
            Fluid fluid = $this.getFluidInside(boat);
            if (Intrinsics.areEqual((Object)fluid, (Object)resource.getFluid()) ^ true && $this.getFluidAmount(boat) > 0) {
                return 0;
            }
            StringBoatProperty stringBoatProperty = $this.getFluidNameProperty();
            Fluid fluid2 = resource.getFluid();
            Intrinsics.checkExpressionValueIsNotNull((Object)fluid2, (String)"resource.fluid");
            stringBoatProperty.set(boat, String.valueOf(fluid2.getRegistryName()));
            int n = resource.getAmount();
            int n2 = $this.getCapacity(boat) - $this.getFluidAmount(boat);
            int filled = Math.min(n, n2);
            if (!simulate) {
                IntBoatProperty intBoatProperty = $this.getFluidAmountProperty();
                IControllable iControllable = boat;
                intBoatProperty.set(iControllable, ((Number)intBoatProperty.get(iControllable)).intValue() + filled);
            }
            return filled;
        }

        @Nullable
        public static FluidStack drain(IFluidBoatModule $this, @NotNull IControllable boat, @NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
            Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
            Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
            Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
            if (!$this.canBeDrained(boat)) {
                return null;
            }
            if (!$this.canBeDrained(boat, resource)) {
                return null;
            }
            Fluid fluid = $this.getFluidInside(boat);
            if (fluid == null) {
                return null;
            }
            Fluid fluid2 = fluid;
            Fluid fluid3 = resource.getFluid();
            Intrinsics.checkExpressionValueIsNotNull((Object)fluid3, (String)"resource.fluid");
            if (Intrinsics.areEqual((Object)fluid3.getRegistryName(), (Object)fluid2.getRegistryName())) {
                return $this.drain(boat, resource.getAmount(), action);
            }
            return null;
        }

        @Nullable
        public static FluidStack drain(IFluidBoatModule $this, @NotNull IControllable boat, int amount, @NotNull IFluidHandler.FluidAction action) {
            Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
            Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
            if (!$this.canBeDrained(boat)) {
                return null;
            }
            Fluid fluid = $this.getFluidInside(boat);
            if (fluid == null) {
                return null;
            }
            Fluid fluid2 = fluid;
            int n = $this.getFluidAmount(boat);
            int drained = Math.min(amount, n);
            if (action.execute()) {
                IntBoatProperty intBoatProperty = $this.getFluidAmountProperty();
                IControllable iControllable = boat;
                intBoatProperty.set(iControllable, ((Number)intBoatProperty.get(iControllable)).intValue() - drained);
            }
            return new FluidStack(fluid2, drained);
        }
    }
}

