/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.modules;

import kotlin.Metadata;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.api.IControllable;
import org.jglrxavpok.moarboats.common.containers.ContainerBoatModule;
import org.jglrxavpok.moarboats.common.containers.EmptyModuleContainer;
import org.jglrxavpok.moarboats.common.items.OarsItem;
import org.jglrxavpok.moarboats.common.modules.BaseEngineModule;
import org.jglrxavpok.moarboats.common.modules.BlockReason;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\tH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\u0010\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\u000fH\u0016J(\u0010\"\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\tH\u0016J\u0010\u0010&\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010(\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006-"}, d2={"Lorg/jglrxavpok/moarboats/common/modules/OarEngineModule;", "Lorg/jglrxavpok/moarboats/common/modules/BaseEngineModule;", "Lorg/jglrxavpok/moarboats/common/modules/BlockReason;", "()V", "id", "Lnet/minecraft/util/ResourceLocation;", "getId", "()Lnet/minecraft/util/ResourceLocation;", "usesInventory", "", "getUsesInventory", "()Z", "controlBoat", "", "from", "Lorg/jglrxavpok/moarboats/api/IControllable;", "createContainer", "Lorg/jglrxavpok/moarboats/common/containers/ContainerBoatModule;", "containerID", "", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "boat", "dropItemsOnDeath", "killedByPlayerInCreative", "estimatedTotalTicks", "", "getFuelTime", "fuelItem", "Lnet/minecraft/item/ItemStack;", "hasFuel", "isOccupied", "onAddition", "to", "onInteract", "hand", "Lnet/minecraft/util/Hand;", "sneaking", "remainingTimeInPercent", "remainingTimeInTicks", "updateFuelState", "state", "Lnet/minecraft/nbt/CompoundNBT;", "inv", "Lnet/minecraft/inventory/IInventory;", "moarboats"})
public final class OarEngineModule
extends BaseEngineModule
implements BlockReason {
    @NotNull
    private static final ResourceLocation id;
    private static final boolean usesInventory = false;
    public static final OarEngineModule INSTANCE;

    @Override
    @Nullable
    public ContainerBoatModule<?> createContainer(int containerID, @NotNull PlayerEntity player, @NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        PlayerInventory playerInventory = player.field_71071_by;
        Intrinsics.checkExpressionValueIsNotNull((Object)playerInventory, (String)"player.inventory");
        return new EmptyModuleContainer(containerID, playerInventory, this, boat, true, 0, 32, null);
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return id;
    }

    @Override
    public boolean getUsesInventory() {
        return usesInventory;
    }

    private final boolean isOccupied(IControllable boat) {
        return boat.getCorrespondingEntity().func_184179_bs() != null;
    }

    @Override
    public void controlBoat(@NotNull IControllable from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Entity entity = from.getCorrespondingEntity().func_184179_bs();
        if (!(entity instanceof PlayerEntity)) {
            entity = null;
        }
        PlayerEntity playerEntity = (PlayerEntity)entity;
        if (playerEntity == null) {
            return;
        }
        PlayerEntity controllingEntity = playerEntity;
        float forward = controllingEntity.field_191988_bg;
        float strafe = controllingEntity.field_70702_br;
        float forwardMultiplier = 0.75f;
        float strafeMultiplier = 0.75f;
        if (forward > 0.001f) {
            from.accelerate(forward * forwardMultiplier);
        }
        if (forward < -0.001f) {
            from.decelerate(-forward);
        }
        from.turnLeft(strafe * strafeMultiplier);
    }

    @Override
    public float estimatedTotalTicks(@NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        return this.isOccupied(boat) ? FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY() : 0.0f;
    }

    @Override
    public float remainingTimeInTicks(@NotNull IControllable from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        return this.isOccupied(from) ? FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY() : 0.0f;
    }

    @Override
    public float remainingTimeInPercent(@NotNull IControllable from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        return this.isOccupied(from) ? FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY() : 0.0f;
    }

    @Override
    public void onAddition(@NotNull IControllable to) {
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        super.onAddition(to);
        this.getStationaryProperty().set(to, false);
    }

    @Override
    public boolean onInteract(@NotNull IControllable from, @NotNull PlayerEntity player, @NotNull Hand hand, boolean sneaking) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        return false;
    }

    @Override
    public boolean hasFuel(@NotNull IControllable from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        return this.isOccupied(from);
    }

    @Override
    protected void updateFuelState(@NotNull IControllable boat, @NotNull CompoundNBT state, @NotNull IInventory inv) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)inv, (String)"inv");
    }

    @Override
    public int getFuelTime(@NotNull ItemStack fuelItem) {
        Intrinsics.checkParameterIsNotNull((Object)fuelItem, (String)"fuelItem");
        return 0;
    }

    @Override
    public void dropItemsOnDeath(@NotNull IControllable boat, boolean killedByPlayerInCreative) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        if (!killedByPlayerInCreative) {
            boat.getCorrespondingEntity().func_199702_a((IItemProvider)OarsItem.INSTANCE, 1);
        }
    }

    private OarEngineModule() {
    }

    static {
        OarEngineModule oarEngineModule;
        INSTANCE = oarEngineModule = new OarEngineModule();
        id = new ResourceLocation("moarboats:oar_engine");
    }

    @Override
    public boolean blocksSpeed() {
        return BlockReason.DefaultImpls.blocksSpeed(this);
    }

    @Override
    public boolean blocksRotation() {
        return BlockReason.DefaultImpls.blocksRotation(this);
    }
}

