/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.modules;

import kotlin.Metadata;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.api.IControllable;
import org.jglrxavpok.moarboats.common.containers.ContainerBoatModule;
import org.jglrxavpok.moarboats.common.containers.EmptyModuleContainer;
import org.jglrxavpok.moarboats.common.modules.BaseEngineModule;
import org.jglrxavpok.moarboats.common.state.BoatPropertyKt;
import org.jglrxavpok.moarboats.common.state.BooleanBoatProperty;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\fH\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u0016H\u0016J(\u0010!\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\fH\u0016J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u0016H\u0016J\u0010\u0010&\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u0016H\u0016J \u0010'\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006,"}, d2={"Lorg/jglrxavpok/moarboats/common/modules/SolarEngineModule;", "Lorg/jglrxavpok/moarboats/common/modules/BaseEngineModule;", "()V", "id", "Lnet/minecraft/util/ResourceLocation;", "getId", "()Lnet/minecraft/util/ResourceLocation;", "invertedProperty", "Lorg/jglrxavpok/moarboats/common/state/BooleanBoatProperty;", "getInvertedProperty", "()Lorg/jglrxavpok/moarboats/common/state/BooleanBoatProperty;", "usesInventory", "", "getUsesInventory", "()Z", "createContainer", "Lorg/jglrxavpok/moarboats/common/containers/ContainerBoatModule;", "containerID", "", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "boat", "Lorg/jglrxavpok/moarboats/api/IControllable;", "dropItemsOnDeath", "", "killedByPlayerInCreative", "estimatedTotalTicks", "", "getFuelTime", "fuelItem", "Lnet/minecraft/item/ItemStack;", "hasFuel", "from", "onInteract", "hand", "Lnet/minecraft/util/Hand;", "sneaking", "remainingTimeInPercent", "remainingTimeInTicks", "updateFuelState", "state", "Lnet/minecraft/nbt/CompoundNBT;", "inv", "Lnet/minecraft/inventory/IInventory;", "moarboats"})
public final class SolarEngineModule
extends BaseEngineModule {
    @NotNull
    private static final BooleanBoatProperty invertedProperty;
    @NotNull
    private static final ResourceLocation id;
    private static final boolean usesInventory = false;
    public static final SolarEngineModule INSTANCE;

    @NotNull
    public final BooleanBoatProperty getInvertedProperty() {
        return invertedProperty;
    }

    @Override
    @Nullable
    public ContainerBoatModule<?> createContainer(int containerID, @NotNull PlayerEntity player, @NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        PlayerInventory playerInventory = player.field_71071_by;
        Intrinsics.checkExpressionValueIsNotNull((Object)playerInventory, (String)"player.inventory");
        return new EmptyModuleContainer(containerID, playerInventory, this, boat, true, 0, 32, null);
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return id;
    }

    @Override
    public boolean getUsesInventory() {
        return usesInventory;
    }

    @Override
    public float estimatedTotalTicks(@NotNull IControllable boat) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        return FloatCompanionObject.INSTANCE.getNaN();
    }

    @Override
    public float remainingTimeInTicks(@NotNull IControllable from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        return FloatCompanionObject.INSTANCE.getNaN();
    }

    @Override
    public float remainingTimeInPercent(@NotNull IControllable from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        World levelIn = from.getWorldRef();
        BlockPos pos = from.getCorrespondingEntity().func_180425_c();
        int diff = levelIn.func_175642_b(LightType.SKY, pos) - levelIn.func_175657_ab();
        float angle = levelIn.func_72826_c(1.0f);
        if (((Boolean)invertedProperty.get(from)).booleanValue()) {
            diff = 15 - diff;
        }
        if (diff > 0 && !((Boolean)invertedProperty.get(from)).booleanValue()) {
            float f1 = angle < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            angle += (f1 - angle) * 0.2f;
            diff = MathKt.roundToInt((float)((float)diff * MathHelper.func_76134_b((float)angle)));
        }
        return (float)MathHelper.func_76125_a((int)diff, (int)0, (int)15) / 15.0f;
    }

    @Override
    public boolean onInteract(@NotNull IControllable from, @NotNull PlayerEntity player, @NotNull Hand hand, boolean sneaking) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        if (sneaking) {
            ItemStack itemStack = player.func_184586_b(hand);
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"player.getHeldItem(hand)");
            if (itemStack.func_190926_b()) {
                invertedProperty.set(from, (Boolean)invertedProperty.get(from) == false);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasFuel(@NotNull IControllable from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        return this.remainingTimeInPercent(from) >= 0.06666667f;
    }

    @Override
    protected void updateFuelState(@NotNull IControllable boat, @NotNull CompoundNBT state, @NotNull IInventory inv) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)inv, (String)"inv");
    }

    @Override
    public int getFuelTime(@NotNull ItemStack fuelItem) {
        Intrinsics.checkParameterIsNotNull((Object)fuelItem, (String)"fuelItem");
        return 0;
    }

    @Override
    public void dropItemsOnDeath(@NotNull IControllable boat, boolean killedByPlayerInCreative) {
        Intrinsics.checkParameterIsNotNull((Object)boat, (String)"boat");
        if (!killedByPlayerInCreative) {
            boat.getCorrespondingEntity().func_199702_a((IItemProvider)Blocks.field_150453_bW.func_199767_j(), 1);
        }
    }

    private SolarEngineModule() {
    }

    static {
        SolarEngineModule solarEngineModule;
        INSTANCE = solarEngineModule = new SolarEngineModule();
        invertedProperty = BoatPropertyKt.BooleanBoatProperty(solarEngineModule, "inverted");
        id = new ResourceLocation("moarboats:solar_engine");
    }
}

